/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.block.base;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.block.base.BlockString;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockStringStairs
extends BlockString {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    protected static final AxisAlignedBB AABB_SLAB_TOP = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_QTR_TOP_WEST = new AxisAlignedBB(0.0, 0.5, 0.0, 0.5, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_QTR_TOP_EAST = new AxisAlignedBB(0.5, 0.5, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_QTR_TOP_NORTH = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 0.5);
    protected static final AxisAlignedBB AABB_QTR_TOP_SOUTH = new AxisAlignedBB(0.0, 0.5, 0.5, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_OCT_TOP_NW = new AxisAlignedBB(0.0, 0.5, 0.0, 0.5, 1.0, 0.5);
    protected static final AxisAlignedBB AABB_OCT_TOP_NE = new AxisAlignedBB(0.5, 0.5, 0.0, 1.0, 1.0, 0.5);
    protected static final AxisAlignedBB AABB_OCT_TOP_SW = new AxisAlignedBB(0.0, 0.5, 0.5, 0.5, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_OCT_TOP_SE = new AxisAlignedBB(0.5, 0.5, 0.5, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_SLAB_BOTTOM = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_QTR_BOT_WEST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_QTR_BOT_EAST = new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_QTR_BOT_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 0.5);
    protected static final AxisAlignedBB AABB_QTR_BOT_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_OCT_BOT_NW = new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 0.5, 0.5);
    protected static final AxisAlignedBB AABB_OCT_BOT_NE = new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 0.5, 0.5);
    protected static final AxisAlignedBB AABB_OCT_BOT_SW = new AxisAlignedBB(0.0, 0.0, 0.5, 0.5, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_OCT_BOT_SE = new AxisAlignedBB(0.5, 0.0, 0.5, 1.0, 0.5, 1.0);

    public BlockStringStairs(Material material, String[] values, String propName) {
        super(material, values, propName);
    }

    public BlockStringStairs(Material material, String[] values) {
        this(material, values, "type");
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn) {
        state = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        for (AxisAlignedBB axisalignedbb : BlockStringStairs.getCollisionBoxList(state)) {
            BlockStringStairs.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)axisalignedbb);
        }
    }

    private static List<AxisAlignedBB> getCollisionBoxList(IBlockState state) {
        ArrayList list = Lists.newArrayList();
        boolean flag = state.func_177229_b((IProperty)BlockStairs.field_176308_b) == BlockStairs.EnumHalf.TOP;
        list.add(flag ? AABB_SLAB_TOP : AABB_SLAB_BOTTOM);
        BlockStairs.EnumShape stairShape = (BlockStairs.EnumShape)state.func_177229_b((IProperty)BlockStairs.field_176310_M);
        if (stairShape == BlockStairs.EnumShape.STRAIGHT || stairShape == BlockStairs.EnumShape.INNER_LEFT || stairShape == BlockStairs.EnumShape.INNER_RIGHT) {
            list.add(BlockStringStairs.getCollQuarterBlock(state));
        }
        if (stairShape != BlockStairs.EnumShape.STRAIGHT) {
            list.add(BlockStringStairs.getCollEighthBlock(state));
        }
        return list;
    }

    private static AxisAlignedBB getCollQuarterBlock(IBlockState state) {
        boolean flag = state.func_177229_b((IProperty)BlockStairs.field_176308_b) == BlockStairs.EnumHalf.TOP;
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            default: {
                return flag ? AABB_QTR_BOT_NORTH : AABB_QTR_TOP_NORTH;
            }
            case SOUTH: {
                return flag ? AABB_QTR_BOT_SOUTH : AABB_QTR_TOP_SOUTH;
            }
            case WEST: {
                return flag ? AABB_QTR_BOT_WEST : AABB_QTR_TOP_WEST;
            }
            case EAST: 
        }
        return flag ? AABB_QTR_BOT_EAST : AABB_QTR_TOP_EAST;
    }

    private static AxisAlignedBB getCollEighthBlock(IBlockState state) {
        EnumFacing newFacing;
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch ((BlockStairs.EnumShape)state.func_177229_b((IProperty)BlockStairs.field_176310_M)) {
            default: {
                newFacing = facing;
                break;
            }
            case OUTER_RIGHT: {
                newFacing = facing.func_176746_e();
                break;
            }
            case INNER_RIGHT: {
                newFacing = facing.func_176734_d();
                break;
            }
            case INNER_LEFT: {
                newFacing = facing.func_176735_f();
            }
        }
        boolean isTop = state.func_177229_b((IProperty)BlockStairs.field_176308_b) == BlockStairs.EnumHalf.TOP;
        switch (newFacing) {
            default: {
                return isTop ? AABB_OCT_BOT_NW : AABB_OCT_TOP_NW;
            }
            case SOUTH: {
                return isTop ? AABB_OCT_BOT_SE : AABB_OCT_TOP_SE;
            }
            case WEST: {
                return isTop ? AABB_OCT_BOT_SW : AABB_OCT_TOP_SW;
            }
            case EAST: 
        }
        return isTop ? AABB_OCT_BOT_NE : AABB_OCT_TOP_NE;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer);
        state = state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()).func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.STRAIGHT);
        return facing != EnumFacing.DOWN && (facing == EnumFacing.UP || (double)hitY <= 0.5) ? state.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM) : state.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP);
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList list = Lists.newArrayList();
        for (AxisAlignedBB axisalignedbb : BlockStringStairs.getCollisionBoxList(this.func_176221_a(blockState, (IBlockAccess)worldIn, pos))) {
            list.add(this.func_185503_a(pos, start, end, axisalignedbb));
        }
        RayTraceResult rayTrace = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            rayTrace = raytraceresult;
            d1 = d0;
        }
        return rayTrace;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176194_O().func_177621_b().func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)((meta & 8) > 0 ? BlockStairs.EnumHalf.TOP : BlockStairs.EnumHalf.BOTTOM));
        state = state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(5 - (meta & 6) / 2))).func_177226_a((IProperty)this.getStringProp(), (Comparable)((Object)this.getValues().get(meta % 2)));
        return state;
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (state.func_177229_b((IProperty)BlockStairs.field_176308_b) == BlockStairs.EnumHalf.TOP) {
            i |= 4;
        }
        return (i |= 5 - ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a()) * 2 + this.getValues().indexOf(state.func_177229_b((IProperty)this.getStringProp()));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStringStairs.getStairsShape(state, worldIn, pos));
    }

    private static BlockStairs.EnumShape getStairsShape(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing oppositeOffsetFacing;
        EnumFacing offsetFacing;
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        IBlockState offsetState = world.func_180495_p(pos.func_177972_a(facing));
        if (BlockStringStairs.isBlockStairs(offsetState) && state.func_177229_b((IProperty)BlockStairs.field_176308_b) == offsetState.func_177229_b((IProperty)BlockStairs.field_176308_b) && (offsetFacing = (EnumFacing)offsetState.func_177229_b((IProperty)FACING)).func_176740_k() != ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176740_k() && BlockStringStairs.isDifferentStairs(state, world, pos, offsetFacing.func_176734_d())) {
            if (offsetFacing == facing.func_176735_f()) {
                return BlockStairs.EnumShape.OUTER_LEFT;
            }
            return BlockStairs.EnumShape.OUTER_RIGHT;
        }
        IBlockState oppositeOffsetState = world.func_180495_p(pos.func_177972_a(facing.func_176734_d()));
        if (BlockStringStairs.isBlockStairs(oppositeOffsetState) && state.func_177229_b((IProperty)BlockStairs.field_176308_b) == oppositeOffsetState.func_177229_b((IProperty)BlockStairs.field_176308_b) && (oppositeOffsetFacing = (EnumFacing)oppositeOffsetState.func_177229_b((IProperty)FACING)).func_176740_k() != ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176740_k() && BlockStringStairs.isDifferentStairs(state, world, pos, oppositeOffsetFacing)) {
            if (oppositeOffsetFacing == facing.func_176735_f()) {
                return BlockStairs.EnumShape.INNER_LEFT;
            }
            return BlockStairs.EnumShape.INNER_RIGHT;
        }
        return BlockStairs.EnumShape.STRAIGHT;
    }

    private static boolean isDifferentStairs(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing facing) {
        IBlockState offsetState = world.func_180495_p(pos.func_177972_a(facing));
        return !BlockStringStairs.isBlockStairs(offsetState) || offsetState.func_177229_b((IProperty)FACING) != state.func_177229_b((IProperty)FACING) || offsetState.func_177229_b((IProperty)BlockStairs.field_176308_b) != state.func_177229_b((IProperty)BlockStairs.field_176308_b);
    }

    public static boolean isBlockStairs(IBlockState state) {
        return state.func_177230_c() instanceof BlockStairs || state.func_177230_c() instanceof BlockStringStairs;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        BlockStairs.EnumShape stairShape = (BlockStairs.EnumShape)state.func_177229_b((IProperty)BlockStairs.field_176310_M);
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                if (facing.func_176740_k() != EnumFacing.Axis.Z) break;
                switch (stairShape) {
                    case OUTER_LEFT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.OUTER_LEFT);
                    }
                    case INNER_RIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.INNER_LEFT);
                    }
                    case INNER_LEFT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.INNER_RIGHT);
                    }
                }
                return state.func_185907_a(Rotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (facing.func_176740_k() != EnumFacing.Axis.X) break;
                switch (stairShape) {
                    case OUTER_LEFT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.OUTER_LEFT);
                    }
                    case INNER_RIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.INNER_RIGHT);
                    }
                    case INNER_LEFT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.INNER_LEFT);
                    }
                    case STRAIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180);
                    }
                }
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    @Override
    protected BlockStateContainer createRealBlockState() {
        return new ExtendedBlockState((Block)this, new IProperty[]{BlockStairs.field_176308_b, BlockStairs.field_176310_M, FACING, this.getStringProp()}, new IUnlistedProperty[]{this.getUnlistedStringProp()});
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack((Block)this, 1, this.func_180651_a(state));
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return this.getValues().indexOf(state.func_177229_b((IProperty)this.getStringProp()));
    }

    @Override
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.func_180651_a(state));
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (BloodMagic.getCrossVersionProxy().disableStairSlabCulling()) {
            return super.doesSideBlockRendering(state, world, pos, face);
        }
        if (state.func_185914_p()) {
            return true;
        }
        state = this.func_176221_a(state, world, pos);
        BlockStairs.EnumHalf half = (BlockStairs.EnumHalf)state.func_177229_b((IProperty)BlockStairs.field_176308_b);
        EnumFacing side = (EnumFacing)state.func_177229_b((IProperty)FACING);
        BlockStairs.EnumShape shape = (BlockStairs.EnumShape)state.func_177229_b((IProperty)BlockStairs.field_176310_M);
        if (face == EnumFacing.UP) {
            return half == BlockStairs.EnumHalf.TOP;
        }
        if (face == EnumFacing.DOWN) {
            return half == BlockStairs.EnumHalf.BOTTOM;
        }
        if (shape == BlockStairs.EnumShape.OUTER_LEFT || shape == BlockStairs.EnumShape.OUTER_RIGHT) {
            return false;
        }
        if (face == side) {
            return true;
        }
        if (shape == BlockStairs.EnumShape.INNER_LEFT && face.func_176746_e() == side) {
            return true;
        }
        return shape == BlockStairs.EnumShape.INNER_RIGHT && face.func_176735_f() == side;
    }
}

