/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.command;

import WayofTime.bloodmagic.command.ISubCommand;
import WayofTime.bloodmagic.util.helper.TextHelper;
import java.util.Locale;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public abstract class SubCommandBase
implements ISubCommand {
    private ICommand parent;
    private String name;

    public SubCommandBase(ICommand parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    @Override
    public String getSubCommandName() {
        return this.name;
    }

    @Override
    public ICommand getParentCommand() {
        return this.parent;
    }

    @Override
    public void processSubCommand(MinecraftServer server, ICommandSender commandSender, String[] args) {
        if (args.length == 0 && !this.getSubCommandName().equals("help")) {
            SubCommandBase.displayErrorString(commandSender, String.format(TextHelper.localizeEffect("commands.format.error", new Object[0]), this.capitalizeFirstLetter(this.getSubCommandName()), this.getArgUsage(commandSender)), new Object[0]);
        }
        if (this.isBounded(0, 2, args.length) && args[0].equals("help")) {
            SubCommandBase.displayHelpString(commandSender, String.format(TextHelper.localizeEffect("commands.format.help", new Object[0]), this.capitalizeFirstLetter(this.getSubCommandName()), this.getHelpText()), new Object[0]);
        }
    }

    protected String capitalizeFirstLetter(String toCapital) {
        return String.valueOf(toCapital.charAt(0)).toUpperCase(Locale.ENGLISH) + toCapital.substring(1);
    }

    protected boolean isBounded(int low, int high, int given) {
        return given > low && given < high;
    }

    public static void displayHelpString(ICommandSender commandSender, String display, Object ... info) {
        commandSender.func_145747_a((ITextComponent)new TextComponentString(TextHelper.localizeEffect(display, info)));
    }

    public static void displayErrorString(ICommandSender commandSender, String display, Object ... info) {
        commandSender.func_145747_a((ITextComponent)new TextComponentString(TextHelper.localizeEffect(display, info)));
    }

    public static void displaySuccessString(ICommandSender commandSender, String display, Object ... info) {
        commandSender.func_145747_a((ITextComponent)new TextComponentString(TextHelper.localizeEffect(display, info)));
    }
}

