/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.compat.guideapi.book;

import WayofTime.bloodmagic.api.Constants;
import WayofTime.bloodmagic.api.registry.ImperfectRitualRegistry;
import WayofTime.bloodmagic.api.registry.RitualRegistry;
import WayofTime.bloodmagic.api.ritual.Ritual;
import WayofTime.bloodmagic.api.ritual.imperfect.ImperfectRitual;
import WayofTime.bloodmagic.compat.guideapi.entry.EntryText;
import WayofTime.bloodmagic.util.helper.TextHelper;
import amerifrance.guideapi.api.IPage;
import amerifrance.guideapi.api.impl.abstraction.EntryAbstract;
import amerifrance.guideapi.api.util.PageHelper;
import amerifrance.guideapi.page.PageImage;
import amerifrance.guideapi.page.PageText;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

public class CategoryRitual {
    public static Map<ResourceLocation, EntryAbstract> buildCategory() {
        ArrayList<IPage> ritualPages;
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String keyBase = Constants.Mod.DOMAIN + "ritual_";
        for (Ritual ritual : RitualRegistry.getRituals()) {
            ritualPages = new ArrayList<IPage>();
            ritualPages.addAll(PageHelper.pagesForLongText((String)TextHelper.localize(ritual.getUnlocalizedName() + ".info", new Object[0]), (int)370));
            ritualPages.add((IPage)new PageImage(new ResourceLocation("bloodmagicguide", "textures/guide/" + ritual.getName() + ".png")));
            entries.put(new ResourceLocation(keyBase + ritual.getName()), (EntryAbstract)new EntryText(ritualPages, TextHelper.localize(ritual.getUnlocalizedName(), new Object[0])));
        }
        for (ImperfectRitual imperfectRitual : ImperfectRitualRegistry.getRituals()) {
            ritualPages = new ArrayList();
            ritualPages.addAll(PageHelper.pagesForLongText((String)TextHelper.localize(imperfectRitual.getUnlocalizedName() + ".info", new Object[0]), (int)370));
            ritualPages.add((IPage)new PageImage(new ResourceLocation("bloodmagicguide", "textures/guide/" + imperfectRitual.getName() + ".png")));
            entries.put(new ResourceLocation(keyBase + imperfectRitual.getName()), (EntryAbstract)new EntryText(ritualPages, TextHelper.localize(imperfectRitual.getUnlocalizedName(), new Object[0])));
        }
        for (Map.Entry entry : entries.entrySet()) {
            for (IPage page : ((EntryAbstract)entry.getValue()).pageList) {
                if (!(page instanceof PageText)) continue;
                ((PageText)page).setUnicodeFlag(true);
            }
        }
        return entries;
    }
}

