/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.compat.waila.provider;

import WayofTime.bloodmagic.ConfigHandler;
import WayofTime.bloodmagic.block.BlockAltar;
import WayofTime.bloodmagic.item.sigil.ItemSigilDivination;
import WayofTime.bloodmagic.item.sigil.ItemSigilSeer;
import WayofTime.bloodmagic.registry.ModItems;
import WayofTime.bloodmagic.tile.TileAltar;
import WayofTime.bloodmagic.util.helper.TextHelper;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DataProviderBloodAltar
implements IWailaDataProvider {
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!config.getConfig("BloodMagic.bloodAltar")) {
            return currenttip;
        }
        boolean hasSigil = false;
        boolean hasSeer = false;
        switch (ConfigHandler.wailaAltarDisplayMode) {
            case 0: {
                hasSeer = true;
                hasSigil = true;
                break;
            }
            case 1: {
                hasSeer = DataProviderBloodAltar.holdingSeerSigil(accessor.getPlayer());
                hasSigil = hasSeer || DataProviderBloodAltar.holdingDivinationSigil(accessor.getPlayer());
                break;
            }
            case 2: {
                hasSeer = DataProviderBloodAltar.hasStack(new ItemStack(ModItems.SIGIL_SEER), accessor.getPlayer());
                hasSigil = hasSeer || DataProviderBloodAltar.hasStack(new ItemStack(ModItems.SIGIL_DIVINATION), accessor.getPlayer());
                break;
            }
        }
        if (!hasSeer && !hasSigil) {
            return currenttip;
        }
        if (accessor.getPlayer().func_70093_af() || config.getConfig("BloodMagic.bypassSneak")) {
            if (accessor.getBlock() instanceof BlockAltar && accessor.getTileEntity() instanceof TileAltar) {
                TileAltar altar = (TileAltar)accessor.getTileEntity();
                currenttip.add(TextHelper.localizeEffect("tooltip.BloodMagic.sigil.seer.currentAltarTier", altar.getTier().toInt()));
                currenttip.add(TextHelper.localizeEffect("tooltip.BloodMagic.sigil.seer.currentAltarCapacity", altar.getCapacity()));
                currenttip.add(TextHelper.localizeEffect("tooltip.BloodMagic.sigil.seer.currentEssence", altar.getCurrentBlood()));
                if (hasSeer) {
                    currenttip.add(TextHelper.localizeEffect("tooltip.BloodMagic.sigil.seer.currentAltarProgress.percent", (int)((double)altar.getProgress() / (double)altar.getLiquidRequired() * 100.0) + "%"));
                }
            }
        } else {
            currenttip.add(TextHelper.localizeEffect("waila.BloodMagic.sneak", new Object[0]));
        }
        return currenttip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        return null;
    }

    public static boolean hasStack(ItemStack stack, EntityPlayer player) {
        for (ItemStack inventoryStack : player.field_71071_by.field_70462_a) {
            if (inventoryStack == null || !inventoryStack.func_77969_a(stack)) continue;
            return true;
        }
        return false;
    }

    private static boolean holdingSeerSigil(EntityPlayer player) {
        if (player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() instanceof ItemSigilSeer) {
            return true;
        }
        return player.func_184592_cb() != null && player.func_184592_cb().func_77973_b() instanceof ItemSigilSeer;
    }

    private static boolean holdingDivinationSigil(EntityPlayer player) {
        if (player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() instanceof ItemSigilDivination) {
            return true;
        }
        return player.func_184592_cb() != null && player.func_184592_cb().func_77973_b() instanceof ItemSigilDivination;
    }
}

