/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.entity.projectile;

import WayofTime.bloodmagic.api.soul.EnumDemonWillType;
import WayofTime.bloodmagic.api.soul.PlayerDemonWillHandler;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntitySentientArrow
extends EntityTippedArrow {
    public double reimbursedAmountOnHit = 0.0;
    public EnumDemonWillType type = EnumDemonWillType.DEFAULT;

    public EntitySentientArrow(World worldIn) {
        super(worldIn);
    }

    public EntitySentientArrow(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntitySentientArrow(World worldIn, EntityLivingBase shooter, EnumDemonWillType type, double reinburseAmount) {
        super(worldIn, shooter);
        this.reimbursedAmountOnHit = reinburseAmount;
        this.type = type;
    }

    public void reimbursePlayer(EntityLivingBase hitEntity, float damage) {
        if (this.field_70250_c instanceof EntityPlayer) {
            if (hitEntity.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && !(hitEntity instanceof IMob)) {
                return;
            }
            PlayerDemonWillHandler.addDemonWill(this.type, (EntityPlayer)this.field_70250_c, this.reimbursedAmountOnHit * (double)damage / 20.0);
        }
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74780_a("reimbursement", this.reimbursedAmountOnHit);
        tag.func_74778_a("demonWillType", this.type.toString());
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.reimbursedAmountOnHit = tag.func_74769_h("reimbursement");
        this.type = EnumDemonWillType.valueOf(tag.func_74779_i("demonWillType"));
    }

    protected ItemStack func_184550_j() {
        return new ItemStack(Items.field_151032_g);
    }
}

