/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.gson;

import WayofTime.bloodmagic.gson.SerializerBase;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class Serializers {
    public static final SerializerBase<EnumFacing> FACING_SERIALIZER = new SerializerBase<EnumFacing>(){

        @Override
        public Class<EnumFacing> getType() {
            return EnumFacing.class;
        }

        @Override
        public EnumFacing deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return EnumFacing.func_176739_a((String)json.getAsString());
        }
    };
    public static final SerializerBase<ResourceLocation> RESOURCELOCATION_SERIALIZER = new SerializerBase<ResourceLocation>(){

        @Override
        public Class<ResourceLocation> getType() {
            return ResourceLocation.class;
        }

        @Override
        public ResourceLocation deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String domain = json.getAsJsonObject().get("domain").getAsString();
            String path = json.getAsJsonObject().get("path").getAsString();
            return new ResourceLocation(domain, path);
        }

        @Override
        public JsonElement serialize(ResourceLocation src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            object.addProperty("domain", src.func_110624_b());
            object.addProperty("path", src.func_110623_a());
            return object;
        }
    };
    public static final SerializerBase<ItemStack> ITEMMETA_SERIALIZER = new SerializerBase<ItemStack>(){

        @Override
        public Class<ItemStack> getType() {
            return ItemStack.class;
        }

        @Override
        public ItemStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ResourceLocation registryName = (ResourceLocation)context.deserialize((JsonElement)json.getAsJsonObject().get("registryName").getAsJsonObject(), ResourceLocation.class);
            int meta = json.getAsJsonObject().get("meta").getAsInt();
            return new ItemStack((Item)ForgeRegistries.ITEMS.getValue(registryName), 1, meta);
        }

        @Override
        public JsonElement serialize(ItemStack src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("registryName", context.serialize((Object)src.func_77973_b().getRegistryName()));
            jsonObject.addProperty("meta", (Number)src.func_77952_i());
            return jsonObject;
        }
    };
    public static final Gson GSON = new GsonBuilder().serializeNulls().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter(FACING_SERIALIZER.getType(), FACING_SERIALIZER).registerTypeAdapter(RESOURCELOCATION_SERIALIZER.getType(), RESOURCELOCATION_SERIALIZER).registerTypeAdapter(ITEMMETA_SERIALIZER.getType(), ITEMMETA_SERIALIZER).create();
}

