/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.ConfigHandler;
import WayofTime.bloodmagic.api.BloodMagicAPI;
import WayofTime.bloodmagic.api.event.SacrificeKnifeUsedEvent;
import WayofTime.bloodmagic.api.util.helper.NBTHelper;
import WayofTime.bloodmagic.api.util.helper.PlayerHelper;
import WayofTime.bloodmagic.api.util.helper.PlayerSacrificeHelper;
import WayofTime.bloodmagic.client.IMeshProvider;
import WayofTime.bloodmagic.tile.TileAltar;
import WayofTime.bloodmagic.util.helper.TextHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSacrificialDagger
extends Item
implements IMeshProvider {
    public static String[] names = new String[]{"normal", "creative"};

    public ItemSacrificialDagger() {
        this.func_77655_b("BloodMagic.sacrificialDagger.");
        this.func_77637_a(BloodMagic.tabBloodMagic);
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.func_77664_n();
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + names[stack.func_77952_i()];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item id, CreativeTabs creativeTab, List<ItemStack> list) {
        for (int i = 0; i < names.length; ++i) {
            list.add(new ItemStack(id, 1, i));
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean advanced) {
        list.addAll(Arrays.asList(TextHelper.cutLongString(TextHelper.localizeEffect("tooltip.BloodMagic.sacrificialDagger.desc", new Object[0]))));
        if (stack.func_77952_i() == 1) {
            list.add(TextHelper.localizeEffect("tooltip.BloodMagic.sacrificialDagger.creative", new Object[0]));
        }
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer && !entityLiving.field_70170_p.field_72995_K) {
            PlayerSacrificeHelper.sacrificePlayerHealth((EntityPlayer)entityLiving);
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        TileEntity tile;
        if (PlayerHelper.isFakePlayer(player)) {
            return super.func_77659_a(stack, world, player, hand);
        }
        if (this.canUseForSacrifice(stack)) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        int lpAdded = ConfigHandler.sacrificialDaggerConversion * ConfigHandler.sacrificialDaggerDamage;
        RayTraceResult rayTrace = this.func_77621_a(world, player, false);
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK && (tile = world.func_175625_s(rayTrace.func_178782_a())) != null && tile instanceof TileAltar && stack.func_77952_i() == 1) {
            lpAdded = ((TileAltar)tile).getCapacity();
        }
        if (!player.field_71075_bZ.field_75098_d) {
            SacrificeKnifeUsedEvent evt = new SacrificeKnifeUsedEvent(player, true, true, ConfigHandler.sacrificialDaggerDamage, lpAdded);
            if (MinecraftForge.EVENT_BUS.post((Event)evt)) {
                return super.func_77659_a(stack, world, player, hand);
            }
            if (evt.shouldDrainHealth) {
                player.field_70172_ad = 0;
                player.func_70097_a(BloodMagicAPI.getDamageSource(), 0.001f);
                player.func_70606_j(Math.max(player.func_110143_aJ() - (float)ConfigHandler.sacrificialDaggerDamage, 1.0E-4f));
                if (player.func_110143_aJ() <= 0.001f) {
                    player.func_70645_a(BloodMagicAPI.getDamageSource());
                    player.func_70606_j(0.0f);
                }
            }
            if (!evt.shouldFillAltar) {
                return super.func_77659_a(stack, world, player, hand);
            }
            lpAdded = evt.lpAdded;
        }
        double posX = player.field_70165_t;
        double posY = player.field_70163_u;
        double posZ = player.field_70161_v;
        world.func_184148_a(null, posX, posY, posZ, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
        for (int l = 0; l < 8; ++l) {
            world.func_175688_a(EnumParticleTypes.REDSTONE, posX + Math.random() - Math.random(), posY + Math.random() - Math.random(), posZ + Math.random() - Math.random(), 0.0, 0.0, 0.0, new int[0]);
        }
        if (!world.field_72995_K && PlayerHelper.isFakePlayer(player)) {
            return super.func_77659_a(stack, world, player, hand);
        }
        PlayerSacrificeHelper.findAndFillAltar(world, (EntityLivingBase)player, lpAdded, false);
        return super.func_77659_a(stack, world, player, hand);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        if (!world.field_72995_K && entity instanceof EntityPlayer) {
            this.setUseForSacrifice(stack, this.isPlayerPreparedForSacrifice(world, (EntityPlayer)entity));
        }
    }

    public boolean isPlayerPreparedForSacrifice(World world, EntityPlayer player) {
        return !world.field_72995_K && PlayerSacrificeHelper.getPlayerIncense(player) > 0.0;
    }

    public boolean canUseForSacrifice(ItemStack stack) {
        stack = NBTHelper.checkNBT(stack);
        return stack.func_77978_p().func_74767_n("sacrifice");
    }

    public void setUseForSacrifice(ItemStack stack, boolean sacrifice) {
        stack = NBTHelper.checkNBT(stack);
        stack.func_77978_p().func_74757_a("sacrifice", sacrifice);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemMeshDefinition getMeshDefinition() {
        return new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                String variant = "type=normal";
                if (stack.func_77952_i() != 0) {
                    variant = "type=creative";
                }
                if (ItemSacrificialDagger.this.canUseForSacrifice(stack)) {
                    variant = "type=ceremonial";
                }
                return new ModelResourceLocation(new ResourceLocation("BloodMagic", "item/ItemSacrificialDagger"), variant);
            }
        };
    }

    @Override
    public List<String> getVariants() {
        ArrayList<String> variants = new ArrayList<String>();
        variants.add("type=normal");
        variants.add("type=creative");
        variants.add("type=ceremonial");
        return variants;
    }

    @Override
    @Nullable
    public ResourceLocation getCustomLocation() {
        return null;
    }
}

