/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item.alchemy;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.api.iface.ICustomAlchemyConsumable;
import WayofTime.bloodmagic.api.util.helper.NBTHelper;
import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.registry.ModItems;
import WayofTime.bloodmagic.util.helper.TextHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ItemCuttingFluid
extends Item
implements IVariantProvider,
ICustomAlchemyConsumable {
    private static ArrayList<String> names = new ArrayList();
    public static final String BASIC = "basicCuttingFluid";
    public static final String EXPLOSIVE = "explosive";

    public ItemCuttingFluid() {
        this.func_77655_b("BloodMagic.cuttingFluid.");
        this.func_77627_a(true);
        this.func_77637_a(BloodMagic.tabBloodMagic);
        this.func_77625_d(1);
        this.buildItemList();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        if (!stack.func_77942_o()) {
            return;
        }
        int max = this.getMaxUsesForFluid(stack);
        tooltip.add(TextHelper.localize("tooltip.BloodMagic.cuttingFluidRatio", max - this.getDamageOfFluid(stack), max));
    }

    private void buildItemList() {
        names.add(0, BASIC);
        names.add(1, EXPLOSIVE);
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + names.get(stack.func_77952_i());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item id, CreativeTabs creativeTab, List<ItemStack> list) {
        for (int i = 0; i < names.size(); ++i) {
            list.add(new ItemStack(id, 1, i));
        }
    }

    public static ItemStack getStack(String name) {
        return new ItemStack(ModItems.CUTTING_FLUID, 1, names.indexOf(name));
    }

    @Override
    public List<Pair<Integer, String>> getVariants() {
        ArrayList<Pair<Integer, String>> ret = new ArrayList<Pair<Integer, String>>();
        for (String name : names) {
            ret.add((Pair<Integer, String>)new ImmutablePair((Object)names.indexOf(name), (Object)("type=" + name)));
        }
        return ret;
    }

    public int getDamageOfFluid(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74762_e("used");
    }

    public void applyDamageToFluid(ItemStack stack) {
        int damage = Math.min(this.getDamageOfFluid(stack) + 1, this.getMaxUsesForFluid(stack));
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74768_a("used", damage);
    }

    public int getMaxUsesForFluid(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return 16;
            }
            case 1: {
                return 64;
            }
        }
        return 1;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)this.getDamageOfFluid(stack) / (double)this.getMaxUsesForFluid(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getDamageOfFluid(stack) > 0;
    }

    @Override
    public ItemStack drainUseOnAlchemyCraft(ItemStack stack) {
        this.applyDamageToFluid(stack);
        if (this.getDamageOfFluid(stack) >= this.getMaxUsesForFluid(stack)) {
            return null;
        }
        return stack;
    }

    public static ArrayList<String> getNames() {
        return names;
    }
}

