/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item.block;

import WayofTime.bloodmagic.tile.TileBloodTank;
import WayofTime.bloodmagic.util.helper.TextHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class ItemBlockBloodTank
extends ItemBlock
implements IFluidContainerItem {
    public ItemBlockBloodTank(Block block) {
        super(block);
    }

    public String func_77653_i(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("tank") && !stack.func_77978_p().func_74775_l("tank").func_74779_i("FluidName").equals("")) {
            NBTTagCompound tag = stack.func_77978_p().func_74775_l("tank");
            return super.func_77653_i(stack) + " (" + tag.func_74779_i("FluidName") + ")";
        }
        return super.func_77653_i(stack);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer entityPlayer, List<String> tooltip, boolean advanced) {
        NBTTagCompound tag;
        tooltip.add(TextHelper.localizeEffect("tooltip.BloodMagic.fluid.capacity", new Object[0]) + ": " + String.valueOf(this.getCapacity(stack)) + "mB");
        if (stack.func_77942_o() && !(tag = stack.func_77978_p().func_74775_l("tank")).func_74779_i("FluidName").equals("")) {
            tooltip.add(" ");
            tooltip.add(TextHelper.localizeEffect("tooltip.BloodMagic.fluid.type", new Object[0]) + ": " + tag.func_74779_i("FluidName"));
            tooltip.add(TextHelper.localizeEffect("tooltip.BloodMagic.fluid.amount", new Object[0]) + ": " + tag.func_74762_e("Amount") + "/" + this.getCapacity(stack) + "mB");
        }
    }

    public FluidStack getFluid(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("tank") && !stack.func_77978_p().func_74775_l("tank").func_74779_i("FluidName").equals("")) {
            NBTTagCompound tag = stack.func_77978_p().func_74775_l("tank");
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
        }
        return null;
    }

    public int getCapacity(ItemStack container) {
        return TileBloodTank.capacity;
    }

    public int fill(ItemStack stack, FluidStack resource, boolean doFill) {
        if (resource == null || stack.field_77994_a != 1) {
            return 0;
        }
        int fillAmount = 0;
        int capacity = this.getCapacity(stack);
        NBTTagCompound tag = stack.func_77978_p();
        NBTTagCompound fluidTag = null;
        FluidStack fluid = null;
        if (tag == null || !tag.func_74764_b("tank") || (fluidTag = tag.func_74775_l("tank")) == null || (fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag)) == null) {
            fillAmount = Math.min(capacity, resource.amount);
        }
        if (fluid == null) {
            if (doFill) {
                fluid = resource.copy();
                fluid.amount = 0;
            }
        } else {
            if (!fluid.isFluidEqual(resource)) {
                return 0;
            }
            fillAmount = Math.min(capacity - fluid.amount, resource.amount);
        }
        fillAmount = Math.max(fillAmount, 0);
        if (doFill) {
            if (tag == null) {
                stack.func_77982_d(new NBTTagCompound());
            }
            tag = stack.func_77978_p();
            fluid.amount += fillAmount;
            tag.func_74782_a("tank", (NBTBase)fluid.writeToNBT(fluidTag == null ? new NBTTagCompound() : fluidTag));
        }
        return fillAmount;
    }

    public FluidStack drain(ItemStack stack, int maxDrain, boolean doDrain) {
        NBTTagCompound tag = stack.func_77978_p();
        NBTTagCompound fluidTag = null;
        FluidStack fluid = null;
        if (tag == null || !tag.func_74764_b("tank") || (fluidTag = tag.func_74775_l("tank")) == null || (fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag)) == null) {
            if (fluidTag != null) {
                tag.func_82580_o("tank");
            }
            return null;
        }
        int drainAmount = Math.min(maxDrain, fluid.amount);
        if (doDrain) {
            tag.func_82580_o("tank");
            fluid.amount -= drainAmount;
            if (fluid.amount > 0) {
                this.fill(stack, fluid, true);
            }
        }
        fluid.amount = drainAmount;
        return fluid;
    }
}

