/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item.inventory;

import WayofTime.bloodmagic.api.iface.ISigil;
import WayofTime.bloodmagic.item.inventory.ItemInventory;
import WayofTime.bloodmagic.item.sigil.ItemSigilHolding;
import WayofTime.bloodmagic.util.Utils;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class InventoryHolding
extends ItemInventory {
    protected ItemStack[] inventory;

    public InventoryHolding(ItemStack itemStack) {
        super(itemStack, 5, "SigilOfHolding");
    }

    public void onGuiSaved(EntityPlayer entityPlayer) {
        this.masterStack = this.findParentStack(entityPlayer);
        if (this.masterStack != null) {
            this.save();
        }
    }

    public ItemStack findParentStack(EntityPlayer entityPlayer) {
        if (Utils.hasUUID(this.masterStack)) {
            UUID parentStackUUID = new UUID(this.masterStack.func_77978_p().func_74763_f("mostSig"), this.masterStack.func_77978_p().func_74763_f("leastSig"));
            for (int i = 0; i < entityPlayer.field_71071_by.func_70302_i_(); ++i) {
                ItemStack itemStack = entityPlayer.field_71071_by.func_70301_a(i);
                if (itemStack == null || !Utils.hasUUID(itemStack) || itemStack.func_77978_p().func_74763_f("mostSig") != parentStackUUID.getMostSignificantBits() || itemStack.func_77978_p().func_74763_f("leastSig") != parentStackUUID.getLeastSignificantBits()) continue;
                return itemStack;
            }
        }
        return null;
    }

    public void save() {
        NBTTagCompound nbtTagCompound = this.masterStack.func_77978_p();
        if (nbtTagCompound == null) {
            nbtTagCompound = new NBTTagCompound();
            UUID uuid = UUID.randomUUID();
            nbtTagCompound.func_74772_a("mostSig", uuid.getMostSignificantBits());
            nbtTagCompound.func_74772_a("leastSig", uuid.getLeastSignificantBits());
        }
        this.writeToNBT(nbtTagCompound);
        this.masterStack.func_77982_d(nbtTagCompound);
    }

    @Override
    public boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof ISigil && !(itemStack.func_77973_b() instanceof ItemSigilHolding);
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }
}

