/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.livingArmour.tracker;

import WayofTime.bloodmagic.api.livingArmour.LivingArmourUpgrade;
import WayofTime.bloodmagic.api.livingArmour.StatTracker;
import WayofTime.bloodmagic.livingArmour.LivingArmour;
import WayofTime.bloodmagic.livingArmour.upgrade.LivingArmourUpgradeHealthboost;
import WayofTime.bloodmagic.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class StatTrackerHealthboost
extends StatTracker {
    public double totalHealthGenned = 0.0;
    public static HashMap<LivingArmour, Double> changeMap = new HashMap();
    public static int[] healthedRequired = new int[]{80, 200, 340, 540, 800, 1600, 2800, 5000, 7600, 10000};

    public static void incrementCounter(LivingArmour armour, double health) {
        changeMap.put(armour, changeMap.containsKey(armour) ? changeMap.get(armour) + health : health);
    }

    @Override
    public String getUniqueIdentifier() {
        return "BloodMagic.tracker.health";
    }

    @Override
    public void resetTracker() {
        this.totalHealthGenned = 0.0;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.totalHealthGenned = tag.func_74769_h("BloodMagic.tracker.health");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74780_a("BloodMagic.tracker.health", this.totalHealthGenned);
    }

    @Override
    public boolean onTick(World world, EntityPlayer player, LivingArmour livingArmour) {
        double change;
        if (changeMap.containsKey(livingArmour) && (change = Math.abs(changeMap.get(livingArmour))) > 0.0) {
            this.totalHealthGenned += Math.abs(changeMap.get(livingArmour));
            changeMap.put(livingArmour, 0.0);
            this.markDirty();
            return true;
        }
        return false;
    }

    @Override
    public void onDeactivatedTick(World world, EntityPlayer player, LivingArmour livingArmour) {
        if (changeMap.containsKey(livingArmour)) {
            changeMap.remove(livingArmour);
        }
    }

    @Override
    public List<LivingArmourUpgrade> getUpgrades() {
        ArrayList<LivingArmourUpgrade> upgradeList = new ArrayList<LivingArmourUpgrade>();
        for (int i = 0; i < 10; ++i) {
            if (!(this.totalHealthGenned >= (double)healthedRequired[i])) continue;
            upgradeList.add(new LivingArmourUpgradeHealthboost(i));
        }
        return upgradeList;
    }

    @Override
    public double getProgress(LivingArmour livingArmour, int currentLevel) {
        return Utils.calculateStandardProgress(this.totalHealthGenned, healthedRequired, currentLevel);
    }

    @Override
    public boolean providesUpgrade(String key) {
        return key.equals("BloodMagic.upgrade.health");
    }
}

