/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.livingArmour.tracker;

import WayofTime.bloodmagic.api.livingArmour.LivingArmourUpgrade;
import WayofTime.bloodmagic.api.livingArmour.StatTracker;
import WayofTime.bloodmagic.livingArmour.LivingArmour;
import WayofTime.bloodmagic.livingArmour.upgrade.LivingArmourUpgradeStepAssist;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class StatTrackerStepAssist
extends StatTracker {
    public static Map<EntityPlayer, Double> lastPosX = new HashMap<EntityPlayer, Double>();
    public static Map<EntityPlayer, Double> lastPosZ = new HashMap<EntityPlayer, Double>();
    public static int blocksRequired = 1000;
    public double totalMovement = 0.0;

    @Override
    public String getUniqueIdentifier() {
        return "BloodMagic.tracker.stepAssist";
    }

    @Override
    public void resetTracker() {
        this.totalMovement = 0.0;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.totalMovement = tag.func_74769_h("BloodMagic.tracker.stepAssist");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74780_a("BloodMagic.tracker.stepAssist", this.totalMovement);
    }

    @Override
    public boolean onTick(World world, EntityPlayer player, LivingArmour livingArmour) {
        if (!lastPosX.containsKey(player)) {
            lastPosX.put(player, player.field_70165_t);
            lastPosZ.put(player, player.field_70161_v);
            return false;
        }
        if (!player.field_70122_E || player.field_70138_W < 1.0f) {
            return false;
        }
        double distanceTravelled = Math.sqrt(Math.pow(lastPosX.get(player) - player.field_70165_t, 2.0) + Math.pow(lastPosZ.get(player) - player.field_70161_v, 2.0));
        if (distanceTravelled > 1.0E-4 && distanceTravelled < 2.0) {
            double previousMovement = this.totalMovement;
            this.totalMovement += distanceTravelled;
            lastPosX.put(player, player.field_70165_t);
            lastPosZ.put(player, player.field_70161_v);
            this.markDirty();
            return previousMovement < (double)blocksRequired && this.totalMovement >= (double)blocksRequired;
        }
        lastPosX.put(player, player.field_70165_t);
        lastPosZ.put(player, player.field_70161_v);
        return false;
    }

    @Override
    public void onDeactivatedTick(World world, EntityPlayer player, LivingArmour livingArmour) {
    }

    @Override
    public List<LivingArmourUpgrade> getUpgrades() {
        ArrayList<LivingArmourUpgrade> upgradeList = new ArrayList<LivingArmourUpgrade>();
        if (this.totalMovement >= (double)blocksRequired) {
            upgradeList.add(new LivingArmourUpgradeStepAssist(0));
        }
        return upgradeList;
    }

    @Override
    public double getProgress(LivingArmour livingArmour, int currentLevel) {
        if (currentLevel == 1) {
            return 1.0;
        }
        return this.totalMovement / (double)blocksRequired;
    }

    @Override
    public boolean providesUpgrade(String key) {
        return key.equals("BloodMagic.upgrade.stepAssist");
    }
}

