/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.livingArmour.upgrade;

import WayofTime.bloodmagic.api.livingArmour.ILivingArmour;
import WayofTime.bloodmagic.api.livingArmour.LivingArmourUpgrade;
import WayofTime.bloodmagic.util.ChatUtil;
import WayofTime.bloodmagic.util.helper.TextHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class LivingArmourUpgradeFireResist
extends LivingArmourUpgrade {
    public static final int[] costs = new int[]{2, 6, 14, 25, 40};
    public static final int[] fireCooldownTime = new int[]{6000, 6000, 4800, 3600, 2400};
    public static final int[] fireResistDuration = new int[]{600, 600, 800, 1000, 1200};
    public int fireCooldown = 0;

    public LivingArmourUpgradeFireResist(int level) {
        super(level);
    }

    @Override
    public void onTick(World world, EntityPlayer player, ILivingArmour livingArmour) {
        if (player.func_70027_ad() && this.fireCooldown <= 0) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, fireResistDuration[this.level]));
            this.fireCooldown = fireCooldownTime[this.level];
            ChatUtil.sendNoSpam(player, TextHelper.localizeEffect(chatBase + "fireRemove", new Object[0]));
        } else if (this.fireCooldown > 0) {
            --this.fireCooldown;
        }
    }

    @Override
    public String getUniqueIdentifier() {
        return "BloodMagic.upgrade.fireResist";
    }

    @Override
    public int getMaxTier() {
        return 5;
    }

    @Override
    public int getCostOfUpgrade() {
        return costs[this.level];
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("fireTimer", this.fireCooldown);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.fireCooldown = tag.func_74762_e("fireTimer");
    }

    @Override
    public String getUnlocalizedName() {
        return tooltipBase + "fireResist";
    }
}

