/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.livingArmour.upgrade;

import WayofTime.bloodmagic.api.livingArmour.ILivingArmour;
import WayofTime.bloodmagic.api.livingArmour.LivingArmourUpgrade;
import WayofTime.bloodmagic.util.ChatUtil;
import WayofTime.bloodmagic.util.helper.TextHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class LivingArmourUpgradeGrimReaperSprint
extends LivingArmourUpgrade {
    public static final int[] costs = new int[]{20, 50, 130, 270, 450, 580, 700, 800, 900, 1000};
    public static final int[] rebirthDelay = new int[]{72000, 60000, 54000, 48000, 36000, 30000, 18000, 12000, 6000, 1200};
    public int deathTimer = 0;

    public LivingArmourUpgradeGrimReaperSprint(int level) {
        super(level);
    }

    @Override
    public void onTick(World world, EntityPlayer player, ILivingArmour livingArmour) {
        if (this.deathTimer > 0) {
            --this.deathTimer;
        }
    }

    @Override
    public String getUniqueIdentifier() {
        return "BloodMagic.upgrade.grimReaper";
    }

    @Override
    public int getMaxTier() {
        return 10;
    }

    @Override
    public int getCostOfUpgrade() {
        return costs[this.level];
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.deathTimer = tag.func_74762_e("BloodMagic.tracker.grimReaper");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("BloodMagic.tracker.grimReaper", this.deathTimer);
    }

    @Override
    public String getUnlocalizedName() {
        return tooltipBase + "grimReaper";
    }

    public void applyEffectOnRebirth(EntityPlayer player) {
        player.func_70606_j(player.func_110138_aP());
        this.deathTimer = rebirthDelay[this.level];
        ChatUtil.sendNoSpam(player, TextHelper.localizeEffect(chatBase + "grimReaper", new Object[0]));
    }

    public boolean canSavePlayer(EntityPlayer player) {
        return this.deathTimer <= 0;
    }
}

