/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.livingArmour.upgrade;

import WayofTime.bloodmagic.api.livingArmour.ILivingArmour;
import WayofTime.bloodmagic.api.livingArmour.LivingArmourUpgrade;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class LivingArmourUpgradeSolarPowered
extends LivingArmourUpgrade {
    public static final int[] costs = new int[]{5, 12, 20, 35, 49, 78, 110, 160, 215, 320};
    public static final int[] regenCooldown = new int[]{200, 180, 160, 120, 100, 80, 40, 20, 10, 10};
    public static final int[] fireResistCooldown = new int[]{1, 1, 3600, 3000, 2400, 2100, 1800, 1500, 1200, 600};
    public static final int[] fireResistTime = new int[]{0, 0, 900, 1200, 1800, 2100, 2400, 3000, 3600, 6000};
    public static final double[] protectionLevel = new double[]{0.02, 0.04, 0.06, 0.08, 0.1, 0.13, 0.16, 0.19, 0.22, 0.25};
    public int counter = 0;

    public LivingArmourUpgradeSolarPowered(int level) {
        super(level);
    }

    @Override
    public double getArmourProtection(EntityLivingBase wearer, DamageSource source) {
        if (wearer.field_70170_p.func_175678_i(wearer.func_180425_c()) || wearer.field_70170_p.field_73011_w.isDaytime()) {
            return protectionLevel[this.level];
        }
        return 0.0;
    }

    @Override
    public void onTick(World world, EntityPlayer player, ILivingArmour livingArmour) {
        ++this.counter;
        if (world.func_175678_i(player.func_180425_c()) || world.field_73011_w.isDaytime()) {
            if (this.counter % regenCooldown[this.level] == 0 && player.func_110143_aJ() < player.func_110138_aP()) {
                player.func_70691_i(1.0f);
            }
            if (fireResistTime[this.level] != 0 && this.counter % fireResistCooldown[this.level] == 0) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, fireResistTime[this.level], 0, false, false));
            }
        }
    }

    @Override
    public String getUniqueIdentifier() {
        return "BloodMagic.upgrade.solarPowered";
    }

    @Override
    public int getMaxTier() {
        return 10;
    }

    @Override
    public int getCostOfUpgrade() {
        return costs[this.level];
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("BloodMagic.tracker.solarPowered", this.counter);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.counter = tag.func_74762_e("BloodMagic.tracker.solarPowered");
    }

    @Override
    public String getUnlocalizedName() {
        return tooltipBase + "solarPowered";
    }
}

