/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.meteor;

import WayofTime.bloodmagic.ConfigHandler;
import WayofTime.bloodmagic.gson.Serializers;
import WayofTime.bloodmagic.meteor.Meteor;
import WayofTime.bloodmagic.meteor.MeteorComponent;
import WayofTime.bloodmagic.meteor.MeteorRegistry;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MeteorConfigHandler {
    private static final Map<String, Meteor> DEFAULT_METEORS = new HashMap<String, Meteor>();
    private static File meteorDir;

    public static void init(File meteorDirectory) {
        meteorDir = meteorDirectory;
        MeteorConfigHandler.handleMeteors(true);
    }

    public static void handleMeteors(boolean checkNewVersion) {
        MeteorRegistry.meteorMap.clear();
        List<Pair<String, Meteor>> defaultMeteors = MeteorConfigHandler.getDefaultMeteors();
        try {
            File[] meteorFiles;
            if (!meteorDir.exists() && meteorDir.mkdir()) {
                for (Pair<String, Meteor> meteor : defaultMeteors) {
                    String json = Serializers.GSON.toJson(meteor.getRight());
                    FileWriter writer = new FileWriter(new File(meteorDir, (String)meteor.getLeft() + ".json"));
                    writer.write(json);
                    writer.close();
                }
            }
            if ((meteorFiles = meteorDir.listFiles((FileFilter)FileFilterUtils.suffixFileFilter((String)".json"))) == null) {
                return;
            }
            ArrayList<Pair> meteors = new ArrayList<Pair>();
            for (File meteorFile : meteorFiles) {
                Meteor meteor = (Meteor)Serializers.GSON.fromJson((Reader)new FileReader(meteorFile), Meteor.class);
                meteors.add(Pair.of((Object)FilenameUtils.removeExtension((String)meteorFile.getName()), (Object)meteor));
            }
            if (checkNewVersion && ConfigHandler.getConfig().getBoolean("resyncOnVersionChange", "Meteors", true, "Should the default meteors be regenerated if the mod has updated them")) {
                for (Pair meteor : meteors) {
                    Meteor defaultMeteor = DEFAULT_METEORS.get(meteor.getLeft());
                    if (defaultMeteor == null || defaultMeteor.version <= ((Meteor)meteor.getRight()).version) continue;
                    String json = Serializers.GSON.toJson((Object)defaultMeteor);
                    File meteorFile = new File(meteorDir, (String)meteor.getLeft() + ".json");
                    new PrintWriter(meteorFile).close();
                    FileWriter fileWriter = new FileWriter(meteorFile);
                    fileWriter.write(json);
                    fileWriter.close();
                    meteors.set(meteors.indexOf(meteor), Pair.of((Object)meteor.getLeft(), (Object)defaultMeteor));
                }
            }
            for (Pair meteor : meteors) {
                MeteorRegistry.registerMeteor(((Meteor)meteor.getRight()).getCatalystStack(), (Meteor)meteor.getRight());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ConfigHandler.getConfig().save();
    }

    private static List<Pair<String, Meteor>> getDefaultMeteors() {
        ArrayList<Pair<String, Meteor>> holders = new ArrayList<Pair<String, Meteor>>();
        ArrayList<MeteorComponent> ironMeteorList = new ArrayList<MeteorComponent>();
        ironMeteorList.add(new MeteorComponent(400, "oreIron"));
        ironMeteorList.add(new MeteorComponent(200, "oreCopper"));
        ironMeteorList.add(new MeteorComponent(140, "oreTin"));
        ironMeteorList.add(new MeteorComponent(70, "oreSilver"));
        ironMeteorList.add(new MeteorComponent(80, "oreLead"));
        ironMeteorList.add(new MeteorComponent(30, "oreGold"));
        ironMeteorList.add(new MeteorComponent(60, "oreLapis"));
        ironMeteorList.add(new MeteorComponent(100, "oreRedstone"));
        Meteor ironMeteor = new Meteor(new ItemStack(Blocks.field_150339_S), ironMeteorList, 15.0f, 5, 1000);
        ironMeteor.setVersion(2);
        holders.add(Pair.of((Object)"IronMeteor", (Object)ironMeteor));
        DEFAULT_METEORS.put("IronMeteor", ironMeteor);
        return holders;
    }
}

