/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.potion;

import WayofTime.bloodmagic.api.BloodMagicAPI;
import WayofTime.bloodmagic.api.util.helper.NBTHelper;
import WayofTime.bloodmagic.recipe.alchemyTable.AlchemyTablePotionAugmentRecipe;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class BMPotionUtils {
    public static Random rand = new Random();

    public static double damageMobAndGrowSurroundingPlants(EntityLivingBase entity, int horizontalRadius, int verticalRadius, double damageRatio, int maxPlantsGrown) {
        Block block;
        World world = entity.field_70170_p;
        if (world.field_72995_K) {
            return 0.0;
        }
        if (entity.field_70128_L) {
            return 0.0;
        }
        double incurredDamage = 0.0;
        ArrayList<BlockPos> growList = new ArrayList<BlockPos>();
        for (int i = 0; i < maxPlantsGrown; ++i) {
            BlockPos blockPos = entity.func_180425_c().func_177982_a(rand.nextInt(horizontalRadius * 2 + 1) - horizontalRadius, rand.nextInt(verticalRadius * 2 + 1) - verticalRadius, rand.nextInt(horizontalRadius * 2 + 1) - horizontalRadius);
            block = world.func_180495_p(blockPos).func_177230_c();
            if (BloodMagicAPI.getGreenGroveBlacklist().contains(block) || !(block instanceof IPlantable) && !(block instanceof IGrowable)) continue;
            growList.add(blockPos);
        }
        for (BlockPos blockPos : growList) {
            block = world.func_180495_p(blockPos).func_177230_c();
            IBlockState preBlockState = world.func_180495_p(blockPos);
            for (int n = 0; n < 10; ++n) {
                block.func_180650_b(world, blockPos, world.func_180495_p(blockPos), world.field_73012_v);
            }
            IBlockState newState = world.func_180495_p(blockPos);
            if (newState.equals(preBlockState)) continue;
            world.func_175718_b(2001, blockPos, Block.func_149682_b((Block)newState.func_177230_c()) + (newState.func_177230_c().func_176201_c(newState) << 12));
            incurredDamage += damageRatio;
        }
        if (incurredDamage > 0.0) {
            entity.func_70097_a(BloodMagicAPI.getDamageSource(), (float)incurredDamage);
        }
        return incurredDamage;
    }

    public static double getLengthAugment(ItemStack flaskStack, Potion potion) {
        NBTHelper.checkNBT(flaskStack);
        NBTTagCompound tag = flaskStack.func_77978_p();
        return tag.func_74769_h("length:" + potion.func_76393_a());
    }

    public static void setLengthAugment(ItemStack flaskStack, Potion potion, double value) {
        if (value < 0.0) {
            value = 0.0;
        }
        NBTHelper.checkNBT(flaskStack);
        NBTTagCompound tag = flaskStack.func_77978_p();
        tag.func_74780_a("length:" + potion.func_76393_a(), value);
    }

    public static int getAugmentedLength(int originalLength, double lengthAugment, double powerAugment) {
        return Math.max((int)((double)originalLength * (Math.pow(2.6666667461395264, lengthAugment) * Math.pow(0.5, powerAugment))), 1);
    }

    public static ItemStack setEffects(ItemStack stack, Collection<PotionEffect> effects) {
        if (effects.isEmpty()) {
            return stack;
        }
        NBTTagCompound nbttagcompound = (NBTTagCompound)Objects.firstNonNull((Object)stack.func_77978_p(), (Object)new NBTTagCompound());
        NBTTagList nbttaglist = new NBTTagList();
        for (PotionEffect potioneffect : effects) {
            nbttaglist.func_74742_a((NBTBase)potioneffect.func_82719_a(new NBTTagCompound()));
        }
        nbttagcompound.func_74782_a("CustomPotionEffects", (NBTBase)nbttaglist);
        stack.func_77982_d(nbttagcompound);
        return stack;
    }

    public static AlchemyTablePotionAugmentRecipe getLengthAugmentRecipe(int lpDrained, int ticksRequired, int tierRequired, List<ItemStack> inputItems, PotionEffect baseEffect, double lengthAugment) {
        return new AlchemyTablePotionAugmentRecipe(lpDrained, ticksRequired, tierRequired, inputItems, baseEffect, lengthAugment, 0);
    }

    public static AlchemyTablePotionAugmentRecipe getPowerAugmentRecipe(int lpDrained, int ticksRequired, int tierRequired, List<ItemStack> inputItems, PotionEffect baseEffect, int powerAugment) {
        return new AlchemyTablePotionAugmentRecipe(lpDrained, ticksRequired, tierRequired, inputItems, baseEffect, 0.0, powerAugment);
    }

    public static AlchemyTablePotionAugmentRecipe getLengthAugmentRecipe(int lpDrained, int ticksRequired, int tierRequired, ItemStack inputItem, PotionEffect baseEffect, double lengthAugment) {
        return new AlchemyTablePotionAugmentRecipe(lpDrained, ticksRequired, tierRequired, inputItem, baseEffect, lengthAugment, 0);
    }

    public static AlchemyTablePotionAugmentRecipe getPowerAugmentRecipe(int lpDrained, int ticksRequired, int tierRequired, ItemStack inputItem, PotionEffect baseEffect, int powerAugment) {
        return new AlchemyTablePotionAugmentRecipe(lpDrained, ticksRequired, tierRequired, inputItem, baseEffect, 0.0, powerAugment);
    }
}

