/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual;

import WayofTime.bloodmagic.api.recipe.AlchemyTableRecipe;
import WayofTime.bloodmagic.api.registry.AlchemyTableRecipeRegistry;
import WayofTime.bloodmagic.api.ritual.AreaDescriptor;
import WayofTime.bloodmagic.api.ritual.EnumRuneType;
import WayofTime.bloodmagic.api.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.api.ritual.Ritual;
import WayofTime.bloodmagic.api.ritual.RitualComponent;
import WayofTime.bloodmagic.api.saving.SoulNetwork;
import WayofTime.bloodmagic.api.soul.EnumDemonWillType;
import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import WayofTime.bloodmagic.demonAura.WorldDemonWillHandler;
import WayofTime.bloodmagic.registry.ModBlocks;
import WayofTime.bloodmagic.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RitualCrushing
extends Ritual {
    public static final String CRUSHING_RANGE = "crushingRange";
    public static final String CHEST_RANGE = "chest";
    public static double rawWillDrain = 0.5;
    public static double steadfastWillDrain = 0.2;
    public static double destructiveWillDrain = 0.2;
    public static Map<ItemStack, Integer> cuttingFluidLPMap = new HashMap<ItemStack, Integer>();
    public static Map<ItemStack, Double> cuttingFluidWillMap = new HashMap<ItemStack, Double>();

    public RitualCrushing() {
        super("ritualCrushing", 0, 5000, "ritual.BloodMagic.crushingRitual");
        this.addBlockRange(CRUSHING_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-1, -3, -1), 3));
        this.addBlockRange(CHEST_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.setMaximumVolumeAndDistanceOfRange(CRUSHING_RANGE, 50, 10, 10);
        this.setMaximumVolumeAndDistanceOfRange(CHEST_RANGE, 1, 3, 3);
    }

    public static void registerCuttingFluid(ItemStack stack, int lpDrain, double willDrain) {
        cuttingFluidLPMap.put(stack, lpDrain);
        cuttingFluidWillMap.put(stack, willDrain);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        SoulNetwork network = NetworkHelper.getSoulNetwork(masterRitualStone.getOwner());
        int currentEssence = network.getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            network.causeNausea();
            return;
        }
        BlockPos pos = masterRitualStone.getBlockPos();
        AreaDescriptor chestRange = this.getBlockRange(CHEST_RANGE);
        TileEntity tile = world.func_175625_s(chestRange.getContainedPositions(pos).get(0));
        if (tile != null && Utils.getNumberOfFreeSlots(tile, EnumFacing.DOWN) < 1) {
            return;
        }
        List<EnumDemonWillType> willConfig = masterRitualStone.getActiveWillConfig();
        double steadfastWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.STEADFAST, willConfig);
        double corrosiveWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.CORROSIVE, willConfig);
        double destructiveWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.DESTRUCTIVE, willConfig);
        boolean isSilkTouch = steadfastWill >= steadfastWillDrain;
        boolean useCuttingFluid = corrosiveWill > 0.0;
        int fortune = destructiveWill > 0.0 ? 3 : 0;
        AreaDescriptor crushingRange = this.getBlockRange(CRUSHING_RANGE);
        for (BlockPos newPos : crushingRange.getContainedPositions(pos)) {
            ItemStack copyStack;
            ItemStack checkStack;
            IBlockState state;
            Block block;
            if (world.func_175623_d(newPos) || (block = (state = world.func_180495_p(newPos)).func_177230_c()).equals(ModBlocks.RITUAL_CONTROLLER) || block.equals(ModBlocks.RITUAL_STONE) || block.func_176195_g(state, world, newPos) == -1.0f || Utils.isBlockLiquid(state)) continue;
            boolean isBlockClaimed = false;
            if (useCuttingFluid) {
                checkStack = block.func_185473_a(world, newPos, state);
                if (checkStack == null) continue;
                copyStack = checkStack.func_77946_l();
                for (Map.Entry<ItemStack, Integer> entry : cuttingFluidLPMap.entrySet()) {
                    ItemStack result;
                    ItemStack cuttingStack = entry.getKey();
                    int lpDrain = entry.getValue();
                    double willDrain = cuttingFluidWillMap.containsKey(cuttingStack) ? cuttingFluidWillMap.get(cuttingStack) : 0.0;
                    if (corrosiveWill < willDrain || currentEssence < lpDrain + this.getRefreshCost()) continue;
                    cuttingStack = cuttingStack.func_77946_l();
                    ArrayList<ItemStack> input = new ArrayList<ItemStack>();
                    input.add(cuttingStack);
                    input.add(copyStack);
                    AlchemyTableRecipe recipe = AlchemyTableRecipeRegistry.getMatchingRecipe(input, world, pos);
                    if (recipe == null || (result = recipe.getRecipeOutput(input)) == null) continue;
                    if (tile != null) {
                        if ((result = Utils.insertStackIntoTile(result, tile, EnumFacing.DOWN)) != null && result.field_77994_a > 0) {
                            Utils.spawnStackAtBlock(world, pos, EnumFacing.UP, result);
                        }
                    } else {
                        Utils.spawnStackAtBlock(world, pos, EnumFacing.UP, result);
                    }
                    WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.CORROSIVE, willDrain, true);
                    corrosiveWill -= willDrain;
                    network.syphon(lpDrain);
                    currentEssence -= lpDrain;
                    isBlockClaimed = true;
                }
            }
            if (!isBlockClaimed && isSilkTouch && block.canSilkHarvest(world, newPos, state, null)) {
                checkStack = block.func_185473_a(world, newPos, state);
                if (checkStack == null) continue;
                copyStack = checkStack.func_77946_l();
                if (!(steadfastWill >= steadfastWillDrain)) continue;
                WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.STEADFAST, steadfastWillDrain, true);
                steadfastWill -= steadfastWillDrain;
                if (tile != null) {
                    copyStack = Utils.insertStackIntoTile(copyStack, tile, EnumFacing.DOWN);
                } else {
                    Utils.spawnStackAtBlock(world, pos, EnumFacing.UP, copyStack);
                }
                if (copyStack != null && copyStack.field_77994_a > 0) {
                    Utils.spawnStackAtBlock(world, pos, EnumFacing.UP, copyStack);
                }
            } else if (!isBlockClaimed) {
                List stackList;
                if (fortune > 0 && destructiveWill < destructiveWillDrain) {
                    fortune = 0;
                }
                if ((stackList = block.getDrops((IBlockAccess)world, newPos, state, fortune)) != null && !stackList.isEmpty()) {
                    for (ItemStack item : stackList) {
                        ItemStack copyStack2 = ItemStack.func_77944_b((ItemStack)item);
                        if (tile == null) {
                            Utils.spawnStackAtBlock(world, pos, EnumFacing.UP, copyStack2);
                            continue;
                        }
                        copyStack2 = Utils.insertStackIntoTile(copyStack2, tile, EnumFacing.DOWN);
                        if (copyStack2 == null || copyStack2.field_77994_a <= 0) continue;
                        Utils.spawnStackAtBlock(world, pos, EnumFacing.UP, copyStack2);
                    }
                    if (fortune > 0) {
                        WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.DESTRUCTIVE, destructiveWillDrain, true);
                        destructiveWill -= destructiveWillDrain;
                    }
                }
            }
            world.func_175655_b(newPos, false);
            network.syphon(this.getRefreshCost());
            break;
        }
    }

    @Override
    public int getRefreshTime() {
        return 40;
    }

    @Override
    public int getRefreshCost() {
        return 7;
    }

    @Override
    public ArrayList<RitualComponent> getComponents() {
        ArrayList<RitualComponent> components = new ArrayList<RitualComponent>();
        this.addParallelRunes(components, 1, 0, EnumRuneType.EARTH);
        this.addParallelRunes(components, 2, 0, EnumRuneType.FIRE);
        this.addCornerRunes(components, 2, 0, EnumRuneType.DUSK);
        this.addParallelRunes(components, 2, 1, EnumRuneType.AIR);
        return components;
    }

    @Override
    public ITextComponent[] provideInformationOfRitualToPlayer(EntityPlayer player) {
        return new ITextComponent[]{new TextComponentTranslation(this.getUnlocalizedName() + ".info", new Object[0]), new TextComponentTranslation(this.getUnlocalizedName() + ".destructive.info", new Object[0]), new TextComponentTranslation(this.getUnlocalizedName() + ".corrosive.info", new Object[0]), new TextComponentTranslation(this.getUnlocalizedName() + ".steadfast.info", new Object[0])};
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualCrushing();
    }
}

