/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual;

import WayofTime.bloodmagic.api.ritual.AreaDescriptor;
import WayofTime.bloodmagic.api.ritual.EnumRuneType;
import WayofTime.bloodmagic.api.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.api.ritual.Ritual;
import WayofTime.bloodmagic.api.ritual.RitualComponent;
import WayofTime.bloodmagic.api.saving.SoulNetwork;
import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import WayofTime.bloodmagic.tile.TileDemonCrystal;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class RitualCrystalHarvest
extends Ritual {
    public static final String CRYSTAL_RANGE = "crystal";

    public RitualCrystalHarvest() {
        super("ritualCrystalHarvest", 0, 40000, "ritual.BloodMagic.crystalHarvestRitual");
        this.addBlockRange(CRYSTAL_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-3, 2, -3), 7, 5, 7));
        this.setMaximumVolumeAndDistanceOfRange(CRYSTAL_RANGE, 250, 5, 7);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        SoulNetwork network = NetworkHelper.getSoulNetwork(masterRitualStone.getOwner());
        int currentEssence = network.getCurrentEssence();
        BlockPos pos = masterRitualStone.getBlockPos();
        if (currentEssence < this.getRefreshCost()) {
            network.causeNausea();
            return;
        }
        int maxEffects = 1;
        int totalEffects = 0;
        AreaDescriptor crystalRange = this.getBlockRange(CRYSTAL_RANGE);
        crystalRange.resetIterator();
        while (crystalRange.hasNext()) {
            TileDemonCrystal demonCrystal;
            BlockPos nextPos = ((BlockPos)crystalRange.next()).func_177971_a((Vec3i)pos);
            TileEntity tile = world.func_175625_s(nextPos);
            if (!(tile instanceof TileDemonCrystal) || !(demonCrystal = (TileDemonCrystal)tile).dropSingleCrystal()) continue;
            IBlockState state = world.func_180495_p(nextPos);
            world.func_184138_a(nextPos, state, state, 3);
            if (++totalEffects < maxEffects) continue;
            break;
        }
        network.syphon(this.getRefreshCost() * totalEffects);
    }

    @Override
    public int getRefreshTime() {
        return 25;
    }

    @Override
    public int getRefreshCost() {
        return 50;
    }

    @Override
    public ArrayList<RitualComponent> getComponents() {
        ArrayList<RitualComponent> components = new ArrayList<RitualComponent>();
        this.addCornerRunes(components, 1, 0, EnumRuneType.AIR);
        this.addParallelRunes(components, 1, 1, EnumRuneType.DUSK);
        this.addParallelRunes(components, 1, -1, EnumRuneType.FIRE);
        this.addParallelRunes(components, 2, -1, EnumRuneType.FIRE);
        this.addParallelRunes(components, 3, -1, EnumRuneType.FIRE);
        this.addOffsetRunes(components, 3, 1, -1, EnumRuneType.FIRE);
        this.addCornerRunes(components, 3, -1, EnumRuneType.EARTH);
        this.addCornerRunes(components, 3, 0, EnumRuneType.EARTH);
        this.addOffsetRunes(components, 3, 2, 0, EnumRuneType.DUSK);
        return components;
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualCrystalHarvest();
    }
}

