/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual;

import WayofTime.bloodmagic.api.iface.IBindable;
import WayofTime.bloodmagic.api.ritual.AreaDescriptor;
import WayofTime.bloodmagic.api.ritual.EnumRuneType;
import WayofTime.bloodmagic.api.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.api.ritual.Ritual;
import WayofTime.bloodmagic.api.ritual.RitualComponent;
import WayofTime.bloodmagic.api.saving.SoulNetwork;
import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import WayofTime.bloodmagic.api.util.helper.PlayerHelper;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class RitualExpulsion
extends Ritual {
    public static final String EXPULSION_RANGE = "expulsionRange";

    public RitualExpulsion() {
        super("ritualExpulsion", 0, 10000, "ritual.BloodMagic.expulsionRitual");
        this.addBlockRange(EXPULSION_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-12, 0, -12), 25));
        this.setMaximumVolumeAndDistanceOfRange(EXPULSION_RANGE, 0, 12, 12);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        SoulNetwork network = NetworkHelper.getSoulNetwork(masterRitualStone.getOwner());
        int currentEssence = network.getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            network.causeNausea();
            return;
        }
        if (masterRitualStone.getWorldObj().field_72995_K) {
            return;
        }
        AreaDescriptor expulsionRange = this.getBlockRange(EXPULSION_RANGE);
        ArrayList<String> allowedNames = new ArrayList<String>();
        if (world.func_175625_s(masterRitualStone.getBlockPos().func_177984_a()) != null && world.func_175625_s(masterRitualStone.getBlockPos().func_177984_a()) instanceof IInventory) {
            IInventory inventory = (IInventory)world.func_175625_s(masterRitualStone.getBlockPos().func_177984_a());
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                IBindable bindable;
                ItemStack itemStack = inventory.func_70301_a(i);
                if (itemStack == null || !(itemStack.func_77973_b() instanceof IBindable) || Strings.isNullOrEmpty((String)(bindable = (IBindable)itemStack.func_77973_b()).getOwnerName(itemStack)) || allowedNames.contains(bindable.getOwnerName(itemStack))) continue;
                allowedNames.add(bindable.getOwnerName(itemStack));
            }
        }
        int teleportDistance = 100;
        for (EntityPlayer player : world.func_72872_a(EntityPlayer.class, expulsionRange.getAABB(masterRitualStone.getBlockPos()))) {
            if (player.field_71075_bZ.field_75098_d || PlayerHelper.getUUIDFromPlayer(player).toString().equals(masterRitualStone.getOwner()) || allowedNames.contains(PlayerHelper.getUUIDFromPlayer(player).toString()) || !this.teleportRandomly((EntityLivingBase)player, 100.0)) continue;
            network.syphon(this.getRefreshCost() * 1000);
        }
        allowedNames.clear();
    }

    public boolean teleportRandomly(EntityLivingBase entityLiving, double distance) {
        int i;
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            if (player.field_71075_bZ.field_75098_d) {
                return false;
            }
        }
        double x = entityLiving.field_70165_t;
        double y = entityLiving.field_70163_u;
        double z = entityLiving.field_70161_v;
        Random rand = new Random();
        double randX = x + (rand.nextDouble() - 0.5) * distance;
        double randY = y + ((double)rand.nextInt((int)distance) - distance / 2.0);
        double randZ = z + (rand.nextDouble() - 0.5) * distance;
        for (i = 0; !this.teleportTo(entityLiving, randX, randY, randZ, x, y, z) && i < 100; ++i) {
            randX = x + (rand.nextDouble() - 0.5) * distance;
            randY = y + ((double)rand.nextInt((int)distance) - distance / 2.0);
            randZ = z + (rand.nextDouble() - 0.5) * distance;
        }
        return i >= 100;
    }

    public boolean teleportTo(EntityLivingBase entityLiving, double par1, double par3, double par5, double lastX, double lastY, double lastZ) {
        EnderTeleportEvent event = new EnderTeleportEvent(entityLiving, par1, par3, par5, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        this.moveEntityViaTeleport(entityLiving, event.getTargetX(), event.getTargetY(), event.getTargetZ());
        boolean flag = false;
        int i = MathHelper.func_76128_c((double)entityLiving.field_70165_t);
        int j = MathHelper.func_76128_c((double)entityLiving.field_70163_u);
        int k = MathHelper.func_76128_c((double)entityLiving.field_70161_v);
        if (!entityLiving.field_70170_p.func_175623_d(new BlockPos(i, j, k))) {
            boolean flag1 = false;
            while (!flag1 && j > 0) {
                IBlockState state = entityLiving.field_70170_p.func_180495_p(new BlockPos(i, j - 1, k));
                if (state != null && state.func_185904_a().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                entityLiving.field_70163_u -= 1.0;
                --j;
            }
            if (flag1) {
                this.moveEntityViaTeleport(entityLiving, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v);
                if (!entityLiving.field_70132_H && !entityLiving.field_70170_p.func_72953_d(entityLiving.func_174813_aQ())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.moveEntityViaTeleport(entityLiving, lastX, lastY, lastZ);
            return false;
        }
        for (int l = 0; l < 128; ++l) {
            double lengthVal = (double)l / 127.0;
            float randF1 = (entityLiving.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.2f;
            float randF2 = (entityLiving.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.2f;
            float randF3 = (entityLiving.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.2f;
            double lengthValX = lastX + (entityLiving.field_70165_t - lastX) * lengthVal + (entityLiving.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)entityLiving.field_70130_N * 2.0;
            double lengthValY = lastY + (entityLiving.field_70163_u - lastY) * lengthVal + entityLiving.field_70170_p.field_73012_v.nextDouble() * (double)entityLiving.field_70131_O;
            double lengthValZ = lastZ + (entityLiving.field_70161_v - lastZ) * lengthVal + (entityLiving.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)entityLiving.field_70130_N * 2.0;
            entityLiving.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, lengthValX, lengthValY, lengthValZ, (double)randF1, (double)randF2, (double)randF3, new int[0]);
        }
        return true;
    }

    public void moveEntityViaTeleport(EntityLivingBase entityLiving, double x, double y, double z) {
        if (entityLiving != null && entityLiving instanceof EntityPlayer) {
            if (entityLiving instanceof EntityPlayerMP) {
                EnderTeleportEvent event;
                EntityPlayerMP entityplayermp = (EntityPlayerMP)entityLiving;
                if (entityplayermp.field_70170_p == entityLiving.field_70170_p && !MinecraftForge.EVENT_BUS.post((Event)(event = new EnderTeleportEvent((EntityLivingBase)entityplayermp, x, y, z, 5.0f)))) {
                    if (entityLiving.func_184218_aH()) {
                        entityplayermp.func_71123_m();
                    }
                    entityLiving.func_70634_a(event.getTargetX(), event.getTargetY(), event.getTargetZ());
                }
            }
        } else if (entityLiving != null) {
            entityLiving.func_70107_b(x, y, z);
        }
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public int getRefreshCost() {
        return 2;
    }

    @Override
    public ArrayList<RitualComponent> getComponents() {
        ArrayList<RitualComponent> components = new ArrayList<RitualComponent>();
        this.addCornerRunes(components, 2, 0, EnumRuneType.EARTH);
        this.addRune(components, 2, 0, 1, EnumRuneType.EARTH);
        this.addRune(components, 1, 0, 2, EnumRuneType.EARTH);
        this.addRune(components, 2, 0, -1, EnumRuneType.EARTH);
        this.addRune(components, -1, 0, 2, EnumRuneType.EARTH);
        this.addRune(components, -2, 0, 1, EnumRuneType.EARTH);
        this.addRune(components, 1, 0, -2, EnumRuneType.EARTH);
        this.addRune(components, -2, 0, -1, EnumRuneType.EARTH);
        this.addRune(components, -1, 0, -2, EnumRuneType.EARTH);
        this.addRune(components, 4, 0, 2, EnumRuneType.AIR);
        this.addRune(components, 5, 0, 2, EnumRuneType.AIR);
        this.addRune(components, 4, 0, -2, EnumRuneType.AIR);
        this.addRune(components, 5, 0, -2, EnumRuneType.AIR);
        this.addRune(components, -4, 0, 2, EnumRuneType.AIR);
        this.addRune(components, -5, 0, 2, EnumRuneType.AIR);
        this.addRune(components, -4, 0, -2, EnumRuneType.AIR);
        this.addRune(components, -5, 0, -2, EnumRuneType.AIR);
        this.addRune(components, 2, 0, 4, EnumRuneType.AIR);
        this.addRune(components, 2, 0, 5, EnumRuneType.AIR);
        this.addRune(components, -2, 0, 4, EnumRuneType.AIR);
        this.addRune(components, -2, 0, 5, EnumRuneType.AIR);
        this.addRune(components, 2, 0, -4, EnumRuneType.AIR);
        this.addRune(components, 2, 0, -5, EnumRuneType.AIR);
        this.addRune(components, -2, 0, -4, EnumRuneType.AIR);
        this.addRune(components, -2, 0, -5, EnumRuneType.AIR);
        this.addParallelRunes(components, 5, 0, EnumRuneType.DUSK);
        this.addParallelRunes(components, 6, 0, EnumRuneType.EARTH);
        this.addRune(components, -6, 0, 1, EnumRuneType.DUSK);
        this.addRune(components, -6, 0, -1, EnumRuneType.DUSK);
        this.addRune(components, 6, 0, 1, EnumRuneType.DUSK);
        this.addRune(components, 6, 0, -1, EnumRuneType.DUSK);
        this.addRune(components, 1, 0, 6, EnumRuneType.DUSK);
        this.addRune(components, -1, 0, 6, EnumRuneType.DUSK);
        this.addRune(components, 1, 0, -6, EnumRuneType.DUSK);
        this.addRune(components, -1, 0, -6, EnumRuneType.DUSK);
        this.addCornerRunes(components, 4, 0, EnumRuneType.FIRE);
        return components;
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualExpulsion();
    }
}

