/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual;

import WayofTime.bloodmagic.ConfigHandler;
import WayofTime.bloodmagic.api.ritual.AreaDescriptor;
import WayofTime.bloodmagic.api.ritual.EnumRuneType;
import WayofTime.bloodmagic.api.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.api.ritual.Ritual;
import WayofTime.bloodmagic.api.ritual.RitualComponent;
import WayofTime.bloodmagic.api.saving.SoulNetwork;
import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import WayofTime.bloodmagic.tile.TileAltar;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class RitualFeatheredKnife
extends Ritual {
    public static final String ALTAR_RANGE = "altar";
    public static final String DAMAGE_RANGE = "damage";
    public BlockPos altarOffsetPos = new BlockPos(0, 0, 0);

    public RitualFeatheredKnife() {
        super("ritualFeatheredKnife", 0, 25000, "ritual.BloodMagic.featheredKnifeRitual");
        this.addBlockRange(ALTAR_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-5, -10, -5), 11, 21, 11));
        this.addBlockRange(DAMAGE_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-15, -20, -15), 31, 41, 31));
        this.setMaximumVolumeAndDistanceOfRange(ALTAR_RANGE, 0, 10, 15);
        this.setMaximumVolumeAndDistanceOfRange(DAMAGE_RANGE, 0, 15, 15);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        SoulNetwork network = NetworkHelper.getSoulNetwork(masterRitualStone.getOwner());
        int currentEssence = network.getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            network.causeNausea();
            return;
        }
        BlockPos pos = masterRitualStone.getBlockPos();
        int maxEffects = currentEssence / this.getRefreshCost();
        int totalEffects = 0;
        BlockPos altarPos = pos.func_177971_a((Vec3i)this.altarOffsetPos);
        TileEntity tile = world.func_175625_s(altarPos);
        AreaDescriptor altarRange = this.getBlockRange(ALTAR_RANGE);
        if (!altarRange.isWithinArea(this.altarOffsetPos) || !(tile instanceof TileAltar)) {
            for (BlockPos newPos : altarRange.getContainedPositions(pos)) {
                TileEntity nextTile = world.func_175625_s(newPos);
                if (!(nextTile instanceof TileAltar)) continue;
                tile = nextTile;
                this.altarOffsetPos = newPos.func_177973_b((Vec3i)pos);
                altarRange.resetCache();
                break;
            }
        }
        if (tile instanceof TileAltar) {
            TileAltar tileAltar = (TileAltar)tile;
            AreaDescriptor damageRange = this.getBlockRange(DAMAGE_RANGE);
            AxisAlignedBB range = damageRange.getAABB(pos);
            List entities = world.func_72872_a(EntityPlayer.class, range);
            for (EntityLivingBase player : entities) {
                float health = player.func_110143_aJ();
                if (!(health > 6.0f)) continue;
                player.func_70606_j(health - 1.0f);
                tileAltar.sacrificialDaggerCall(ConfigHandler.sacrificialDaggerConversion, false);
                if (++totalEffects < maxEffects) continue;
                break;
            }
        }
        network.syphon(this.getRefreshCost() * totalEffects);
    }

    @Override
    public int getRefreshTime() {
        return 20;
    }

    @Override
    public int getRefreshCost() {
        return 20;
    }

    @Override
    public ArrayList<RitualComponent> getComponents() {
        ArrayList<RitualComponent> components = new ArrayList<RitualComponent>();
        this.addParallelRunes(components, 1, 0, EnumRuneType.DUSK);
        this.addParallelRunes(components, 2, -1, EnumRuneType.WATER);
        this.addCornerRunes(components, 1, -1, EnumRuneType.AIR);
        this.addOffsetRunes(components, 2, 4, -1, EnumRuneType.FIRE);
        this.addOffsetRunes(components, 2, 4, 0, EnumRuneType.EARTH);
        this.addOffsetRunes(components, 4, 3, 0, EnumRuneType.EARTH);
        this.addCornerRunes(components, 3, 0, EnumRuneType.AIR);
        return components;
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualFeatheredKnife();
    }
}

