/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual;

import WayofTime.bloodmagic.api.ritual.AreaDescriptor;
import WayofTime.bloodmagic.api.ritual.EnumRuneType;
import WayofTime.bloodmagic.api.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.api.ritual.Ritual;
import WayofTime.bloodmagic.api.ritual.RitualComponent;
import WayofTime.bloodmagic.api.saving.SoulNetwork;
import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import WayofTime.bloodmagic.api.util.helper.PlayerHelper;
import java.util.ArrayList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RitualInterdiction
extends Ritual {
    public static final String INTERDICTION_RANGE = "interdictionRange";

    public RitualInterdiction() {
        super("ritualInterdiction", 0, 1000, "ritual.BloodMagic.interdictionRitual");
        this.addBlockRange(INTERDICTION_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-2, 0, -2), 5));
        this.setMaximumVolumeAndDistanceOfRange(INTERDICTION_RANGE, 0, 5, 5);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        SoulNetwork network = NetworkHelper.getSoulNetwork(masterRitualStone.getOwner());
        int currentEssence = network.getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            network.causeNausea();
            return;
        }
        AreaDescriptor interdictionRange = this.getBlockRange(INTERDICTION_RANGE);
        for (EntityLivingBase entity : world.func_72872_a(EntityLivingBase.class, interdictionRange.getAABB(masterRitualStone.getBlockPos()))) {
            if (entity instanceof EntityPlayer && (((EntityPlayer)entity).field_71075_bZ.field_75098_d || PlayerHelper.getUUIDFromPlayer((EntityPlayer)entity).toString().equals(masterRitualStone.getOwner()))) continue;
            double xDif = entity.field_70165_t - (double)masterRitualStone.getBlockPos().func_177958_n();
            double yDif = entity.field_70163_u - (double)masterRitualStone.getBlockPos().func_177956_o() + 1.0;
            double zDif = entity.field_70161_v - (double)masterRitualStone.getBlockPos().func_177952_p();
            entity.field_70159_w = 0.1 * xDif;
            entity.field_70181_x = 0.1 * yDif;
            entity.field_70179_y = 0.1 * zDif;
            entity.field_70143_R = 0.0f;
        }
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public int getRefreshCost() {
        return 1;
    }

    @Override
    public ArrayList<RitualComponent> getComponents() {
        ArrayList<RitualComponent> components = new ArrayList<RitualComponent>();
        this.addCornerRunes(components, 1, 0, EnumRuneType.AIR);
        this.addParallelRunes(components, 1, 0, EnumRuneType.AIR);
        return components;
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualInterdiction();
    }
}

