/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual;

import WayofTime.bloodmagic.api.ritual.AreaDescriptor;
import WayofTime.bloodmagic.api.ritual.EnumRuneType;
import WayofTime.bloodmagic.api.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.api.ritual.Ritual;
import WayofTime.bloodmagic.api.ritual.RitualComponent;
import WayofTime.bloodmagic.api.saving.SoulNetwork;
import WayofTime.bloodmagic.api.soul.DemonWillHolder;
import WayofTime.bloodmagic.api.soul.EnumDemonWillType;
import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import WayofTime.bloodmagic.demonAura.WorldDemonWillHandler;
import WayofTime.bloodmagic.registry.ModPotions;
import WayofTime.bloodmagic.util.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RitualLava
extends Ritual {
    public static final String LAVA_RANGE = "lavaRange";
    public static final String FIRE_FUSE_RANGE = "fireFuse";
    public static final double vengefulWillDrain = 1.0;

    public RitualLava() {
        super("ritualLava", 0, 10000, "ritual.BloodMagic.lavaRitual");
        this.addBlockRange(LAVA_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.addBlockRange(FIRE_FUSE_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-2, -2, -2), 5));
        this.setMaximumVolumeAndDistanceOfRange(LAVA_RANGE, 9, 3, 3);
        this.setMaximumVolumeAndDistanceOfRange(FIRE_FUSE_RANGE, 0, 10, 10);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        SoulNetwork network = NetworkHelper.getSoulNetwork(masterRitualStone.getOwner());
        int currentEssence = network.getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            network.causeNausea();
            return;
        }
        BlockPos pos = masterRitualStone.getBlockPos();
        int maxEffects = currentEssence / this.getRefreshCost();
        int totalEffects = 0;
        List<EnumDemonWillType> willConfig = masterRitualStone.getActiveWillConfig();
        DemonWillHolder holder = WorldDemonWillHandler.getWillHolder(world, pos);
        AreaDescriptor lavaRange = this.getBlockRange(LAVA_RANGE);
        int maxLavaVolume = this.getMaxVolumeForRange(LAVA_RANGE, willConfig, holder);
        if (!lavaRange.isWithinRange(this.getMaxVerticalRadiusForRange(LAVA_RANGE, willConfig, holder), this.getMaxHorizontalRadiusForRange(LAVA_RANGE, willConfig, holder)) || maxLavaVolume != 0 && lavaRange.getVolume() > maxLavaVolume) {
            return;
        }
        for (BlockPos newPos : lavaRange.getContainedPositions(pos)) {
            IBlockState state = world.func_180495_p(newPos);
            if (world.func_175623_d(newPos) || Utils.isFlowingLiquid(world, newPos, state)) {
                world.func_175656_a(newPos, Blocks.field_150356_k.func_176223_P());
                ++totalEffects;
            }
            if (totalEffects < maxEffects) continue;
            break;
        }
        network.syphon(this.getRefreshCost() * totalEffects);
        double vengefulWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.VENGEFUL, willConfig);
        if (vengefulWill >= 1.0) {
            double vengefulDrained = 0.0;
            AreaDescriptor fuseRange = this.getBlockRange(FIRE_FUSE_RANGE);
            AxisAlignedBB fuseArea = fuseRange.getAABB(pos);
            List entities = world.func_72872_a(EntityLivingBase.class, fuseArea);
            for (EntityLivingBase entity : entities) {
                if (vengefulWill < 1.0) break;
                if (entity instanceof EntityPlayer) {
                    // empty if block
                }
                if (entity.func_70644_a(ModPotions.fireFuse)) continue;
                entity.func_70690_d(new PotionEffect(ModPotions.fireFuse, 100, 0));
                vengefulDrained += 1.0;
                vengefulWill -= 1.0;
            }
            if (vengefulDrained > 0.0) {
                WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.VENGEFUL, vengefulDrained, true);
            }
        }
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public int getRefreshCost() {
        return 500;
    }

    @Override
    public ArrayList<RitualComponent> getComponents() {
        ArrayList<RitualComponent> components = new ArrayList<RitualComponent>();
        this.addParallelRunes(components, 1, 0, EnumRuneType.FIRE);
        return components;
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualLava();
    }

    @Override
    public int getMaxVolumeForRange(String range, List<EnumDemonWillType> activeTypes, DemonWillHolder holder) {
        double destructiveWill;
        if (LAVA_RANGE.equals(range) && activeTypes.contains((Object)EnumDemonWillType.DESTRUCTIVE) && (destructiveWill = holder.getWill(EnumDemonWillType.DESTRUCTIVE)) > 0.0) {
            return 9 + (int)Math.pow(destructiveWill / 10.0, 1.5);
        }
        return (Integer)this.volumeRangeMap.get(range);
    }

    @Override
    public int getMaxVerticalRadiusForRange(String range, List<EnumDemonWillType> activeTypes, DemonWillHolder holder) {
        double destructiveWill;
        if (LAVA_RANGE.equals(range) && activeTypes.contains((Object)EnumDemonWillType.DESTRUCTIVE) && (destructiveWill = holder.getWill(EnumDemonWillType.DESTRUCTIVE)) > 0.0) {
            return (int)(3.0 + destructiveWill / 10.0);
        }
        return (Integer)this.verticalRangeMap.get(range);
    }

    @Override
    public int getMaxHorizontalRadiusForRange(String range, List<EnumDemonWillType> activeTypes, DemonWillHolder holder) {
        double destructiveWill;
        if (LAVA_RANGE.equals(range) && activeTypes.contains((Object)EnumDemonWillType.DESTRUCTIVE) && (destructiveWill = holder.getWill(EnumDemonWillType.DESTRUCTIVE)) > 0.0) {
            return (int)(3.0 + destructiveWill / 10.0);
        }
        return (Integer)this.horizontalRangeMap.get(range);
    }
}

