/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual;

import WayofTime.bloodmagic.api.ritual.AreaDescriptor;
import WayofTime.bloodmagic.api.ritual.EnumRuneType;
import WayofTime.bloodmagic.api.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.api.ritual.Ritual;
import WayofTime.bloodmagic.api.ritual.RitualComponent;
import WayofTime.bloodmagic.api.saving.SoulNetwork;
import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class RitualPump
extends Ritual {
    public static final String PUMP_RANGE = "pumpRange";
    private ArrayList<BlockPos> liquidsCache;
    private Iterator<BlockPos> blockPosIterator;
    private boolean cached = false;
    private BlockPos currentPos;

    public RitualPump() {
        super("ritualPump", 0, 500, "ritual.BloodMagic.pumpRitual");
        this.addBlockRange(PUMP_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-16, -16, -16), new BlockPos(17, 17, 17)));
        this.setMaximumVolumeAndDistanceOfRange(PUMP_RANGE, 0, 16, 16);
        this.liquidsCache = new ArrayList();
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        SoulNetwork network = NetworkHelper.getSoulNetwork(masterRitualStone.getOwner());
        int currentEssence = network.getCurrentEssence();
        TileEntity tileEntity = world.func_175625_s(masterRitualStone.getBlockPos().func_177984_a());
        if (currentEssence < this.getRefreshCost()) {
            network.causeNausea();
            return;
        }
        if (tileEntity != null && tileEntity instanceof IFluidHandler) {
            IFluidHandler fluidHandler = (IFluidHandler)tileEntity;
            if (!this.cached || this.liquidsCache.isEmpty()) {
                if (fluidHandler.drain(EnumFacing.DOWN, 1000, false) != null) {
                    FluidStack fluidStack = fluidHandler.drain(EnumFacing.DOWN, 1000, false);
                    for (BlockPos blockPos : this.getBlockRange(PUMP_RANGE).getContainedPositions(masterRitualStone.getBlockPos())) {
                        if (this.liquidsCache.contains(blockPos) || world.func_175623_d(blockPos) || world.func_180495_p(blockPos).func_177230_c() != fluidStack.getFluid().getBlock() || (Integer)world.func_180495_p(blockPos).func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0) continue;
                        this.liquidsCache.add(blockPos);
                    }
                }
                this.cached = true;
                this.blockPosIterator = this.liquidsCache.iterator();
            }
            if (this.blockPosIterator.hasNext()) {
                network.syphon(this.getRefreshCost());
                this.currentPos = this.blockPosIterator.next();
                fluidHandler.fill(EnumFacing.DOWN, fluidHandler.drain(EnumFacing.DOWN, 1000, false), true);
                world.func_175656_a(this.currentPos, Blocks.field_150348_b.func_176223_P());
                this.blockPosIterator.remove();
            }
        }
    }

    @Override
    public int getRefreshCost() {
        return 25;
    }

    @Override
    public ArrayList<RitualComponent> getComponents() {
        ArrayList<RitualComponent> components = new ArrayList<RitualComponent>();
        this.addRune(components, 1, 0, 1, EnumRuneType.WATER);
        this.addRune(components, 1, 0, -1, EnumRuneType.EARTH);
        this.addRune(components, -1, 0, -1, EnumRuneType.AIR);
        this.addRune(components, -1, 0, 1, EnumRuneType.FIRE);
        this.addCornerRunes(components, 1, 1, EnumRuneType.DUSK);
        return components;
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualPump();
    }
}

