/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual;

import WayofTime.bloodmagic.api.ritual.AreaDescriptor;
import WayofTime.bloodmagic.api.ritual.EnumRuneType;
import WayofTime.bloodmagic.api.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.api.ritual.Ritual;
import WayofTime.bloodmagic.api.ritual.RitualComponent;
import WayofTime.bloodmagic.api.saving.SoulNetwork;
import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import WayofTime.bloodmagic.util.Utils;
import java.util.ArrayList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RitualSpeed
extends Ritual {
    public static final String SPEED_RANGE = "sanicRange";

    public RitualSpeed() {
        super("ritualSpeed", 0, 1000, "ritual.BloodMagic.speedRitual");
        this.addBlockRange(SPEED_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-2, 1, -2), new BlockPos(2, 5, 2)));
        this.setMaximumVolumeAndDistanceOfRange(SPEED_RANGE, 0, 2, 5);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        SoulNetwork network = NetworkHelper.getSoulNetwork(masterRitualStone.getOwner());
        int currentEssence = network.getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            network.causeNausea();
            return;
        }
        AreaDescriptor speedRange = this.getBlockRange(SPEED_RANGE);
        for (EntityLivingBase entity : world.func_72872_a(EntityLivingBase.class, speedRange.getAABB(masterRitualStone.getBlockPos()))) {
            if (entity.func_70093_af()) continue;
            double motionY = 1.2;
            double speed = 3.0;
            EnumFacing direction = masterRitualStone.getDirection();
            entity.field_70181_x = motionY;
            entity.field_70143_R = 0.0f;
            switch (direction) {
                case NORTH: {
                    entity.field_70159_w = 0.0;
                    entity.field_70181_x = motionY;
                    entity.field_70179_y = -speed;
                    break;
                }
                case SOUTH: {
                    entity.field_70159_w = 0.0;
                    entity.field_70181_x = motionY;
                    entity.field_70179_y = speed;
                    break;
                }
                case WEST: {
                    entity.field_70159_w = -speed;
                    entity.field_70181_x = motionY;
                    entity.field_70179_y = 0.0;
                    break;
                }
                case EAST: {
                    entity.field_70159_w = speed;
                    entity.field_70181_x = motionY;
                    entity.field_70179_y = 0.0;
                    break;
                }
            }
            if (!(entity instanceof EntityPlayer)) continue;
            Utils.setPlayerSpeedFromServer((EntityPlayer)entity, entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
        }
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public int getRefreshCost() {
        return 5;
    }

    @Override
    public ArrayList<RitualComponent> getComponents() {
        ArrayList<RitualComponent> components = new ArrayList<RitualComponent>();
        this.addRune(components, 0, 0, -2, EnumRuneType.DUSK);
        this.addRune(components, 1, 0, -1, EnumRuneType.AIR);
        this.addRune(components, -1, 0, -1, EnumRuneType.AIR);
        for (int i = 0; i < 3; ++i) {
            this.addRune(components, 2, 0, i, EnumRuneType.AIR);
            this.addRune(components, -2, 0, i, EnumRuneType.AIR);
        }
        return components;
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualSpeed();
    }
}

