/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual;

import WayofTime.bloodmagic.api.ritual.AreaDescriptor;
import WayofTime.bloodmagic.api.ritual.EnumRuneType;
import WayofTime.bloodmagic.api.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.api.ritual.Ritual;
import WayofTime.bloodmagic.api.ritual.RitualComponent;
import WayofTime.bloodmagic.api.saving.SoulNetwork;
import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import java.util.ArrayList;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RitualWater
extends Ritual {
    public static final String WATER_RANGE = "waterRange";

    public RitualWater() {
        super("ritualWater", 0, 500, "ritual.BloodMagic.waterRitual");
        this.addBlockRange(WATER_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.setMaximumVolumeAndDistanceOfRange(WATER_RANGE, 9, 3, 3);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        SoulNetwork network = NetworkHelper.getSoulNetwork(masterRitualStone.getOwner());
        int currentEssence = network.getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            network.causeNausea();
            return;
        }
        int maxEffects = currentEssence / this.getRefreshCost();
        int totalEffects = 0;
        AreaDescriptor waterRange = this.getBlockRange(WATER_RANGE);
        for (BlockPos newPos : waterRange.getContainedPositions(masterRitualStone.getBlockPos())) {
            if (world.func_175623_d(newPos)) {
                world.func_175656_a(newPos, Blocks.field_150358_i.func_176223_P());
                ++totalEffects;
            }
            if (totalEffects < maxEffects) continue;
            break;
        }
        network.syphon(this.getRefreshCost() * totalEffects);
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public int getRefreshCost() {
        return 25;
    }

    @Override
    public ArrayList<RitualComponent> getComponents() {
        ArrayList<RitualComponent> components = new ArrayList<RitualComponent>();
        this.addCornerRunes(components, 1, 0, EnumRuneType.WATER);
        return components;
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualWater();
    }
}

