/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual.portal;

import WayofTime.bloodmagic.api.event.TeleposeEvent;
import WayofTime.bloodmagic.api.saving.SoulNetwork;
import WayofTime.bloodmagic.api.teleport.Teleport;
import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateHealth;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;

public class Teleports {

    public static class TeleportToDim
    extends Teleport {
        private World oldWorld;
        private int newWorldID;
        private boolean teleposer;

        public TeleportToDim(int x, int y, int z, Entity entity, String networkToDrain, World oldWorld, int newWorld, boolean teleposer) {
            this(new BlockPos(x, y, z), entity, networkToDrain, oldWorld, newWorld, teleposer);
        }

        public TeleportToDim(BlockPos blockPos, Entity entity, String networkToDrain, World oldWorld, int newWorldID, boolean teleposer) {
            super(blockPos, entity, networkToDrain);
            this.oldWorld = oldWorld;
            this.newWorldID = newWorldID;
            this.teleposer = teleposer;
        }

        @Override
        public void teleport() {
            if (this.entity != null && this.entity.field_71088_bW <= 0) {
                MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                WorldServer oldWorldServer = server.func_71218_a(this.entity.field_71093_bK);
                WorldServer newWorldServer = server.func_71218_a(this.newWorldID);
                if (this.entity instanceof EntityPlayer) {
                    EntityPlayerMP player = (EntityPlayerMP)this.entity;
                    if (!player.field_70170_p.field_72995_K) {
                        SoulNetwork network = NetworkHelper.getSoulNetwork(this.networkToDrain);
                        if (network.getCurrentEssence() < this.getTeleportCost()) {
                            return;
                        }
                        if (this.teleposer && MinecraftForge.EVENT_BUS.post((Event)new TeleposeEvent.Ent(this.entity, this.entity.field_70170_p, this.entity.func_180425_c(), (World)newWorldServer, new BlockPos(this.x, this.y, this.z)))) {
                            return;
                        }
                        network.syphon(this.getTeleportCost());
                        player.func_184204_a(this.newWorldID);
                        player.func_70634_a((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5);
                        player.field_70170_p.func_72866_a((Entity)player, false);
                        player.field_71135_a.func_147359_a((Packet)new SPacketUpdateHealth(player.func_110143_aJ(), player.func_71024_bL().func_75116_a(), player.func_71024_bL().func_75115_e()));
                        if (this.teleposer) {
                            MinecraftForge.EVENT_BUS.post((Event)new TeleposeEvent.Ent.Post(this.entity, this.entity.field_70170_p, this.entity.func_180425_c(), (World)newWorldServer, new BlockPos(this.x, this.y, this.z)));
                        }
                    }
                } else if (!this.entity.field_70170_p.field_72995_K) {
                    SoulNetwork network = NetworkHelper.getSoulNetwork(this.networkToDrain);
                    if (network.getCurrentEssence() < this.getTeleportCost() / 10) {
                        return;
                    }
                    if (this.teleposer && MinecraftForge.EVENT_BUS.post((Event)new TeleposeEvent.Ent(this.entity, this.entity.field_70170_p, this.entity.func_180425_c(), (World)newWorldServer, new BlockPos(this.x, this.y, this.z)))) {
                        return;
                    }
                    network.syphon(this.getTeleportCost() / 10);
                    NBTTagCompound tag = new NBTTagCompound();
                    this.entity.func_70039_c(tag);
                    this.entity.func_70106_y();
                    this.oldWorld.func_184134_a(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, SoundEvents.field_187534_aX, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
                    Entity teleportedEntity = EntityList.func_75615_a((NBTTagCompound)tag, (World)newWorldServer);
                    if (teleportedEntity != null) {
                        teleportedEntity.func_70012_b((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5, this.entity.field_70177_z, this.entity.field_70125_A);
                        teleportedEntity.field_98038_p = true;
                        newWorldServer.func_72838_d(teleportedEntity);
                        teleportedEntity.func_70029_a((World)newWorldServer);
                        teleportedEntity.field_71088_bW = teleportedEntity instanceof EntityPlayer ? 150 : 20;
                    }
                    oldWorldServer.func_82742_i();
                    newWorldServer.func_82742_i();
                    if (this.teleposer) {
                        MinecraftForge.EVENT_BUS.post((Event)new TeleposeEvent.Ent.Post(this.entity, this.entity.field_70170_p, this.entity.func_180425_c(), (World)newWorldServer, new BlockPos(this.x, this.y, this.z)));
                    }
                }
                this.entity.field_71088_bW = this.entity instanceof EntityLiving ? 150 : 20;
                newWorldServer.func_184134_a((double)this.x, (double)this.y, (double)this.z, SoundEvents.field_187534_aX, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
            }
        }

        @Override
        public int getTeleportCost() {
            return 10000;
        }

        public World getOldWorld() {
            return this.oldWorld;
        }

        public int getNewWorldID() {
            return this.newWorldID;
        }

        public boolean isTeleposer() {
            return this.teleposer;
        }
    }

    public static class TeleportSameDim
    extends Teleport {
        private final boolean teleposer;

        public TeleportSameDim(int x, int y, int z, Entity entity, String networkToDrain, boolean teleposer) {
            this(new BlockPos(x, y, z), entity, networkToDrain, teleposer);
        }

        public TeleportSameDim(BlockPos blockPos, Entity entity, String networkToDrain, boolean teleposer) {
            super(blockPos, entity, networkToDrain);
            this.teleposer = teleposer;
        }

        @Override
        public void teleport() {
            if (this.entity != null && this.entity.field_71088_bW <= 0) {
                if (this.entity instanceof EntityPlayer) {
                    SoulNetwork network = NetworkHelper.getSoulNetwork(this.networkToDrain);
                    if (network.getCurrentEssence() < this.getTeleportCost()) {
                        return;
                    }
                    if (this.teleposer && MinecraftForge.EVENT_BUS.post((Event)new TeleposeEvent.Ent(this.entity, this.entity.field_70170_p, this.entity.func_180425_c(), this.entity.field_70170_p, new BlockPos(this.x, this.y, this.z)))) {
                        return;
                    }
                    network.syphon(this.getTeleportCost());
                    EntityPlayerMP player = (EntityPlayerMP)this.entity;
                    player.func_70634_a((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5);
                    player.field_70170_p.func_72866_a((Entity)player, false);
                    player.field_71135_a.func_147359_a((Packet)new SPacketUpdateHealth(player.func_110143_aJ(), player.func_71024_bL().func_75116_a(), player.func_71024_bL().func_75115_e()));
                    player.field_71088_bW = 150;
                    player.field_70170_p.func_184134_a((double)this.x, (double)this.y, (double)this.z, SoundEvents.field_187534_aX, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
                    if (this.teleposer) {
                        MinecraftForge.EVENT_BUS.post((Event)new TeleposeEvent.Ent.Post(this.entity, this.entity.field_70170_p, this.entity.func_180425_c(), this.entity.field_70170_p, new BlockPos(this.x, this.y, this.z)));
                    }
                } else {
                    SoulNetwork network = NetworkHelper.getSoulNetwork(this.networkToDrain);
                    if (network.getCurrentEssence() < this.getTeleportCost() / 10) {
                        return;
                    }
                    if (this.teleposer && MinecraftForge.EVENT_BUS.post((Event)new TeleposeEvent.Ent(this.entity, this.entity.field_70170_p, this.entity.func_180425_c(), this.entity.field_70170_p, new BlockPos(this.x, this.y, this.z)))) {
                        return;
                    }
                    network.syphon(this.getTeleportCost() / 10);
                    WorldServer world = (WorldServer)this.entity.field_70170_p;
                    this.entity.func_70107_b((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5);
                    this.entity.field_71088_bW = 150;
                    world.func_82742_i();
                    this.entity.field_70170_p.func_184134_a((double)this.x, (double)this.y, (double)this.z, SoundEvents.field_187534_aX, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
                    if (this.teleposer) {
                        MinecraftForge.EVENT_BUS.post((Event)new TeleposeEvent.Ent.Post(this.entity, this.entity.field_70170_p, this.entity.func_180425_c(), this.entity.field_70170_p, new BlockPos(this.x, this.y, this.z)));
                    }
                }
            }
        }

        @Override
        public int getTeleportCost() {
            return 1000;
        }
    }
}

