/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.routing;

import WayofTime.bloodmagic.routing.IItemFilter;
import WayofTime.bloodmagic.util.Utils;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class TestItemFilter
implements IItemFilter {
    protected List<ItemStack> requestList;
    protected TileEntity accessedTile;
    protected IItemHandler itemHandler;

    @Override
    public void initializeFilter(List<ItemStack> filteredList, TileEntity tile, IItemHandler itemHandler, boolean isFilterOutput) {
        int stackSize;
        ItemStack checkedStack;
        int slot;
        this.accessedTile = tile;
        this.itemHandler = itemHandler;
        if (isFilterOutput) {
            this.requestList = filteredList;
            for (slot = 0; slot < itemHandler.getSlots(); ++slot) {
                checkedStack = itemHandler.getStackInSlot(slot);
                if (checkedStack == null) continue;
                stackSize = checkedStack.field_77994_a;
                for (ItemStack filterStack : this.requestList) {
                    if (filterStack.field_77994_a == 0 || !this.doStacksMatch(filterStack, checkedStack)) continue;
                    filterStack.field_77994_a = Math.max(filterStack.field_77994_a - stackSize, 0);
                }
            }
        } else {
            this.requestList = filteredList;
            for (ItemStack filterStack : this.requestList) {
                filterStack.field_77994_a *= -1;
            }
            for (slot = 0; slot < itemHandler.getSlots(); ++slot) {
                checkedStack = itemHandler.getStackInSlot(slot);
                if (checkedStack == null) continue;
                stackSize = checkedStack.field_77994_a;
                for (ItemStack filterStack : filteredList) {
                    if (!this.doStacksMatch(filterStack, checkedStack)) continue;
                    filterStack.field_77994_a += stackSize;
                }
            }
        }
        Iterator<ItemStack> iterator = this.requestList.iterator();
        while (iterator.hasNext()) {
            ItemStack filterStack;
            filterStack = iterator.next();
            if (filterStack.field_77994_a > 0) continue;
            iterator.remove();
        }
    }

    @Override
    public ItemStack transferStackThroughOutputFilter(ItemStack inputStack) {
        int allowedAmount = 0;
        for (ItemStack filterStack : this.requestList) {
            if (!this.doStacksMatch(filterStack, inputStack)) continue;
            allowedAmount = Math.min(filterStack.field_77994_a, inputStack.field_77994_a);
            break;
        }
        if (allowedAmount <= 0) {
            return inputStack;
        }
        ItemStack testStack = inputStack.func_77946_l();
        testStack.field_77994_a = allowedAmount;
        ItemStack remainderStack = Utils.insertStackIntoTile(testStack, this.itemHandler);
        int changeAmount = allowedAmount - (remainderStack == null ? 0 : remainderStack.field_77994_a);
        testStack = inputStack.func_77946_l();
        testStack.field_77994_a -= changeAmount;
        Iterator<ItemStack> itr = this.requestList.iterator();
        while (itr.hasNext()) {
            ItemStack filterStack = itr.next();
            if (!this.doStacksMatch(filterStack, inputStack)) continue;
            filterStack.field_77994_a -= changeAmount;
            if (filterStack.field_77994_a > 0) continue;
            itr.remove();
        }
        World world = this.accessedTile.func_145831_w();
        BlockPos pos = this.accessedTile.func_174877_v();
        world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
        return testStack;
    }

    @Override
    public int transferThroughInputFilter(IItemFilter outputFilter, int maxTransfer) {
        for (int slot = 0; slot < this.itemHandler.getSlots(); ++slot) {
            ItemStack inputStack = this.itemHandler.getStackInSlot(slot);
            if (inputStack == null || this.itemHandler.extractItem(slot, inputStack.field_77994_a, true) == null) continue;
            int allowedAmount = 0;
            for (ItemStack filterStack : this.requestList) {
                if (!this.doStacksMatch(filterStack, inputStack)) continue;
                allowedAmount = Math.min(maxTransfer, Math.min(filterStack.field_77994_a, this.itemHandler.extractItem((int)slot, (int)inputStack.field_77994_a, (boolean)true).field_77994_a));
                break;
            }
            if (allowedAmount <= 0) continue;
            ItemStack testStack = inputStack.func_77946_l();
            testStack.field_77994_a = allowedAmount;
            ItemStack remainderStack = outputFilter.transferStackThroughOutputFilter(testStack);
            int changeAmount = allowedAmount - (remainderStack == null ? 0 : remainderStack.field_77994_a);
            if (remainderStack != null && remainderStack.field_77994_a == allowedAmount) continue;
            maxTransfer -= changeAmount;
            this.itemHandler.extractItem(slot, changeAmount, false);
            Iterator<ItemStack> itr = this.requestList.iterator();
            while (itr.hasNext()) {
                ItemStack filterStack = itr.next();
                if (!this.doStacksMatch(filterStack, inputStack)) continue;
                filterStack.field_77994_a -= changeAmount;
                if (filterStack.field_77994_a > 0) continue;
                itr.remove();
            }
            World world = this.accessedTile.func_145831_w();
            BlockPos pos = this.accessedTile.func_174877_v();
            world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
            return changeAmount;
        }
        return 0;
    }

    @Override
    public boolean doesStackMatchFilter(ItemStack testStack) {
        for (ItemStack filterStack : this.requestList) {
            if (!this.doStacksMatch(filterStack, testStack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean doStacksMatch(ItemStack filterStack, ItemStack testStack) {
        return Utils.canCombine(filterStack, testStack);
    }
}

