/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.tile;

import WayofTime.bloodmagic.api.orb.IBloodOrb;
import WayofTime.bloodmagic.api.recipe.AlchemyTableRecipe;
import WayofTime.bloodmagic.api.registry.AlchemyTableRecipeRegistry;
import WayofTime.bloodmagic.api.saving.SoulNetwork;
import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import WayofTime.bloodmagic.tile.TileInventory;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileAlchemyTable
extends TileInventory
implements ISidedInventory,
ITickable {
    public static final int orbSlot = 6;
    public static final int toolSlot = 7;
    public static final int outputSlot = 8;
    public EnumFacing direction = EnumFacing.NORTH;
    public boolean isSlave = false;
    public int burnTime = 0;
    public int ticksRequired = 1;
    public BlockPos connectedPos = BlockPos.field_177992_a;
    public List<Integer> blockedSlots = new ArrayList<Integer>();

    public TileAlchemyTable() {
        super(9, "alchemyTable");
    }

    public void setInitialTableParameters(EnumFacing direction, boolean isSlave, BlockPos connectedPos) {
        this.isSlave = isSlave;
        this.connectedPos = connectedPos;
        if (!isSlave) {
            this.direction = direction;
        }
    }

    public boolean isInvisible() {
        return this.isSlave();
    }

    public boolean isInputSlotAccessible(int slot) {
        if (slot < 6 && slot >= 0) {
            return !this.blockedSlots.contains(slot);
        }
        return true;
    }

    public void toggleInputSlotAccessible(int slot) {
        if (slot < 6 && slot >= 0) {
            if (this.blockedSlots.contains(slot)) {
                this.blockedSlots.remove((Object)slot);
            } else {
                this.blockedSlots.add(slot);
            }
        }
    }

    @Override
    public void deserialize(NBTTagCompound tag) {
        int[] blockedSlotArray;
        super.deserialize(tag);
        this.isSlave = tag.func_74767_n("isSlave");
        this.direction = EnumFacing.func_82600_a((int)tag.func_74762_e("direction"));
        this.connectedPos = new BlockPos(tag.func_74762_e("xCoord"), tag.func_74762_e("yCoord"), tag.func_74762_e("zCoord"));
        this.burnTime = tag.func_74762_e("burnTime");
        this.ticksRequired = tag.func_74762_e("ticksRequired");
        this.blockedSlots.clear();
        for (int blocked : blockedSlotArray = tag.func_74759_k("blockedSlots")) {
            this.blockedSlots.add(blocked);
        }
    }

    @Override
    public NBTTagCompound serialize(NBTTagCompound tag) {
        super.serialize(tag);
        tag.func_74757_a("isSlave", this.isSlave);
        tag.func_74768_a("direction", this.direction.func_176745_a());
        tag.func_74768_a("xCoord", this.connectedPos.func_177958_n());
        tag.func_74768_a("yCoord", this.connectedPos.func_177956_o());
        tag.func_74768_a("zCoord", this.connectedPos.func_177952_p());
        tag.func_74768_a("burnTime", this.burnTime);
        tag.func_74768_a("ticksRequired", this.ticksRequired);
        int[] blockedSlotArray = new int[this.blockedSlots.size()];
        for (int i = 0; i < this.blockedSlots.size(); ++i) {
            blockedSlotArray[i] = this.blockedSlots.get(i);
        }
        tag.func_74783_a("blockedSlots", blockedSlotArray);
        return tag;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.isSlave()) {
                TileEntity tile = this.field_145850_b.func_175625_s(this.connectedPos);
                if (tile instanceof TileAlchemyTable) {
                    return (T)new SidedInvWrapper((ISidedInventory)((TileAlchemyTable)tile), facing);
                }
            } else {
                return (T)new SidedInvWrapper((ISidedInventory)this, facing);
            }
        }
        return super.getCapability(capability, facing);
    }

    public int[] func_180463_a(EnumFacing side) {
        switch (side) {
            case DOWN: {
                return new int[]{8};
            }
            case UP: {
                return new int[]{6, 7};
            }
        }
        return new int[]{0, 1, 2, 3, 4, 5};
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        switch (direction) {
            case DOWN: {
                return index != 8 && index != 6 && index != 7;
            }
            case UP: {
                if (index == 6 && stack != null && stack.func_77973_b() instanceof IBloodOrb) {
                    return true;
                }
                return index != 7;
            }
        }
        return this.getAccessibleInputSlots(direction).contains(index);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        switch (direction) {
            case DOWN: {
                return index == 8;
            }
            case UP: {
                if (index == 6 && stack != null && stack.func_77973_b() instanceof IBloodOrb) {
                    return true;
                }
                if (index == 7) {
                    return true;
                }
                return true;
            }
        }
        return this.getAccessibleInputSlots(direction).contains(index);
    }

    public List<Integer> getAccessibleInputSlots(EnumFacing direction) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < 6; ++i) {
            if (!this.isInputSlotAccessible(i)) continue;
            list.add(i);
        }
        return list;
    }

    public void func_73660_a() {
        if (this.isSlave()) {
            return;
        }
        ArrayList<ItemStack> inputList = new ArrayList<ItemStack>();
        for (int i = 0; i < 6; ++i) {
            if (this.func_70301_a(i) == null) continue;
            inputList.add(this.func_70301_a(i));
        }
        int tier = this.getTierOfOrb();
        AlchemyTableRecipe recipe = AlchemyTableRecipeRegistry.getMatchingRecipe(inputList, this.func_145831_w(), this.func_174877_v());
        if (recipe != null && (this.burnTime > 0 || !this.field_145850_b.field_72995_K && tier >= recipe.getTierRequired() && this.getContainedLp() >= recipe.getLpDrained())) {
            IBlockState state;
            if (this.burnTime == 1) {
                state = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
            }
            if (this.canCraft(inputList, recipe)) {
                this.ticksRequired = recipe.getTicksRequired();
                ++this.burnTime;
                if (this.burnTime == this.ticksRequired) {
                    if (!this.field_145850_b.field_72995_K) {
                        int requiredLp = recipe.getLpDrained();
                        if (requiredLp > 0 && !this.field_145850_b.field_72995_K) {
                            this.consumeLp(requiredLp);
                        }
                        if (!this.field_145850_b.field_72995_K) {
                            this.craftItem(inputList, recipe);
                        }
                    }
                    this.burnTime = 0;
                    state = this.field_145850_b.func_180495_p(this.field_174879_c);
                    this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
                } else if (this.burnTime > this.ticksRequired + 10) {
                    this.burnTime = 0;
                }
            } else {
                this.burnTime = 0;
            }
        } else {
            this.burnTime = 0;
        }
    }

    public double getProgressForGui() {
        return (double)this.burnTime / (double)this.ticksRequired;
    }

    private boolean canCraft(List<ItemStack> inputList, AlchemyTableRecipe recipe) {
        if (recipe == null) {
            return false;
        }
        ItemStack outputStack = recipe.getRecipeOutput(inputList);
        ItemStack currentOutputStack = this.func_70301_a(8);
        if (outputStack == null) {
            return false;
        }
        if (currentOutputStack == null) {
            return true;
        }
        if (!currentOutputStack.func_77969_a(outputStack)) {
            return false;
        }
        int result = currentOutputStack.field_77994_a + outputStack.field_77994_a;
        return result <= this.func_70297_j_() && result <= currentOutputStack.func_77976_d();
    }

    public int getTierOfOrb() {
        ItemStack orbStack = this.func_70301_a(6);
        if (orbStack != null && orbStack.func_77973_b() instanceof IBloodOrb) {
            return ((IBloodOrb)orbStack.func_77973_b()).getOrbLevel(orbStack.func_77960_j());
        }
        return 0;
    }

    public int getContainedLp() {
        ItemStack orbStack = this.func_70301_a(6);
        if (orbStack != null && orbStack.func_77973_b() instanceof IBloodOrb) {
            NBTTagCompound itemTag = orbStack.func_77978_p();
            if (itemTag == null) {
                return 0;
            }
            String ownerUUID = itemTag.func_74779_i("ownerUUID");
            if (Strings.isNullOrEmpty((String)ownerUUID)) {
                return 0;
            }
            SoulNetwork network = NetworkHelper.getSoulNetwork(ownerUUID);
            return network.getCurrentEssence();
        }
        return 0;
    }

    public void craftItem(List<ItemStack> inputList, AlchemyTableRecipe recipe) {
        if (this.canCraft(inputList, recipe)) {
            ItemStack outputStack = recipe.getRecipeOutput(inputList);
            ItemStack currentOutputStack = this.func_70301_a(8);
            if (currentOutputStack == null) {
                this.func_70299_a(8, outputStack);
            } else if (currentOutputStack.func_77973_b() == currentOutputStack.func_77973_b()) {
                currentOutputStack.field_77994_a += outputStack.field_77994_a;
            }
            this.consumeInventory(recipe);
        }
    }

    public int consumeLp(int requested) {
        ItemStack orbStack = this.func_70301_a(6);
        if (orbStack != null && orbStack.func_77973_b() instanceof IBloodOrb && NetworkHelper.syphonFromContainer(orbStack, requested)) {
            return requested;
        }
        return 0;
    }

    public void consumeInventory(AlchemyTableRecipe recipe) {
        ItemStack[] input = new ItemStack[6];
        for (int i = 0; i < 6; ++i) {
            input[i] = this.func_70301_a(i);
        }
        ItemStack[] result = recipe.getRemainingItems(input);
        for (int i = 0; i < 6; ++i) {
            this.func_70299_a(i, result[i]);
        }
    }

    public EnumFacing getDirection() {
        return this.direction;
    }

    public boolean isSlave() {
        return this.isSlave;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public int getTicksRequired() {
        return this.ticksRequired;
    }

    public BlockPos getConnectedPos() {
        return this.connectedPos;
    }

    public List<Integer> getBlockedSlots() {
        return this.blockedSlots;
    }
}

