/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.tile;

import WayofTime.bloodmagic.tile.base.TileBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileBloodTank
extends TileBase
implements IFluidHandler {
    public static int capacity;
    public FluidTank tank;

    public TileBloodTank() {
        capacity = 32000;
        this.tank = new FluidTank(capacity);
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return this.tank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public void deserialize(NBTTagCompound tagCompound) {
        this.tank.readFromNBT(tagCompound.func_74775_l("tank"));
        capacity = tagCompound.func_74762_e("capacity");
    }

    @Override
    public NBTTagCompound serialize(NBTTagCompound tagCompound) {
        if (this.tank.getFluidAmount() != 0) {
            tagCompound.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        }
        tagCompound.func_74768_a("capacity", capacity);
        return tagCompound;
    }
}

