/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.tile;

import WayofTime.bloodmagic.api.soul.DemonWillHolder;
import WayofTime.bloodmagic.api.soul.EnumDemonWillType;
import WayofTime.bloodmagic.api.soul.IDemonWillConduit;
import WayofTime.bloodmagic.demonAura.WorldDemonWillHandler;
import WayofTime.bloodmagic.tile.base.TileTicking;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class TileDemonPylon
extends TileTicking
implements IDemonWillConduit {
    public DemonWillHolder holder = new DemonWillHolder();
    public final int maxWill = 100;
    public final double drainRate = 1.0;

    @Override
    public void onUpdate() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (EnumDemonWillType type : EnumDemonWillType.values()) {
            double currentAmount = WorldDemonWillHandler.getCurrentWill(this.field_145850_b, this.field_174879_c, type);
            for (EnumFacing side : EnumFacing.field_176754_o) {
                BlockPos offsetPos = this.field_174879_c.func_177967_a(side, 16);
                double sideAmount = WorldDemonWillHandler.getCurrentWill(this.field_145850_b, offsetPos, type);
                if (!(sideAmount > currentAmount)) continue;
                double drainAmount = Math.min((sideAmount - currentAmount) / 2.0, 1.0);
                double drain = WorldDemonWillHandler.drainWill(this.field_145850_b, offsetPos, type, drainAmount, true);
                WorldDemonWillHandler.fillWill(this.field_145850_b, this.field_174879_c, type, drain, true);
            }
        }
    }

    @Override
    public void deserialize(NBTTagCompound tag) {
        this.holder.readFromNBT(tag, "Will");
    }

    @Override
    public NBTTagCompound serialize(NBTTagCompound tag) {
        this.holder.writeToNBT(tag, "Will");
        return tag;
    }

    @Override
    public int getWeight() {
        return 10;
    }

    @Override
    public double fillDemonWill(EnumDemonWillType type, double amount, boolean doFill) {
        if (amount <= 0.0) {
            return 0.0;
        }
        if (!this.canFill(type)) {
            return 0.0;
        }
        if (!doFill) {
            return Math.min(100.0 - this.holder.getWill(type), amount);
        }
        return this.holder.addWill(type, amount, 100.0);
    }

    @Override
    public double drainDemonWill(EnumDemonWillType type, double amount, boolean doDrain) {
        double drained = amount;
        double current = this.holder.getWill(type);
        if (current < drained) {
            drained = current;
        }
        if (doDrain) {
            return this.holder.drainWill(type, amount);
        }
        return drained;
    }

    @Override
    public boolean canFill(EnumDemonWillType type) {
        return true;
    }

    @Override
    public boolean canDrain(EnumDemonWillType type) {
        return true;
    }

    @Override
    public double getCurrentWill(EnumDemonWillType type) {
        return this.holder.getWill(type);
    }
}

