/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.tile;

import WayofTime.bloodmagic.api.incense.EnumTranquilityType;
import WayofTime.bloodmagic.api.incense.IIncensePath;
import WayofTime.bloodmagic.api.incense.IncenseTranquilityRegistry;
import WayofTime.bloodmagic.api.incense.TranquilityStack;
import WayofTime.bloodmagic.api.ritual.AreaDescriptor;
import WayofTime.bloodmagic.api.util.helper.PlayerSacrificeHelper;
import WayofTime.bloodmagic.incense.IncenseAltarHandler;
import WayofTime.bloodmagic.tile.TileInventory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;

public class TileIncenseAltar
extends TileInventory
implements ITickable {
    public AreaDescriptor incenseArea = new AreaDescriptor.Rectangle(new BlockPos(-5, -5, -5), 11);
    public static int maxCheckRange = 5;
    public Map<EnumTranquilityType, Double> tranquilityMap = new HashMap<EnumTranquilityType, Double>();
    public double incenseAddition = 0.0;
    public double tranquility = 0.0;
    public int roadDistance = 0;

    public TileIncenseAltar() {
        super(1, "incenseAltar");
    }

    public void func_73660_a() {
        AxisAlignedBB aabb = this.incenseArea.getAABB(this.func_174877_v());
        List playerList = this.field_145850_b.func_72872_a(EntityPlayer.class, aabb);
        if (playerList.isEmpty()) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % 100L == 0L) {
            this.recheckConstruction();
        }
        boolean hasPerformed = false;
        for (EntityPlayer player : playerList) {
            if (!PlayerSacrificeHelper.incrementIncense(player, 0.0, this.incenseAddition, this.incenseAddition / 100.0)) continue;
            hasPerformed = true;
        }
        if (hasPerformed && this.field_145850_b.field_73012_v.nextInt(4) == 0 && this.field_145850_b instanceof WorldServer) {
            WorldServer server = (WorldServer)this.field_145850_b;
            server.func_175739_a(EnumParticleTypes.FLAME, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.2, (double)this.field_174879_c.func_177952_p() + 0.5, 1, 0.02, 0.03, 0.02, 0.0, new int[0]);
        }
    }

    @Override
    public void deserialize(NBTTagCompound tag) {
        super.deserialize(tag);
        this.tranquility = tag.func_74769_h("tranquility");
        this.incenseAddition = tag.func_74769_h("incenseAddition");
    }

    @Override
    public NBTTagCompound serialize(NBTTagCompound tag) {
        super.serialize(tag);
        tag.func_74780_a("tranquility", this.tranquility);
        tag.func_74780_a("incenseAddition", this.incenseAddition);
        return tag;
    }

    public void recheckConstruction() {
        double bonus;
        int maxLength = 11;
        int yOffset = 0;
        HashMap<EnumTranquilityType, Double> tranquilityMap = new HashMap<EnumTranquilityType, Double>();
        for (int currentDistance = 2; currentDistance < currentDistance + maxLength; ++currentDistance) {
            int i;
            boolean canFormRoad = false;
            for (i = -maxCheckRange + yOffset; i <= maxCheckRange + yOffset; ++i) {
                BlockPos verticalPos = this.field_174879_c.func_177982_a(0, i, 0);
                canFormRoad = true;
                block2: for (EnumFacing horizontalFacing : EnumFacing.field_176754_o) {
                    BlockPos facingOffsetPos = verticalPos.func_177967_a(horizontalFacing, currentDistance);
                    for (int j = -1; j <= 1; ++j) {
                        BlockPos offsetPos = facingOffsetPos.func_177967_a(horizontalFacing.func_176746_e(), j);
                        IBlockState state = this.field_145850_b.func_180495_p(offsetPos);
                        Block block = state.func_177230_c();
                        if (block instanceof IIncensePath && ((IIncensePath)block).getLevelOfPath(this.field_145850_b, offsetPos, state) >= currentDistance - 2) continue;
                        canFormRoad = false;
                        break block2;
                    }
                }
                if (!canFormRoad) continue;
                yOffset = i;
                break;
            }
            if (canFormRoad) {
                for (i = -currentDistance; i <= currentDistance; ++i) {
                    for (int j = -currentDistance; j <= currentDistance; ++j) {
                        if (Math.abs(i) != currentDistance && Math.abs(j) != currentDistance) continue;
                        for (int y = 0 + yOffset; y <= 2 + yOffset; ++y) {
                            IBlockState state;
                            Block block;
                            BlockPos offsetPos = this.field_174879_c.func_177982_a(i, y, j);
                            TranquilityStack stack = IncenseTranquilityRegistry.getTranquilityOfBlock(this.field_145850_b, offsetPos, block = (state = this.field_145850_b.func_180495_p(offsetPos)).func_177230_c(), state);
                            if (stack == null) continue;
                            if (!tranquilityMap.containsKey((Object)stack.type)) {
                                tranquilityMap.put(stack.type, stack.value);
                                continue;
                            }
                            tranquilityMap.put(stack.type, (Double)tranquilityMap.get((Object)stack.type) + stack.value);
                        }
                    }
                }
                continue;
            }
            this.roadDistance = currentDistance - 2;
            break;
        }
        this.tranquilityMap = tranquilityMap;
        double totalTranquility = 0.0;
        for (Map.Entry entry : tranquilityMap.entrySet()) {
            totalTranquility += ((Double)entry.getValue()).doubleValue();
        }
        if (totalTranquility < 0.0) {
            return;
        }
        double appliedTranquility = 0.0;
        for (Map.Entry entry : tranquilityMap.entrySet()) {
            appliedTranquility += Math.sqrt((Double)entry.getValue());
        }
        this.incenseAddition = bonus = IncenseAltarHandler.getIncenseBonusFromComponents(this.field_145850_b, this.field_174879_c, appliedTranquility, this.roadDistance);
        this.tranquility = appliedTranquility;
    }
}

