/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.tile;

import WayofTime.bloodmagic.entity.mob.EntityMimic;
import WayofTime.bloodmagic.registry.ModBlocks;
import WayofTime.bloodmagic.registry.ModItems;
import WayofTime.bloodmagic.tile.TileInventory;
import WayofTime.bloodmagic.util.ChatUtil;
import WayofTime.bloodmagic.util.Utils;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class TileMimic
extends TileInventory
implements ITickable {
    private static Field _blockMetadata = ReflectionHelper.findField(TileEntity.class, (String[])new String[]{"blockMetadata", "field_145847_g"});
    public boolean dropItemsOnBreak = true;
    public NBTTagCompound tileTag = new NBTTagCompound();
    public TileEntity mimicedTile = null;
    public int metaOfReplacedBlock = 0;
    public int playerCheckRadius = 5;
    public int potionSpawnRadius = 5;
    public int potionSpawnInterval = 40;
    private int internalCounter = 0;

    public TileMimic() {
        super(2, "mimic");
    }

    public void func_73660_a() {
        ItemStack potionStack;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ++this.internalCounter;
        if (this.internalCounter % this.potionSpawnInterval == 0 && this.func_145832_p() != 4 && (potionStack = this.func_70301_a(1)) != null) {
            AxisAlignedBB bb = new AxisAlignedBB(this.func_174877_v()).func_72314_b((double)this.playerCheckRadius, (double)this.playerCheckRadius, (double)this.playerCheckRadius);
            List playerList = this.field_145850_b.func_72872_a(EntityPlayer.class, bb);
            for (EntityPlayer player : playerList) {
                if (player.field_71075_bZ.field_75098_d) continue;
                double posX = (double)this.field_174879_c.func_177958_n() + 0.5 + (2.0 * this.field_145850_b.field_73012_v.nextDouble() - 1.0) * (double)this.potionSpawnRadius;
                double posY = (double)this.field_174879_c.func_177956_o() + 0.5 + (2.0 * this.field_145850_b.field_73012_v.nextDouble() - 1.0) * (double)this.potionSpawnRadius;
                double posZ = (double)this.field_174879_c.func_177952_p() + 0.5 + (2.0 * this.field_145850_b.field_73012_v.nextDouble() - 1.0) * (double)this.potionSpawnRadius;
                ItemStack newStack = new ItemStack((Item)(potionStack.func_77973_b() == ModItems.POTION_FLASK ? Items.field_185155_bH : potionStack.func_77973_b()));
                newStack.func_77982_d(potionStack.func_77978_p());
                EntityPotion potionEntity = new EntityPotion(this.field_145850_b, posX, posY, posZ, newStack);
                this.field_145850_b.func_72838_d((Entity)potionEntity);
                break;
            }
        }
        if (this.func_145832_p() == 4 && this.field_145850_b.func_175659_aa() != EnumDifficulty.PEACEFUL && !(this.mimicedTile instanceof IInventory)) {
            AxisAlignedBB bb = new AxisAlignedBB(this.func_174877_v()).func_72314_b((double)this.playerCheckRadius, (double)this.playerCheckRadius, (double)this.playerCheckRadius);
            List playerList = this.field_145850_b.func_72872_a(EntityPlayer.class, bb);
            for (EntityPlayer player : playerList) {
                if (player.field_71075_bZ.field_75098_d || !Utils.canEntitySeeBlock(this.field_145850_b, (Entity)player, this.func_174877_v())) continue;
                this.spawnMimicEntity(player);
                break;
            }
        }
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side) {
        if (heldItem != null && player.field_71075_bZ.field_75098_d) {
            List list = PotionUtils.func_185189_a((ItemStack)heldItem);
            if (list != null && !list.isEmpty()) {
                if (!world.field_72995_K) {
                    this.func_70299_a(1, heldItem.func_77946_l());
                    world.func_184138_a(pos, state, state, 3);
                    ChatUtil.sendNoSpam(player, new ITextComponent[]{new TextComponentTranslation("chat.BloodMagic.mimic.potionSet", new Object[0])});
                }
                return true;
            }
            if (heldItem.func_77973_b() == ModItems.POTION_FLASK) {
                if (!world.field_72995_K) {
                    this.func_70299_a(1, null);
                    world.func_184138_a(pos, state, state, 3);
                    ChatUtil.sendNoSpam(player, new ITextComponent[]{new TextComponentTranslation("chat.BloodMagic.mimic.potionRemove", new Object[0])});
                }
                return true;
            }
        }
        if (this.performSpecialAbility(player, side)) {
            return true;
        }
        if (player.func_70093_af()) {
            return false;
        }
        if (player.func_184586_b(hand) != null && player.func_184586_b(hand).func_77973_b() == new ItemStack(ModBlocks.MIMIC).func_77973_b()) {
            return false;
        }
        if (this.func_70301_a(0) != null && player.func_184586_b(hand) != null) {
            return false;
        }
        if (!this.dropItemsOnBreak && !player.field_71075_bZ.field_75098_d) {
            return false;
        }
        Utils.insertItemToTile(this, player, 0);
        this.refreshTileEntity();
        if (player.field_71075_bZ.field_75098_d) {
            this.dropItemsOnBreak = this.func_70301_a(0) == null;
        }
        world.func_184138_a(pos, state, state, 3);
        return true;
    }

    public boolean performSpecialAbility(EntityPlayer player, EnumFacing sideHit) {
        switch (this.func_145832_p()) {
            case 4: {
                if (player.field_71075_bZ.field_75098_d) {
                    if (player.func_70093_af()) {
                        this.playerCheckRadius = Math.max(this.playerCheckRadius - 1, 0);
                        ChatUtil.sendNoSpam(player, new ITextComponent[]{new TextComponentTranslation("chat.BloodMagic.mimic.detectRadius.down", new Object[]{this.playerCheckRadius})});
                    } else {
                        ++this.playerCheckRadius;
                        ChatUtil.sendNoSpam(player, new ITextComponent[]{new TextComponentTranslation("chat.BloodMagic.mimic.detectRadius.up", new Object[]{this.playerCheckRadius})});
                    }
                    return false;
                }
                return this.spawnMimicEntity(player);
            }
        }
        if (!player.field_71075_bZ.field_75098_d) {
            return false;
        }
        if (player.func_184607_cu() == null && this.func_70301_a(1) != null) {
            switch (sideHit) {
                case EAST: 
                case WEST: {
                    if (player.func_70093_af()) {
                        this.potionSpawnRadius = Math.max(this.potionSpawnRadius - 1, 0);
                        ChatUtil.sendNoSpam(player, new ITextComponent[]{new TextComponentTranslation("chat.BloodMagic.mimic.potionSpawnRadius.down", new Object[]{this.potionSpawnRadius})});
                        break;
                    }
                    ++this.potionSpawnRadius;
                    ChatUtil.sendNoSpam(player, new ITextComponent[]{new TextComponentTranslation("chat.BloodMagic.mimic.potionSpawnRadius.up", new Object[]{this.potionSpawnRadius})});
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    if (player.func_70093_af()) {
                        this.playerCheckRadius = Math.max(this.playerCheckRadius - 1, 0);
                        ChatUtil.sendNoSpam(player, new ITextComponent[]{new TextComponentTranslation("chat.BloodMagic.mimic.detectRadius.down", new Object[]{this.playerCheckRadius})});
                        break;
                    }
                    ++this.playerCheckRadius;
                    ChatUtil.sendNoSpam(player, new ITextComponent[]{new TextComponentTranslation("chat.BloodMagic.mimic.detectRadius.up", new Object[]{this.playerCheckRadius})});
                    break;
                }
                case UP: 
                case DOWN: {
                    if (player.func_70093_af()) {
                        this.potionSpawnInterval = Math.max(this.potionSpawnInterval - 1, 1);
                        ChatUtil.sendNoSpam(player, new ITextComponent[]{new TextComponentTranslation("chat.BloodMagic.mimic.potionInterval.down", new Object[]{this.potionSpawnInterval})});
                        break;
                    }
                    ++this.potionSpawnInterval;
                    ChatUtil.sendNoSpam(player, new ITextComponent[]{new TextComponentTranslation("chat.BloodMagic.mimic.potionInterval.up", new Object[]{this.potionSpawnInterval})});
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public boolean spawnMimicEntity(EntityPlayer target) {
        if (this.field_145850_b.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            return false;
        }
        if (this.func_70301_a(0) == null || this.field_145850_b.field_72995_K) {
            return false;
        }
        EntityMimic mimicEntity = new EntityMimic(this.field_145850_b);
        mimicEntity.func_70107_b((double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5);
        mimicEntity.initializeMimic(this.func_70301_a(0), this.tileTag, this.dropItemsOnBreak, this.metaOfReplacedBlock, this.playerCheckRadius, this.field_174879_c);
        this.tileTag = null;
        this.mimicedTile = null;
        this.func_70299_a(0, null);
        this.field_145850_b.func_72838_d((Entity)mimicEntity);
        if (target != null) {
            mimicEntity.func_70624_b((EntityLivingBase)target);
        }
        this.field_145850_b.func_175698_g(this.field_174879_c);
        return true;
    }

    public void refreshTileEntity() {
        if (this.mimicedTile != null) {
            this.dropMimicedTileInventory();
        }
        this.mimicedTile = TileMimic.getTileFromStackWithTag(this.field_145850_b, this.field_174879_c, this.func_70301_a(0), this.tileTag, this.metaOfReplacedBlock);
    }

    @Override
    public void deserialize(NBTTagCompound tag) {
        super.deserialize(tag);
        this.dropItemsOnBreak = tag.func_74767_n("dropItemsOnBreak");
        this.tileTag = tag.func_74775_l("tileTag");
        this.metaOfReplacedBlock = tag.func_74762_e("metaOfReplacedBlock");
        this.mimicedTile = TileMimic.getTileFromStackWithTag(this.field_145850_b, this.field_174879_c, this.func_70301_a(0), this.tileTag, this.metaOfReplacedBlock);
        this.playerCheckRadius = tag.func_74762_e("playerCheckRadius");
        this.potionSpawnRadius = tag.func_74762_e("potionSpawnRadius");
        this.potionSpawnInterval = Math.max(1, tag.func_74762_e("potionSpawnInterval"));
    }

    @Override
    public NBTTagCompound serialize(NBTTagCompound tag) {
        super.serialize(tag);
        tag.func_74757_a("dropItemsOnBreak", this.dropItemsOnBreak);
        tag.func_74782_a("tileTag", (NBTBase)this.tileTag);
        tag.func_74768_a("metaOfReplacedBlock", this.metaOfReplacedBlock);
        tag.func_74768_a("playerCheckRadius", this.playerCheckRadius);
        tag.func_74768_a("potionSpawnRadius", this.potionSpawnRadius);
        tag.func_74768_a("potionSpawnInterval", this.potionSpawnInterval);
        return tag;
    }

    public static void replaceMimicWithBlockActual(TileMimic mimic) {
        World world = mimic.func_145831_w();
        BlockPos pos = mimic.func_174877_v();
        TileMimic.replaceMimicWithBlockActual(world, pos, mimic.func_70301_a(0), mimic.tileTag, mimic.metaOfReplacedBlock);
    }

    public static boolean replaceMimicWithBlockActual(World world, BlockPos pos, ItemStack stack, NBTTagCompound tileTag, int replacedMeta) {
        Block block;
        IBlockState state;
        if (stack != null && stack.func_77973_b() instanceof ItemBlock && world.func_180501_a(pos, state = (block = ((ItemBlock)stack.func_77973_b()).func_179223_d()).func_176203_a(replacedMeta), 3)) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile != null) {
                tileTag.func_74768_a("x", pos.func_177958_n());
                tileTag.func_74768_a("y", pos.func_177956_o());
                tileTag.func_74768_a("z", pos.func_177952_p());
                tile.func_145839_a(tileTag);
            }
            return true;
        }
        return false;
    }

    public static TileEntity getTileFromStackWithTag(World world, BlockPos pos, ItemStack stack, NBTTagCompound tag, int replacementMeta) {
        Block block;
        if (stack != null && stack.func_77973_b() instanceof ItemBlock && (block = ((ItemBlock)stack.func_77973_b()).func_179223_d()) instanceof ITileEntityProvider) {
            TileEntity tile = ((ITileEntityProvider)block).func_149915_a(world, stack.func_77952_i());
            if (tag != null) {
                NBTTagCompound copyTag = (NBTTagCompound)tag.func_74737_b();
                copyTag.func_74768_a("x", pos.func_177958_n());
                copyTag.func_74768_a("y", pos.func_177956_o());
                copyTag.func_74768_a("z", pos.func_177952_p());
                tile.func_145839_a(copyTag);
            }
            tile.func_145834_a(world);
            try {
                _blockMetadata.setInt(tile, replacementMeta);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return tile;
        }
        return null;
    }

    @Override
    public void dropItems() {
        if (this.dropItemsOnBreak) {
            InventoryHelper.func_180175_a((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (IInventory)this);
        }
        this.dropMimicedTileInventory();
    }

    public void dropMimicedTileInventory() {
        if (!this.field_145850_b.field_72995_K && this.mimicedTile instanceof IInventory) {
            InventoryHelper.func_180175_a((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (IInventory)((IInventory)this.mimicedTile));
        }
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return slot == 0 && this.dropItemsOnBreak;
    }
}

