/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.tile;

import WayofTime.bloodmagic.api.recipe.TartaricForgeRecipe;
import WayofTime.bloodmagic.api.registry.TartaricForgeRecipeRegistry;
import WayofTime.bloodmagic.api.soul.EnumDemonWillType;
import WayofTime.bloodmagic.api.soul.IDemonWill;
import WayofTime.bloodmagic.api.soul.IDemonWillConduit;
import WayofTime.bloodmagic.api.soul.IDemonWillGem;
import WayofTime.bloodmagic.demonAura.WorldDemonWillHandler;
import WayofTime.bloodmagic.tile.TileInventory;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;

public class TileSoulForge
extends TileInventory
implements ITickable,
IDemonWillConduit {
    public static final int ticksRequired = 100;
    public static final double worldWillTransferRate = 1.0;
    public static final int soulSlot = 4;
    public static final int outputSlot = 5;
    public int burnTime = 0;

    public TileSoulForge() {
        super(6, "soulForge");
    }

    @Override
    public void deserialize(NBTTagCompound tag) {
        super.deserialize(tag);
        this.burnTime = tag.func_74762_e("burnTime");
    }

    @Override
    public NBTTagCompound serialize(NBTTagCompound tag) {
        super.serialize(tag);
        tag.func_74768_a("burnTime", this.burnTime);
        return tag;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            for (EnumDemonWillType type : EnumDemonWillType.values()) {
                double willInWorld = WorldDemonWillHandler.getCurrentWill(this.field_145850_b, this.field_174879_c, type);
                double filled = Math.min(willInWorld, 1.0);
                if (!(filled > 0.0)) continue;
                filled = this.fillDemonWill(type, filled, false);
                if (!((filled = WorldDemonWillHandler.drainWill(this.field_145850_b, this.field_174879_c, type, filled, false)) > 0.0)) continue;
                this.fillDemonWill(type, filled, true);
                WorldDemonWillHandler.drainWill(this.field_145850_b, this.field_174879_c, type, filled, true);
            }
        }
        if (!this.hasSoulGemOrSoul()) {
            this.burnTime = 0;
            return;
        }
        double soulsInGem = this.getWill();
        ArrayList<ItemStack> inputList = new ArrayList<ItemStack>();
        for (int i = 0; i < 4; ++i) {
            if (this.func_70301_a(i) == null) continue;
            inputList.add(this.func_70301_a(i));
        }
        TartaricForgeRecipe recipe = TartaricForgeRecipeRegistry.getMatchingRecipe(inputList, this.func_145831_w(), this.func_174877_v());
        if (recipe != null && (soulsInGem >= recipe.getMinimumSouls() || this.burnTime > 0)) {
            if (this.canCraft(recipe)) {
                ++this.burnTime;
                if (this.burnTime == 100) {
                    if (!this.field_145850_b.field_72995_K) {
                        double requiredSouls = recipe.getSoulsDrained();
                        if (requiredSouls > 0.0 && !this.field_145850_b.field_72995_K && soulsInGem >= recipe.getMinimumSouls()) {
                            this.consumeSouls(requiredSouls);
                        }
                        if (!this.field_145850_b.field_72995_K && soulsInGem >= recipe.getMinimumSouls()) {
                            this.craftItem(recipe);
                        }
                    }
                    this.burnTime = 0;
                } else if (this.burnTime > 110) {
                    this.burnTime = 0;
                }
            } else {
                this.burnTime = 0;
            }
        } else {
            this.burnTime = 0;
        }
    }

    public double getProgressForGui() {
        return (double)this.burnTime / 100.0;
    }

    private boolean canCraft(TartaricForgeRecipe recipe) {
        if (recipe == null) {
            return false;
        }
        ItemStack outputStack = recipe.getRecipeOutput();
        ItemStack currentOutputStack = this.func_70301_a(5);
        if (outputStack == null) {
            return false;
        }
        if (currentOutputStack == null) {
            return true;
        }
        if (!currentOutputStack.func_77969_a(outputStack)) {
            return false;
        }
        int result = currentOutputStack.field_77994_a + outputStack.field_77994_a;
        return result <= this.func_70297_j_() && result <= currentOutputStack.func_77976_d();
    }

    public void craftItem(TartaricForgeRecipe recipe) {
        if (this.canCraft(recipe)) {
            ItemStack outputStack = recipe.getRecipeOutput();
            ItemStack currentOutputStack = this.func_70301_a(5);
            if (currentOutputStack == null) {
                this.func_70299_a(5, outputStack);
            } else if (currentOutputStack.func_77973_b() == currentOutputStack.func_77973_b()) {
                currentOutputStack.field_77994_a += outputStack.field_77994_a;
            }
            this.consumeInventory();
        }
    }

    public boolean hasSoulGemOrSoul() {
        ItemStack soulStack = this.func_70301_a(4);
        return soulStack != null && (soulStack.func_77973_b() instanceof IDemonWill || soulStack.func_77973_b() instanceof IDemonWillGem);
    }

    public double getWill() {
        ItemStack soulStack = this.func_70301_a(4);
        if (soulStack != null) {
            if (soulStack.func_77973_b() instanceof IDemonWill) {
                IDemonWill soul = (IDemonWill)soulStack.func_77973_b();
                return soul.getWill(soulStack);
            }
            if (soulStack.func_77973_b() instanceof IDemonWillGem) {
                IDemonWillGem soul = (IDemonWillGem)soulStack.func_77973_b();
                return soul.getWill(EnumDemonWillType.DEFAULT, soulStack);
            }
        }
        return 0.0;
    }

    public double consumeSouls(double requested) {
        ItemStack soulStack = this.func_70301_a(4);
        if (soulStack != null) {
            if (soulStack.func_77973_b() instanceof IDemonWill) {
                IDemonWill soul = (IDemonWill)soulStack.func_77973_b();
                double souls = soul.drainWill(soulStack, requested);
                if (soul.getWill(soulStack) <= 0.0) {
                    this.func_70299_a(4, null);
                }
                return souls;
            }
            if (soulStack.func_77973_b() instanceof IDemonWillGem) {
                IDemonWillGem soul = (IDemonWillGem)soulStack.func_77973_b();
                return soul.drainWill(EnumDemonWillType.DEFAULT, soulStack, requested, true);
            }
        }
        return 0.0;
    }

    public void consumeInventory() {
        for (int i = 0; i < 4; ++i) {
            ItemStack inputStack = this.func_70301_a(i);
            if (inputStack == null) continue;
            if (inputStack.func_77973_b().hasContainerItem(inputStack)) {
                this.func_70299_a(i, inputStack.func_77973_b().getContainerItem(inputStack));
                continue;
            }
            --inputStack.field_77994_a;
            if (inputStack.field_77994_a > 0) continue;
            this.func_70299_a(i, null);
        }
    }

    @Override
    public int getWeight() {
        return 50;
    }

    @Override
    public double fillDemonWill(EnumDemonWillType type, double amount, boolean doFill) {
        if (amount <= 0.0) {
            return 0.0;
        }
        if (!this.canFill(type)) {
            return 0.0;
        }
        ItemStack stack = this.func_70301_a(4);
        if (stack == null || !(stack.func_77973_b() instanceof IDemonWillGem)) {
            return 0.0;
        }
        IDemonWillGem willGem = (IDemonWillGem)stack.func_77973_b();
        double filled = willGem.fillWill(type, stack, amount, doFill);
        return filled;
    }

    @Override
    public double drainDemonWill(EnumDemonWillType type, double amount, boolean doDrain) {
        ItemStack stack = this.func_70301_a(4);
        if (stack == null || !(stack.func_77973_b() instanceof IDemonWillGem)) {
            return 0.0;
        }
        IDemonWillGem willGem = (IDemonWillGem)stack.func_77973_b();
        double drained = amount;
        double current = willGem.getWill(type, stack);
        if (current < drained) {
            drained = current;
        }
        if (doDrain) {
            drained = willGem.drainWill(type, stack, drained, true);
        }
        return drained;
    }

    @Override
    public boolean canFill(EnumDemonWillType type) {
        return true;
    }

    @Override
    public boolean canDrain(EnumDemonWillType type) {
        return true;
    }

    @Override
    public double getCurrentWill(EnumDemonWillType type) {
        return 0.0;
    }
}

