/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.tile;

import WayofTime.bloodmagic.api.event.TeleposeEvent;
import WayofTime.bloodmagic.api.teleport.TeleportQueue;
import WayofTime.bloodmagic.api.util.helper.NBTHelper;
import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import WayofTime.bloodmagic.api.util.helper.PlayerHelper;
import WayofTime.bloodmagic.block.BlockTeleposer;
import WayofTime.bloodmagic.item.ItemTelepositionFocus;
import WayofTime.bloodmagic.ritual.portal.Teleports;
import WayofTime.bloodmagic.tile.TileInventory;
import WayofTime.bloodmagic.util.Utils;
import com.google.common.base.Strings;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileTeleposer
extends TileInventory
implements ITickable {
    public static final String TELEPOSER_RANGE = "teleposerRange";
    private int previousInput;

    public TileTeleposer() {
        super(1, "teleposer");
    }

    @Override
    public void deserialize(NBTTagCompound tagCompound) {
        super.deserialize(tagCompound);
        this.previousInput = tagCompound.func_74762_e("previousInput");
    }

    @Override
    public NBTTagCompound serialize(NBTTagCompound tagCompound) {
        super.serialize(tagCompound);
        tagCompound.func_74768_a("previousInput", this.previousInput);
        return tagCompound;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            int currentInput = this.field_145850_b.func_175676_y(this.field_174879_c);
            if (this.previousInput == 0 && currentInput != 0) {
                this.initiateTeleport();
            }
            this.previousInput = currentInput;
        }
    }

    public void initiateTeleport() {
        block10: {
            List focusWorldEntities;
            List originalWorldEntities;
            World focusWorld;
            BlockPos focusPos;
            ItemStack focusStack;
            block11: {
                if (this.field_145850_b.field_72995_K || this.field_145850_b.func_175625_s(this.field_174879_c) == null || !(this.field_145850_b.func_175625_s(this.field_174879_c) instanceof TileTeleposer) || !this.canInitiateTeleport((TileTeleposer)this.field_145850_b.func_175625_s(this.field_174879_c)) || !(this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockTeleposer)) break block10;
                TileTeleposer teleposer = (TileTeleposer)this.field_145850_b.func_175625_s(this.field_174879_c);
                focusStack = NBTHelper.checkNBT(teleposer.func_70301_a(0));
                ItemTelepositionFocus focus = (ItemTelepositionFocus)focusStack.func_77973_b();
                focusPos = focus.getBlockPos(teleposer.func_70301_a(0));
                focusWorld = focus.getWorld(teleposer.func_70301_a(0));
                if (focusWorld == null || !(focusWorld.func_175625_s(focusPos) instanceof TileTeleposer) || focusWorld.func_175625_s(focusPos).equals((Object)this)) break block10;
                int focusLevel = teleposer.func_70301_a(0).func_77952_i() + 1;
                int lpToBeDrained = (int)(0.5 * Math.sqrt((this.field_174879_c.func_177958_n() - focusPos.func_177958_n()) * (this.field_174879_c.func_177958_n() - focusPos.func_177958_n()) + (this.field_174879_c.func_177956_o() - focusPos.func_177956_o() + 1) * (this.field_174879_c.func_177956_o() - focusPos.func_177956_o() + 1) + (this.field_174879_c.func_177952_p() - focusPos.func_177952_p()) * (this.field_174879_c.func_177952_p() - focusPos.func_177952_p())));
                if (!NetworkHelper.getSoulNetwork(focus.getOwnerUUID(focusStack)).syphonAndDamage(PlayerHelper.getPlayerFromUUID(focus.getOwnerUUID(focusStack)), lpToBeDrained * (focusLevel * 2 - 1) * (focusLevel * 2 - 1) * (focusLevel * 2 - 1))) break block10;
                int blocksTransported = 0;
                for (int i = -(focusLevel - 1); i <= focusLevel - 1; ++i) {
                    for (int j = 0; j <= focusLevel * 2 - 2; ++j) {
                        for (int k = -(focusLevel - 1); k <= focusLevel - 1; ++k) {
                            TeleposeEvent event = new TeleposeEvent(this.field_145850_b, this.field_174879_c.func_177982_a(i, 1 + j, k), focusWorld, focusPos.func_177982_a(i, 1 + j, k));
                            if (!Utils.swapLocations(event.initalWorld, event.initialBlockPos, event.finalWorld, event.finalBlockPos) || MinecraftForge.EVENT_BUS.post((Event)event)) continue;
                            ++blocksTransported;
                        }
                    }
                }
                NetworkHelper.syphonFromContainer(focusStack, lpToBeDrained * blocksTransported);
                AxisAlignedBB originalArea = new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)Math.min(focusWorld.func_72800_K(), this.field_174879_c.func_177956_o() + 2 * focusLevel), (double)(this.field_174879_c.func_177952_p() + 1)).func_72314_b((double)(focusLevel - 1), 0.0, (double)(focusLevel - 1));
                originalWorldEntities = this.field_145850_b.func_72872_a(Entity.class, originalArea);
                AxisAlignedBB focusArea = new AxisAlignedBB((double)focusPos.func_177958_n(), (double)(focusPos.func_177956_o() + 1), (double)focusPos.func_177952_p(), (double)(focusPos.func_177958_n() + 1), (double)Math.min(focusWorld.func_72800_K(), focusPos.func_177956_o() + 2 * focusLevel), (double)(focusPos.func_177952_p() + 1)).func_72314_b((double)(focusLevel - 1), 0.0, (double)(focusLevel - 1));
                focusWorldEntities = focusWorld.func_72872_a(Entity.class, focusArea);
                if (!focusWorld.equals(this.field_145850_b)) break block11;
                if (!originalWorldEntities.isEmpty()) {
                    for (Entity entity : originalWorldEntities) {
                        TeleportQueue.getInstance().addITeleport(new Teleports.TeleportSameDim(new BlockPos(entity.field_70165_t - (double)this.field_174879_c.func_177958_n() + (double)focusPos.func_177958_n(), entity.field_70163_u - (double)this.field_174879_c.func_177956_o() + (double)focusPos.func_177956_o(), entity.field_70161_v - (double)this.field_174879_c.func_177952_p() + (double)focusPos.func_177952_p()), entity, focusStack.func_77978_p().func_74779_i("ownerUUID"), true));
                    }
                }
                if (focusWorldEntities.isEmpty()) break block10;
                for (Entity entity : focusWorldEntities) {
                    TeleportQueue.getInstance().addITeleport(new Teleports.TeleportSameDim(new BlockPos(entity.field_70165_t - (double)this.field_174879_c.func_177958_n() + (double)focusPos.func_177958_n(), entity.field_70163_u - (double)this.field_174879_c.func_177956_o() + (double)focusPos.func_177956_o(), entity.field_70161_v - (double)this.field_174879_c.func_177952_p() + (double)focusPos.func_177952_p()), entity, focusStack.func_77978_p().func_74779_i("ownerUUID"), true));
                }
                break block10;
            }
            if (!originalWorldEntities.isEmpty()) {
                for (Entity entity : originalWorldEntities) {
                    TeleportQueue.getInstance().addITeleport(new Teleports.TeleportToDim(new BlockPos(entity.field_70165_t - (double)this.field_174879_c.func_177958_n() + (double)focusPos.func_177958_n(), entity.field_70163_u - (double)this.field_174879_c.func_177956_o() + (double)focusPos.func_177956_o(), entity.field_70161_v - (double)this.field_174879_c.func_177952_p() + (double)focusPos.func_177952_p()), entity, focusStack.func_77978_p().func_74779_i("ownerUUID"), this.field_145850_b, focusWorld.field_73011_w.getDimension(), true));
                }
            }
            if (!focusWorldEntities.isEmpty()) {
                for (Entity entity : focusWorldEntities) {
                    TeleportQueue.getInstance().addITeleport(new Teleports.TeleportToDim(new BlockPos(entity.field_70165_t - (double)this.field_174879_c.func_177958_n() + (double)focusPos.func_177958_n(), entity.field_70163_u - (double)this.field_174879_c.func_177956_o() + (double)focusPos.func_177956_o(), entity.field_70161_v - (double)this.field_174879_c.func_177952_p() + (double)focusPos.func_177952_p()), entity, focusStack.func_77978_p().func_74779_i("ownerUUID"), focusWorld, this.field_145850_b.field_73011_w.getDimension(), true));
                }
            }
        }
    }

    private boolean canInitiateTeleport(TileTeleposer teleposer) {
        return teleposer.func_70301_a(0) != null && teleposer.func_70301_a(0).func_77973_b() instanceof ItemTelepositionFocus && !Strings.isNullOrEmpty((String)((ItemTelepositionFocus)teleposer.func_70301_a(0).func_77973_b()).getOwnerName(teleposer.func_70301_a(0)));
    }
}

