/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.tile.routing;

import WayofTime.bloodmagic.routing.IItemRoutingNode;
import WayofTime.bloodmagic.routing.IMasterRoutingNode;
import WayofTime.bloodmagic.routing.IRoutingNode;
import WayofTime.bloodmagic.tile.TileInventory;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileRoutingNode
extends TileInventory
implements IRoutingNode,
IItemRoutingNode,
ITickable {
    private int currentInput;
    private BlockPos masterPos = BlockPos.field_177992_a;
    private List<BlockPos> connectionList = new LinkedList<BlockPos>();

    public TileRoutingNode(int size, String name) {
        super(size, name);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.currentInput = this.field_145850_b.func_175687_A(this.field_174879_c);
        }
    }

    @Override
    public NBTTagCompound serialize(NBTTagCompound tag) {
        super.serialize(tag);
        NBTTagCompound masterTag = new NBTTagCompound();
        masterTag.func_74768_a("xCoord", this.masterPos.func_177958_n());
        masterTag.func_74768_a("yCoord", this.masterPos.func_177956_o());
        masterTag.func_74768_a("zCoord", this.masterPos.func_177952_p());
        tag.func_74782_a("master", (NBTBase)masterTag);
        NBTTagList tags = new NBTTagList();
        for (BlockPos pos : this.connectionList) {
            NBTTagCompound posTag = new NBTTagCompound();
            posTag.func_74768_a("xCoord", pos.func_177958_n());
            posTag.func_74768_a("yCoord", pos.func_177956_o());
            posTag.func_74768_a("zCoord", pos.func_177952_p());
            tags.func_74742_a((NBTBase)posTag);
        }
        tag.func_74782_a("connections", (NBTBase)tags);
        return tag;
    }

    @Override
    public void deserialize(NBTTagCompound tag) {
        super.deserialize(tag);
        this.connectionList.clear();
        NBTTagCompound masterTag = tag.func_74775_l("master");
        this.masterPos = new BlockPos(masterTag.func_74762_e("xCoord"), masterTag.func_74762_e("yCoord"), masterTag.func_74762_e("zCoord"));
        NBTTagList tags = tag.func_150295_c("connections", 10);
        for (int i = 0; i < tags.func_74745_c(); ++i) {
            NBTTagCompound blockTag = tags.func_150305_b(i);
            BlockPos newPos = new BlockPos(blockTag.func_74762_e("xCoord"), blockTag.func_74762_e("yCoord"), blockTag.func_74762_e("zCoord"));
            this.connectionList.add(newPos);
        }
    }

    @Override
    public void removeAllConnections() {
        TileEntity testTile = this.field_145850_b.func_175625_s(this.getMasterPos());
        if (testTile instanceof IMasterRoutingNode) {
            ((IMasterRoutingNode)testTile).removeConnection(this.field_174879_c);
        }
        for (BlockPos testPos : this.connectionList) {
            TileEntity tile = this.field_145850_b.func_175625_s(testPos);
            if (!(tile instanceof IRoutingNode)) continue;
            ((IRoutingNode)tile).removeConnection(this.field_174879_c);
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(testPos), this.func_145831_w().func_180495_p(testPos), 3);
        }
        this.connectionList.clear();
    }

    @Override
    public void connectMasterToRemainingNode(World world, List<BlockPos> alreadyChecked, IMasterRoutingNode master) {
        this.masterPos = master.getBlockPos();
        List<BlockPos> connectedList = this.getConnected();
        for (BlockPos testPos : connectedList) {
            IRoutingNode node;
            if (alreadyChecked.contains(testPos)) continue;
            alreadyChecked.add(testPos);
            TileEntity tile = world.func_175625_s(testPos);
            if (!(tile instanceof IRoutingNode) || !(node = (IRoutingNode)tile).getMasterPos().equals((Object)BlockPos.field_177992_a)) continue;
            master.addNodeToList(node);
            node.connectMasterToRemainingNode(world, alreadyChecked, master);
        }
        master.addConnections(this.getBlockPos(), connectedList);
    }

    @Override
    public BlockPos getBlockPos() {
        return this.func_174877_v();
    }

    @Override
    public List<BlockPos> getConnected() {
        return this.connectionList;
    }

    @Override
    public BlockPos getMasterPos() {
        return this.masterPos;
    }

    @Override
    public boolean isMaster(IMasterRoutingNode master) {
        BlockPos checkPos = master.getBlockPos();
        return checkPos.equals((Object)this.getMasterPos());
    }

    @Override
    public boolean isConnectionEnabled(BlockPos testPos) {
        return this.currentInput <= 0;
    }

    @Override
    public void addConnection(BlockPos pos1) {
        if (!this.connectionList.contains(pos1)) {
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
            this.connectionList.add(pos1);
        }
    }

    @Override
    public void removeConnection(BlockPos pos1) {
        if (this.connectionList.contains(pos1)) {
            this.connectionList.remove(pos1);
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
        }
        if (pos1.equals((Object)this.masterPos)) {
            this.masterPos = BlockPos.field_177992_a;
        }
    }

    @Override
    public boolean isInventoryConnectedToSide(EnumFacing side) {
        return false;
    }

    @Override
    public int getPriority(EnumFacing side) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 10000.0;
    }
}

