/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.util;

import WayofTime.bloodmagic.network.BloodMagicPacketHandler;
import WayofTime.bloodmagic.util.helper.TextHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ChatUtil {
    private static final int DELETION_ID = 2525277;
    private static int lastAdded;

    private static void sendNoSpamMessages(ITextComponent[] messages) {
        int i;
        GuiNewChat chat = Minecraft.func_71410_x().field_71456_v.func_146158_b();
        for (i = 2525277 + messages.length - 1; i <= lastAdded; ++i) {
            chat.func_146242_c(i);
        }
        for (i = 0; i < messages.length; ++i) {
            chat.func_146234_a(messages[i], 2525277 + i);
        }
        lastAdded = 2525277 + messages.length - 1;
    }

    public static ITextComponent wrap(String s) {
        return new TextComponentString(s);
    }

    public static ITextComponent[] wrap(String ... s) {
        ITextComponent[] ret = new ITextComponent[s.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ChatUtil.wrap(s[i]);
        }
        return ret;
    }

    public static ITextComponent wrapFormatted(String s, Object ... args) {
        return new TextComponentTranslation(s, args);
    }

    public static void sendChat(EntityPlayer player, String ... lines) {
        ChatUtil.sendChat(player, ChatUtil.wrap(lines));
    }

    public static void sendChatUnloc(EntityPlayer player, String ... unlocLines) {
        ChatUtil.sendChat(player, TextHelper.localizeAll(unlocLines));
    }

    public static void sendChat(EntityPlayer player, ITextComponent ... lines) {
        for (ITextComponent c : lines) {
            player.func_146105_b(c);
        }
    }

    public static void sendNoSpamClientUnloc(String ... unlocLines) {
        ChatUtil.sendNoSpamClient(TextHelper.localizeAll(unlocLines));
    }

    public static void sendNoSpamClient(String ... lines) {
        ChatUtil.sendNoSpamClient(ChatUtil.wrap(lines));
    }

    public static void sendNoSpamClient(ITextComponent ... lines) {
        ChatUtil.sendNoSpamMessages(lines);
    }

    public static void sendNoSpamUnloc(EntityPlayer player, String ... unlocLines) {
        ChatUtil.sendNoSpam(player, TextHelper.localizeAll(unlocLines));
    }

    public static void sendNoSpam(EntityPlayer player, String ... lines) {
        ChatUtil.sendNoSpam(player, ChatUtil.wrap(lines));
    }

    public static void sendNoSpam(EntityPlayer player, ITextComponent ... lines) {
        if (player instanceof EntityPlayerMP) {
            ChatUtil.sendNoSpam((EntityPlayerMP)player, lines);
        }
    }

    public static void sendNoSpamUnloc(EntityPlayerMP player, String ... unlocLines) {
        ChatUtil.sendNoSpam(player, TextHelper.localizeAll(unlocLines));
    }

    public static void sendNoSpam(EntityPlayerMP player, String ... lines) {
        ChatUtil.sendNoSpam(player, ChatUtil.wrap(lines));
    }

    public static void sendNoSpam(EntityPlayerMP player, ITextComponent ... lines) {
        if (lines.length > 0) {
            BloodMagicPacketHandler.INSTANCE.sendTo((IMessage)new PacketNoSpamChat(lines), player);
        }
    }

    public static class PacketNoSpamChat
    implements IMessage {
        private ITextComponent[] chatLines;

        public PacketNoSpamChat() {
            this.chatLines = new ITextComponent[0];
        }

        private PacketNoSpamChat(ITextComponent ... lines) {
            this.chatLines = lines;
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.chatLines.length);
            for (ITextComponent c : this.chatLines) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)ITextComponent.Serializer.func_150696_a((ITextComponent)c));
            }
        }

        public void fromBytes(ByteBuf buf) {
            this.chatLines = new ITextComponent[buf.readInt()];
            for (int i = 0; i < this.chatLines.length; ++i) {
                this.chatLines[i] = ITextComponent.Serializer.func_150699_a((String)ByteBufUtils.readUTF8String((ByteBuf)buf));
            }
        }

        public static class Handler
        implements IMessageHandler<PacketNoSpamChat, IMessage> {
            public IMessage onMessage(PacketNoSpamChat message, MessageContext ctx) {
                ChatUtil.sendNoSpamMessages(message.chatLines);
                return null;
            }
        }
    }
}

