/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.util;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.api.BlockStack;
import WayofTime.bloodmagic.api.altar.EnumAltarComponent;
import WayofTime.bloodmagic.api.iface.IDemonWillViewer;
import WayofTime.bloodmagic.api.util.helper.NBTHelper;
import WayofTime.bloodmagic.network.BloodMagicPacketHandler;
import WayofTime.bloodmagic.network.PlayerVelocityPacketProcessor;
import WayofTime.bloodmagic.registry.ModBlocks;
import WayofTime.bloodmagic.tile.TileInventory;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class Utils {
    public static Item getItem(ResourceLocation resource) {
        return (Item)Item.field_150901_e.func_82594_a((Object)resource);
    }

    public static Block getBlock(ResourceLocation resource) {
        return (Block)Block.field_149771_c.func_82594_a((Object)resource);
    }

    public static ResourceLocation getResourceForItem(ItemStack stack) {
        if (stack != null) {
            if (stack.func_77973_b() instanceof ItemBlock) {
                return (ResourceLocation)Block.field_149771_c.func_177774_c((Object)((ItemBlock)stack.func_77973_b()).func_179223_d());
            }
            return (ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.func_77973_b());
        }
        return null;
    }

    public static boolean canPlayerSeeDemonWill(EntityPlayer player) {
        ItemStack[] mainInventory;
        for (ItemStack stack : mainInventory = player.field_71071_by.field_70462_a) {
            if (stack == null || !(stack.func_77973_b() instanceof IDemonWillViewer) || !((IDemonWillViewer)stack.func_77973_b()).canSeeDemonWillAura(player.field_70170_p, stack, player)) continue;
            return true;
        }
        return false;
    }

    public static boolean canEntitySeeBlock(World world, Entity entity, BlockPos pos) {
        Vec3d relativePosition = new Vec3d(entity.field_70165_t - (double)pos.func_177958_n() - 0.5, entity.field_70163_u + (double)entity.func_70047_e() - (double)pos.func_177956_o() - 0.5, entity.field_70161_v - (double)pos.func_177952_p() - 0.5);
        EnumFacing dir = EnumFacing.func_176737_a((float)((float)relativePosition.field_72450_a), (float)((float)relativePosition.field_72448_b), (float)((float)relativePosition.field_72449_c));
        RayTraceResult result = world.func_147447_a(new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v), new Vec3d((double)pos.func_177958_n() + 0.5 + (double)dir.func_82601_c() * 0.4, (double)pos.func_177956_o() + 0.5 + (double)dir.func_96559_d() * 0.4, (double)pos.func_177952_p() + 0.5 + (double)dir.func_82599_e() * 0.4), false, true, true);
        if (result != null) {
            return pos.equals((Object)result.func_178782_a());
        }
        return result != null;
    }

    public static int plantSeedsInArea(World world, AxisAlignedBB aabb, int horizontalRadius, int verticalRadius) {
        int placedBlocks = 0;
        List itemEntities = world.func_72872_a(EntityItem.class, aabb);
        for (EntityItem itemEntity : itemEntities) {
            placedBlocks += Utils.plantEntityItem(itemEntity, horizontalRadius, verticalRadius);
        }
        return placedBlocks;
    }

    public static int plantItemStack(World world, BlockPos centralPos, ItemStack stack, int horizontalRadius, int verticalRadius) {
        if (stack == null || stack.field_77994_a <= 0) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (!(item instanceof IPlantable)) {
            return 0;
        }
        int planted = 0;
        for (int hR = 0; hR <= horizontalRadius; ++hR) {
            for (int vR = 0; vR <= verticalRadius; ++vR) {
                for (int i = -hR; i <= hR; ++i) {
                    for (int k = -hR; k <= hR; ++k) {
                        for (int j = -vR; j <= vR; j += 2 * vR + (vR > 0 ? 0 : 1)) {
                            BlockPos offsetPos;
                            IBlockState state;
                            BlockPos newPos;
                            if (Math.abs(i) != hR && Math.abs(k) != hR || !world.func_175623_d(newPos = centralPos.func_177982_a(i, j, k)) || !(state = world.func_180495_p(offsetPos = newPos.func_177972_a(EnumFacing.DOWN))).func_177230_c().canSustainPlant(state, (IBlockAccess)world, offsetPos, EnumFacing.UP, (IPlantable)item)) continue;
                            IBlockState plantState = ((IPlantable)item).getPlant((IBlockAccess)world, newPos);
                            world.func_180501_a(newPos, plantState, 3);
                            world.func_175718_b(2001, newPos, Block.func_149682_b((Block)plantState.func_177230_c()) + (plantState.func_177230_c().func_176201_c(plantState) << 12));
                            --stack.field_77994_a;
                            ++planted;
                            if (stack.field_77994_a > 0) continue;
                            return planted;
                        }
                    }
                }
            }
        }
        return planted;
    }

    public static int plantEntityItem(EntityItem itemEntity, int horizontalRadius, int verticalRadius) {
        if (itemEntity == null || itemEntity.field_70128_L) {
            return 0;
        }
        World world = itemEntity.field_70170_p;
        BlockPos pos = itemEntity.func_180425_c();
        ItemStack stack = itemEntity.func_92059_d();
        int planted = Utils.plantItemStack(world, pos, stack, horizontalRadius, verticalRadius);
        if (stack.field_77994_a <= 0) {
            itemEntity.func_70106_y();
        }
        return planted;
    }

    public static int getDemonWillResolution(EntityPlayer player) {
        ItemStack[] mainInventory;
        for (ItemStack stack : mainInventory = player.field_71071_by.field_70462_a) {
            if (stack == null || !(stack.func_77973_b() instanceof IDemonWillViewer) || !((IDemonWillViewer)stack.func_77973_b()).canSeeDemonWillAura(player.field_70170_p, stack, player)) continue;
            return ((IDemonWillViewer)stack.func_77973_b()).getDemonWillAuraResolution(player.field_70170_p, stack, player);
        }
        return 1;
    }

    public static NBTTagCompound getPersistentDataTag(EntityPlayer player) {
        NBTTagCompound forgeData = player.getEntityData().func_74775_l("PlayerPersisted");
        NBTTagCompound beaconData = forgeData.func_74775_l("BloodMagic");
        if (!forgeData.func_74764_b("BloodMagic")) {
            forgeData.func_74782_a("BloodMagic", (NBTBase)beaconData);
        }
        if (!player.getEntityData().func_74764_b("PlayerPersisted")) {
            player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)forgeData);
        }
        return beaconData;
    }

    public static void setPlayerSpeedFromServer(EntityPlayer player, double motionX, double motionY, double motionZ) {
        if (!player.field_70170_p.field_72995_K && player instanceof EntityPlayerMP) {
            BloodMagicPacketHandler.sendTo(new PlayerVelocityPacketProcessor(motionX, motionY, motionZ), (EntityPlayerMP)player);
        }
    }

    public static boolean isInteger(String integer) {
        try {
            Integer.parseInt(integer);
        }
        catch (NumberFormatException e) {
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
        return true;
    }

    public static String toFancyCasing(String input) {
        return String.valueOf(input.charAt(0)).toUpperCase(Locale.ENGLISH) + input.substring(1);
    }

    public static String prettifyBlockPosString(BlockPos pos) {
        return "[" + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p() + "]";
    }

    public static boolean insertItemToTile(TileInventory tile, EntityPlayer player) {
        return Utils.insertItemToTile(tile, player, 0);
    }

    public static boolean insertItemToTile(TileInventory tile, EntityPlayer player, int slot) {
        if (tile.func_70301_a(slot) == null && player.func_184614_ca() != null) {
            ItemStack input = player.func_184614_ca().func_77946_l();
            input.field_77994_a = 1;
            --player.func_184614_ca().field_77994_a;
            tile.func_70299_a(slot, input);
            return true;
        }
        if (tile.func_70301_a(slot) != null && player.func_184614_ca() == null) {
            if (!tile.func_145831_w().field_72995_K) {
                EntityItem invItem = new EntityItem(tile.func_145831_w(), player.field_70165_t, player.field_70163_u + 0.25, player.field_70161_v, tile.func_70301_a(slot));
                tile.func_145831_w().func_72838_d((Entity)invItem);
            }
            tile.func_174888_l();
            return false;
        }
        return false;
    }

    public static double calculateStandardProgress(Number currentValue, int[] requiredValues, int currentLevel) {
        int nextLevel = currentLevel + 1;
        if (nextLevel >= requiredValues.length) {
            return 1.0;
        }
        int required = requiredValues[nextLevel];
        return Double.parseDouble("" + currentValue) / (double)required;
    }

    @Nullable
    public static IItemHandler getInventory(TileEntity tile, @Nullable EnumFacing facing) {
        if (facing == null) {
            facing = EnumFacing.DOWN;
        }
        IItemHandler itemHandler = null;
        if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
            itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
        } else if (tile instanceof ISidedInventory) {
            itemHandler = ((ISidedInventory)tile).func_180463_a(facing).length != 0 ? new SidedInvWrapper((ISidedInventory)tile, facing) : null;
        } else if (tile instanceof IInventory) {
            itemHandler = new InvWrapper((IInventory)tile);
        }
        return itemHandler;
    }

    public static ItemStack setUnbreakable(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        stack.func_77978_p().func_74757_a("Unbreakable", true);
        return stack;
    }

    public static Block getBlockForComponent(EnumAltarComponent component) {
        switch (component) {
            case GLOWSTONE: {
                return Blocks.field_150426_aN;
            }
            case BLOODSTONE: {
                return ModBlocks.BLOOD_STONE;
            }
            case BEACON: {
                return Blocks.field_150461_bJ;
            }
            case BLOODRUNE: {
                return ModBlocks.BLOOD_RUNE;
            }
            case CRYSTAL: {
                return ModBlocks.CRYSTAL;
            }
            case NOTAIR: {
                return Blocks.field_150417_aV;
            }
        }
        return Blocks.field_150350_a;
    }

    public static float getModifiedDamage(EntityLivingBase attackedEntity, DamageSource source, float amount) {
        if (!attackedEntity.func_180431_b(source)) {
            if (amount <= 0.0f) {
                return 0.0f;
            }
            amount = Utils.applyArmor(attackedEntity, (ItemStack[])Iterables.toArray((Iterable)attackedEntity.func_184209_aF(), ItemStack.class), source, amount);
            if (amount <= 0.0f) {
                return 0.0f;
            }
            amount = Utils.applyPotionDamageCalculations(attackedEntity, source, amount);
            return amount;
        }
        return 0.0f;
    }

    public static float applyArmor(EntityLivingBase entity, ItemStack[] inventory, DamageSource source, double damage) {
        damage *= 25.0;
        ArrayList<ISpecialArmor.ArmorProperties> dmgVals = new ArrayList<ISpecialArmor.ArmorProperties>();
        for (int x = 0; x < inventory.length; ++x) {
            ISpecialArmor armor;
            ItemStack stack = inventory[x];
            if (stack == null) continue;
            ISpecialArmor.ArmorProperties prop = null;
            if (stack.func_77973_b() instanceof ISpecialArmor) {
                armor = (ISpecialArmor)stack.func_77973_b();
                prop = armor.getProperties(entity, stack, source, damage / 25.0, x).copy();
            } else if (stack.func_77973_b() instanceof ItemArmor && !source.func_76363_c()) {
                armor = (ItemArmor)stack.func_77973_b();
                prop = new ISpecialArmor.ArmorProperties(0, (double)armor.field_77879_b / 25.0, Integer.MAX_VALUE);
            }
            if (prop == null) continue;
            prop.Slot = x;
            dmgVals.add(prop);
        }
        if (dmgVals.size() > 0) {
            ISpecialArmor.ArmorProperties[] props = dmgVals.toArray(new ISpecialArmor.ArmorProperties[dmgVals.size()]);
            int level = props[0].Priority;
            double ratio = 0.0;
            for (ISpecialArmor.ArmorProperties prop : props) {
                if (level != prop.Priority) {
                    damage -= damage * ratio;
                    ratio = 0.0;
                    level = prop.Priority;
                }
                ratio += prop.AbsorbRatio;
            }
            damage -= damage * ratio;
        }
        return (float)(damage / 25.0);
    }

    public static float applyPotionDamageCalculations(EntityLivingBase attackedEntity, DamageSource source, float damage) {
        Potion resistance = MobEffects.field_76429_m;
        if (source.func_151517_h()) {
            return damage;
        }
        if (attackedEntity.func_70644_a(resistance) && source != DamageSource.field_76380_i) {
            int i = (attackedEntity.func_70660_b(resistance).func_76458_c() + 1) * 5;
            int j = 25 - i;
            float f = damage * (float)j;
            damage = f / 25.0f;
        }
        if (damage <= 0.0f) {
            return 0.0f;
        }
        int k = EnchantmentHelper.func_77508_a((Iterable)attackedEntity.func_184193_aE(), (DamageSource)source);
        if (k > 20) {
            k = 20;
        }
        if (k > 0 && k <= 20) {
            int l = 25 - k;
            float f1 = damage * (float)l;
            damage = f1 / 25.0f;
        }
        return damage;
    }

    public static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null) {
            return false;
        }
        if (stack2 == null) {
            return true;
        }
        if (stack1.func_77984_f() ^ stack2.func_77984_f()) {
            return false;
        }
        return stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77952_i() == stack2.func_77952_i() && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static ItemStack[] combineStacks(ItemStack stack1, ItemStack stack2, int transferMax) {
        int transferedAmount;
        ItemStack[] returned = new ItemStack[2];
        if (Utils.canCombine(stack1, stack2) && (transferedAmount = Math.min(transferMax, stack2 == null ? stack1.field_77994_a : Math.min(stack2.func_77976_d() - stack2.field_77994_a, stack1.field_77994_a))) > 0) {
            ItemStack copyStack = stack1.func_77979_a(transferedAmount);
            if (stack2 == null) {
                stack2 = copyStack;
            } else {
                stack2.field_77994_a += transferedAmount;
            }
        }
        returned[0] = stack1;
        returned[1] = stack2;
        return returned;
    }

    public static ItemStack[] combineStacks(ItemStack stack1, ItemStack stack2) {
        ItemStack[] returned = new ItemStack[2];
        if (Utils.canCombine(stack1, stack2)) {
            int transferedAmount;
            int n = transferedAmount = stack2 == null ? stack1.field_77994_a : Math.min(stack2.func_77976_d() - stack2.field_77994_a, stack1.field_77994_a);
            if (transferedAmount > 0) {
                ItemStack copyStack = stack1.func_77979_a(transferedAmount);
                if (stack2 == null) {
                    stack2 = copyStack;
                } else {
                    stack2.field_77994_a += transferedAmount;
                }
            }
        }
        returned[0] = stack1;
        returned[1] = stack2;
        return returned;
    }

    public static ItemStack insertStackIntoTile(ItemStack stack, TileEntity tile, EnumFacing dir) {
        if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir)) {
            IItemHandler handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir);
            return Utils.insertStackIntoTile(stack, handler);
        }
        if (tile instanceof IInventory) {
            return Utils.insertStackIntoInventory(stack, (IInventory)tile, dir);
        }
        return stack;
    }

    public static int getNumberOfFreeSlots(TileEntity tile, EnumFacing dir) {
        int slots;
        block3: {
            block2: {
                slots = 0;
                if (!tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir)) break block2;
                IItemHandler handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir);
                for (int i = 0; i < handler.getSlots(); ++i) {
                    if (handler.getStackInSlot(i) != null) continue;
                    ++slots;
                }
                break block3;
            }
            if (!(tile instanceof IInventory)) break block3;
            for (int i = 0; i < ((IInventory)tile).func_70302_i_(); ++i) {
                if (((IInventory)tile).func_70301_a(i) != null) continue;
                ++slots;
            }
        }
        return slots;
    }

    public static ItemStack insertStackIntoTile(ItemStack stack, IItemHandler handler) {
        int numberOfSlots = handler.getSlots();
        ItemStack copyStack = stack.func_77946_l();
        for (int slot = 0; slot < numberOfSlots; ++slot) {
            if ((copyStack = handler.insertItem(slot, copyStack, false)) != null) continue;
            return null;
        }
        return copyStack;
    }

    public static ItemStack insertStackIntoTile(ItemStack stack, TileEntity tile, EnumFacing dir, int limit) {
        if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir)) {
            IItemHandler handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir);
            int numberOfSlots = handler.getSlots();
            ItemStack copyStack = stack.func_77946_l();
            int numberMatching = 0;
            for (int slot = 0; slot < numberOfSlots; ++slot) {
                ItemStack invStack = handler.getStackInSlot(slot);
                if (invStack == null || !Utils.canCombine(stack, invStack)) continue;
                numberMatching += invStack.field_77994_a;
            }
            if (numberMatching >= limit) {
                return stack;
            }
            int newLimit = limit - numberMatching;
            for (int slot = 0; slot < numberOfSlots; ++slot) {
                ItemStack newCopyStack = copyStack.func_77946_l();
                newCopyStack.field_77994_a = Math.min(copyStack.field_77994_a, newLimit);
                if ((newCopyStack = handler.insertItem(slot, newCopyStack, false)) == null) {
                    return null;
                }
                if ((newLimit -= copyStack.field_77994_a - newCopyStack.field_77994_a) <= 0) {
                    return null;
                }
                copyStack.field_77994_a -= copyStack.field_77994_a - newCopyStack.field_77994_a;
            }
            return copyStack;
        }
        if (tile instanceof IInventory) {
            return Utils.insertStackIntoInventory(stack, (IInventory)tile, dir, limit);
        }
        return stack;
    }

    public static ItemStack insertStackIntoInventory(ItemStack stack, IInventory inventory, EnumFacing dir) {
        if (stack == null) {
            return null;
        }
        boolean[] canBeInserted = new boolean[inventory.func_70302_i_()];
        if (inventory instanceof ISidedInventory) {
            int[] array;
            for (int in : array = ((ISidedInventory)inventory).func_180463_a(dir)) {
                canBeInserted[in] = inventory.func_94041_b(in, stack) && ((ISidedInventory)inventory).func_180462_a(in, stack, dir);
            }
        } else {
            for (int i = 0; i < canBeInserted.length; ++i) {
                canBeInserted[i] = inventory.func_94041_b(i, stack);
            }
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!canBeInserted[i]) continue;
            ItemStack[] combinedStacks = Utils.combineStacks(stack, inventory.func_70301_a(i));
            stack = combinedStacks[0];
            inventory.func_70299_a(i, combinedStacks[1]);
            if (stack.field_77994_a > 0) continue;
            return stack;
        }
        return stack;
    }

    public static boolean canInsertStackFullyIntoInventory(ItemStack stack, IInventory inventory, EnumFacing dir) {
        return Utils.canInsertStackFullyIntoInventory(stack, inventory, dir, false, 0);
    }

    public static boolean canInsertStackFullyIntoInventory(ItemStack stack, IInventory inventory, EnumFacing dir, boolean fillToLimit, int limit) {
        if (stack == null) {
            return true;
        }
        int itemsLeft = stack.field_77994_a;
        boolean[] canBeInserted = new boolean[inventory.func_70302_i_()];
        if (inventory instanceof ISidedInventory) {
            int[] array;
            for (int in : array = ((ISidedInventory)inventory).func_180463_a(dir)) {
                canBeInserted[in] = inventory.func_94041_b(in, stack) && ((ISidedInventory)inventory).func_180462_a(in, stack, dir);
            }
        } else {
            for (int i = 0; i < canBeInserted.length; ++i) {
                canBeInserted[i] = inventory.func_94041_b(i, stack);
            }
        }
        int numberMatching = 0;
        if (fillToLimit) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack invStack;
                if (!canBeInserted[i] || (invStack = inventory.func_70301_a(i)) == null || !Utils.canCombine(stack, invStack)) continue;
                numberMatching += invStack.field_77994_a;
            }
        }
        if (fillToLimit && limit < stack.field_77994_a + numberMatching) {
            return false;
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!canBeInserted[i]) continue;
            ItemStack invStack = inventory.func_70301_a(i);
            boolean canCombine = Utils.canCombine(stack, invStack);
            if (canCombine) {
                itemsLeft = invStack == null ? 0 : (itemsLeft -= invStack.func_77976_d() - invStack.field_77994_a);
            }
            if (itemsLeft > 0) continue;
            return true;
        }
        return false;
    }

    public static ItemStack insertStackIntoInventory(ItemStack stack, IInventory inventory, EnumFacing dir, int limit) {
        if (stack == null) {
            return null;
        }
        boolean[] canBeInserted = new boolean[inventory.func_70302_i_()];
        if (inventory instanceof ISidedInventory) {
            int[] array;
            for (int in : array = ((ISidedInventory)inventory).func_180463_a(dir)) {
                canBeInserted[in] = ((ISidedInventory)inventory).func_180462_a(in, stack, dir);
            }
        } else {
            for (int i = 0; i < canBeInserted.length; ++i) {
                canBeInserted[i] = true;
            }
        }
        int numberMatching = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack invStack;
            if (!canBeInserted[i] || (invStack = inventory.func_70301_a(i)) == null || !Utils.canCombine(stack, invStack)) continue;
            numberMatching += invStack.field_77994_a;
        }
        if (numberMatching >= limit) {
            return stack;
        }
        int newLimit = limit - numberMatching;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!canBeInserted[i]) continue;
            int prevStackSize = stack.field_77994_a;
            ItemStack[] combinedStacks = Utils.combineStacks(stack, inventory.func_70301_a(i), newLimit);
            stack = combinedStacks[0];
            inventory.func_70299_a(i, combinedStacks[1]);
            if ((newLimit -= prevStackSize - stack.field_77994_a) > 0 && stack.field_77994_a > 0) continue;
            return stack;
        }
        return stack;
    }

    public static boolean isBlockLiquid(IBlockState state) {
        return state instanceof IFluidBlock || state.func_185904_a().func_76224_d();
    }

    public static boolean isFlowingLiquid(World world, BlockPos pos, IBlockState state) {
        Block block = state.func_177230_c();
        return block instanceof IFluidBlock && Math.abs(((IFluidBlock)block).getFilledPercentage(world, pos)) == 1.0f || block instanceof BlockLiquid && block.func_176201_c(state) != 0;
    }

    public static boolean spawnStackAtBlock(World world, BlockPos pos, @Nullable EnumFacing pushDirection, ItemStack stack) {
        EntityItem entityItem = new EntityItem(world);
        BlockPos spawnPos = new BlockPos((Vec3i)pos);
        double velocity = 0.15;
        if (pushDirection != null) {
            spawnPos.func_177972_a(pushDirection);
            switch (pushDirection) {
                case DOWN: {
                    entityItem.field_70181_x = -velocity;
                    entityItem.func_70107_b((double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o() - 1.0, (double)spawnPos.func_177952_p() + 0.5);
                    break;
                }
                case UP: {
                    entityItem.field_70181_x = velocity;
                    entityItem.func_70107_b((double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o() + 1.0, (double)spawnPos.func_177952_p() + 0.5);
                    break;
                }
                case NORTH: {
                    entityItem.field_70179_y = -velocity;
                    entityItem.func_70107_b((double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o() + 0.5, (double)spawnPos.func_177952_p() - 1.0);
                    break;
                }
                case SOUTH: {
                    entityItem.field_70179_y = velocity;
                    entityItem.func_70107_b((double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o() + 0.5, (double)spawnPos.func_177952_p() + 1.0);
                    break;
                }
                case WEST: {
                    entityItem.field_70159_w = -velocity;
                    entityItem.func_70107_b((double)spawnPos.func_177958_n() - 1.0, (double)spawnPos.func_177956_o() + 0.5, (double)spawnPos.func_177952_p() + 0.5);
                    break;
                }
                case EAST: {
                    entityItem.field_70159_w = velocity;
                    entityItem.func_70107_b((double)spawnPos.func_177958_n() + 1.0, (double)spawnPos.func_177956_o() + 0.5, (double)spawnPos.func_177952_p() + 0.5);
                }
            }
        }
        entityItem.func_92058_a(stack);
        return world.func_72838_d((Entity)entityItem);
    }

    public static boolean swapLocations(World initialWorld, BlockPos initialPos, World finalWorld, BlockPos finalPos) {
        return Utils.swapLocations(initialWorld, initialPos, finalWorld, finalPos, true);
    }

    public static boolean swapLocations(World initialWorld, BlockPos initialPos, World finalWorld, BlockPos finalPos, boolean playSound) {
        TileEntity initialTile = initialWorld.func_175625_s(initialPos);
        TileEntity finalTile = finalWorld.func_175625_s(finalPos);
        NBTTagCompound initialTag = new NBTTagCompound();
        NBTTagCompound finalTag = new NBTTagCompound();
        if (initialTile != null) {
            initialTile.func_189515_b(initialTag);
        }
        if (finalTile != null) {
            finalTile.func_189515_b(finalTag);
        }
        BlockStack initialStack = BlockStack.getStackFromPos(initialWorld, initialPos);
        BlockStack finalStack = BlockStack.getStackFromPos(finalWorld, finalPos);
        if (initialStack.getBlock().equals(Blocks.field_150350_a) && finalStack.getBlock().equals(Blocks.field_150350_a) || initialStack.getBlock() instanceof BlockPortal || finalStack.getBlock() instanceof BlockPortal) {
            return false;
        }
        if (playSound) {
            initialWorld.func_184134_a((double)initialPos.func_177958_n(), (double)initialPos.func_177956_o(), (double)initialPos.func_177952_p(), SoundEvents.field_187534_aX, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
            finalWorld.func_184134_a((double)finalPos.func_177958_n(), (double)finalPos.func_177956_o(), (double)finalPos.func_177952_p(), SoundEvents.field_187534_aX, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
        }
        if (finalStack.getBlock() != null) {
            finalWorld.func_175713_t(finalPos);
        }
        if (initialStack.getBlock() != null) {
            initialWorld.func_175713_t(initialPos);
        }
        IBlockState initialBlockState = initialWorld.func_180495_p(initialPos);
        IBlockState finalBlockState = finalWorld.func_180495_p(finalPos);
        finalWorld.func_180501_a(finalPos, initialBlockState, 3);
        if (initialTile != null) {
            TileEntity newTileInitial = BloodMagic.getCrossVersionProxy().createTileFromData(finalWorld, initialTag);
            finalWorld.func_175690_a(finalPos, newTileInitial);
            newTileInitial.func_174878_a(finalPos);
            newTileInitial.func_145834_a(finalWorld);
        }
        initialWorld.func_180501_a(initialPos, finalBlockState, 3);
        if (finalTile != null) {
            TileEntity newTileFinal = BloodMagic.getCrossVersionProxy().createTileFromData(initialWorld, finalTag);
            initialWorld.func_175690_a(initialPos, newTileFinal);
            newTileFinal.func_174878_a(initialPos);
            newTileFinal.func_145834_a(initialWorld);
        }
        initialWorld.func_175685_c(initialPos, finalStack.getBlock());
        finalWorld.func_175685_c(finalPos, initialStack.getBlock());
        return true;
    }

    public static boolean fillContainerFromHandler(World world, IFluidHandler handler, EntityPlayer player, FluidStack tankFluid) {
        ItemStack container = player.func_184614_ca();
        if (FluidContainerRegistry.isEmptyContainer((ItemStack)container)) {
            ItemStack returnStack = FluidContainerRegistry.fillFluidContainer((FluidStack)tankFluid, (ItemStack)container);
            FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)returnStack);
            if (fluid == null || returnStack == null) {
                return false;
            }
            if (!player.field_71075_bZ.field_75098_d) {
                if (container.field_77994_a == 1) {
                    container = container.func_77946_l();
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, returnStack);
                } else if (!player.field_71071_by.func_70441_a(returnStack)) {
                    return false;
                }
                handler.drain(EnumFacing.UP, fluid.amount, true);
                --container.field_77994_a;
                if (container.field_77994_a <= 0) {
                    container = null;
                }
            } else {
                handler.drain(EnumFacing.UP, fluid.amount, true);
            }
            return true;
        }
        return false;
    }

    public static boolean fillHandlerWithContainer(World world, IFluidHandler handler, EntityPlayer player) {
        ItemStack container = player.func_184614_ca();
        FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)container);
        if (fluid != null && (handler.fill(EnumFacing.UP, fluid, false) == fluid.amount || player.field_71075_bZ.field_75098_d)) {
            if (world.field_72995_K) {
                return true;
            }
            handler.fill(EnumFacing.UP, fluid, true);
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, Utils.consumeItem(container));
            }
            return true;
        }
        return false;
    }

    public static ItemStack consumeItem(ItemStack stack) {
        boolean largerStack;
        Item item = stack.func_77973_b();
        boolean bl = largerStack = stack.field_77994_a > 1;
        if (largerStack) {
            --stack.field_77994_a;
        }
        if (item.hasContainerItem(stack)) {
            ItemStack ret = item.getContainerItem(stack);
            if (ret == null) {
                return null;
            }
            if (ret.func_77984_f() && ret.func_77952_i() > ret.func_77958_k()) {
                ret = null;
            }
            return ret;
        }
        return largerStack ? stack : null;
    }

    public static void registerHandlers(Set<ASMDataTable.ASMData> eventHandlers) {
        for (ASMDataTable.ASMData data : eventHandlers) {
            try {
                Class<?> handlerClass = Class.forName(data.getClassName());
                Object handlerImpl = handlerClass.newInstance();
                MinecraftForge.EVENT_BUS.register(handlerImpl);
                BloodMagic.instance.getLogger().debug("Registering event handler for class {}", data.getClassName());
            }
            catch (Exception exception) {}
        }
    }

    public static boolean hasUUID(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("mostSig") && stack.func_77978_p().func_74764_b("leastSig");
    }

    public static UUID getUUID(ItemStack stack) {
        if (!Utils.hasUUID(stack)) {
            return null;
        }
        return new UUID(stack.func_77978_p().func_74763_f("mostSig"), stack.func_77978_p().func_74763_f("leastSig"));
    }

    public static void setUUID(ItemStack stack) {
        if (!(stack = NBTHelper.checkNBT(stack)).func_77978_p().func_74764_b("mostSig") && !stack.func_77978_p().func_74764_b("leastSig")) {
            UUID itemUUID = UUID.randomUUID();
            stack.func_77978_p().func_74772_a("mostSig", itemUUID.getMostSignificantBits());
            stack.func_77978_p().func_74772_a("leastSig", itemUUID.getLeastSignificantBits());
        }
    }
}

