/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.util.handler.event;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.ConfigHandler;
import WayofTime.bloodmagic.annot.Handler;
import WayofTime.bloodmagic.api.Constants;
import WayofTime.bloodmagic.api.registry.RitualRegistry;
import WayofTime.bloodmagic.api.ritual.AreaDescriptor;
import WayofTime.bloodmagic.api.ritual.Ritual;
import WayofTime.bloodmagic.api.ritual.RitualComponent;
import WayofTime.bloodmagic.client.hud.HUDElement;
import WayofTime.bloodmagic.client.key.KeyBindings;
import WayofTime.bloodmagic.client.render.RenderFakeBlocks;
import WayofTime.bloodmagic.item.ItemRitualDiviner;
import WayofTime.bloodmagic.item.ItemRitualReader;
import WayofTime.bloodmagic.item.sigil.ItemSigilHolding;
import WayofTime.bloodmagic.network.BloodMagicPacketHandler;
import WayofTime.bloodmagic.network.SigilHoldingPacketProcessor;
import WayofTime.bloodmagic.registry.ModPotions;
import WayofTime.bloodmagic.tile.TileMasterRitualStone;
import WayofTime.bloodmagic.util.GhostItemHelper;
import WayofTime.bloodmagic.util.helper.TextHelper;
import com.google.common.base.Stopwatch;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Handler
@SideOnly(value=Side.CLIENT)
public class ClientHandler {
    public static final boolean SUPPRESS_ASSET_ERRORS = true;
    public static TextureAtlasSprite ritualStoneBlank;
    public static TextureAtlasSprite ritualStoneWater;
    public static TextureAtlasSprite ritualStoneFire;
    public static TextureAtlasSprite ritualStoneEarth;
    public static TextureAtlasSprite ritualStoneAir;
    public static TextureAtlasSprite ritualStoneDawn;
    public static TextureAtlasSprite ritualStoneDusk;
    public static TextureAtlasSprite blankBloodRune;
    public static TextureAtlasSprite stoneBrick;
    public static TextureAtlasSprite glowstone;
    public static TextureAtlasSprite bloodStoneBrick;
    public static TextureAtlasSprite beacon;
    public static TextureAtlasSprite crystalCluster;
    public static Minecraft minecraft;
    public static final List<HUDElement> hudElements;
    private static TileMasterRitualStone mrsHoloTile;
    private static Ritual mrsHoloRitual;
    private static EnumFacing mrsHoloDirection;
    private static boolean mrsHoloDisplay;
    boolean doCrystalRenderTest = true;
    public static ResourceLocation crystalResource;

    @SubscribeEvent
    public void onTooltipEvent(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack == null) {
            return;
        }
        if (GhostItemHelper.hasGhostAmount(stack)) {
            int amount = GhostItemHelper.getItemGhostAmount(stack);
            if (amount == 0) {
                event.getToolTip().add(TextHelper.localize("tooltip.BloodMagic.ghost.everything", new Object[0]));
            } else {
                event.getToolTip().add(TextHelper.localize("tooltip.BloodMagic.ghost.amount", amount));
            }
        }
    }

    @SubscribeEvent
    public void onSoundEvent(PlaySoundEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && player.func_70644_a(ModPotions.deafness)) {
            event.setResultSound(null);
        }
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        String BLOCKS = "blocks";
        ritualStoneBlank = ClientHandler.forName(event.getMap(), "RitualStone", "blocks");
        ritualStoneWater = ClientHandler.forName(event.getMap(), "WaterRitualStone", "blocks");
        ritualStoneFire = ClientHandler.forName(event.getMap(), "FireRitualStone", "blocks");
        ritualStoneEarth = ClientHandler.forName(event.getMap(), "EarthRitualStone", "blocks");
        ritualStoneAir = ClientHandler.forName(event.getMap(), "AirRitualStone", "blocks");
        ritualStoneDawn = ClientHandler.forName(event.getMap(), "LightRitualStone", "blocks");
        ritualStoneDusk = ClientHandler.forName(event.getMap(), "DuskRitualStone", "blocks");
        blankBloodRune = ClientHandler.forName(event.getMap(), "BlankRune", "blocks");
        stoneBrick = event.getMap().func_174942_a(new ResourceLocation("minecraft:blocks/stonebrick"));
        glowstone = event.getMap().func_174942_a(new ResourceLocation("minecraft:blocks/glowstone"));
        bloodStoneBrick = ClientHandler.forName(event.getMap(), "BloodStoneBrick", "blocks");
        beacon = event.getMap().func_174942_a(new ResourceLocation("minecraft:blocks/beacon"));
        crystalCluster = ClientHandler.forName(event.getMap(), "ShardCluster", "blocks");
    }

    @SubscribeEvent
    public void render(RenderWorldLastEvent event) {
        EntityPlayerSP player = ClientHandler.minecraft.field_71439_g;
        World world = player.field_70170_p;
        if (mrsHoloTile != null) {
            if (world.func_175625_s(mrsHoloTile.func_174877_v()) instanceof TileMasterRitualStone) {
                if (mrsHoloDisplay) {
                    ClientHandler.renderRitualStones(mrsHoloTile, event.getPartialTicks());
                } else {
                    ClientHandler.setRitualHoloToNull();
                }
            } else {
                ClientHandler.setRitualHoloToNull();
            }
        }
        if (ClientHandler.minecraft.field_71476_x == null || ClientHandler.minecraft.field_71476_x.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(ClientHandler.minecraft.field_71476_x.func_178782_a());
        if (tileEntity instanceof TileMasterRitualStone && player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() instanceof ItemRitualDiviner) {
            this.renderRitualStones(player, event.getPartialTicks());
        }
        if (tileEntity instanceof TileMasterRitualStone && player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() instanceof ItemRitualReader) {
            this.renderRitualInformation(player, event.getPartialTicks());
        }
    }

    @SubscribeEvent
    public void onMouseEvent(MouseEvent event) {
        Item item;
        ItemStack stack;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (event.getDwheel() != 0 && player != null && player.func_70093_af() && (stack = player.func_184614_ca()) != null && (item = stack.func_77973_b()) instanceof ItemSigilHolding) {
            ClientHandler.cycleSigil(stack, (EntityPlayer)player, event.getDwheel());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onKey(InputEvent event) {
        if (!ClientHandler.minecraft.field_71415_G) {
            return;
        }
        for (KeyBindings keyBinding : KeyBindings.values()) {
            if (!keyBinding.getKey().func_151468_f()) continue;
            keyBinding.handleKeybind();
        }
    }

    @SubscribeEvent
    public void onHudRender(RenderGameOverlayEvent.Pre event) {
        for (HUDElement element : hudElements) {
            if (element.getElementType() != event.getType() || !element.shouldRender(minecraft)) continue;
            element.render(minecraft, event.getResolution(), event.getPartialTicks());
        }
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        if (BloodMagic.isDev()) {
            return;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        Map modelErrors = (Map)ReflectionHelper.getPrivateValue(ModelLoader.class, (Object)event.getModelLoader(), (String[])new String[]{"loadingExceptions"});
        Set missingVariants = (Set)ReflectionHelper.getPrivateValue(ModelLoader.class, (Object)event.getModelLoader(), (String[])new String[]{"missingVariants"});
        ArrayList<ResourceLocation> errored = new ArrayList<ResourceLocation>();
        for (ResourceLocation modelError : modelErrors.keySet()) {
            if (!modelError.func_110624_b().equalsIgnoreCase("BloodMagic")) continue;
            errored.add(modelError);
        }
        ArrayList<ModelResourceLocation> missing = new ArrayList<ModelResourceLocation>();
        for (ModelResourceLocation missingVariant : missingVariants) {
            if (!missingVariant.func_110624_b().equalsIgnoreCase("BloodMagic")) continue;
            missing.add(missingVariant);
        }
        for (ResourceLocation modelError : errored) {
            modelErrors.remove(modelError);
        }
        missingVariants.removeAll(missing);
        if (errored.size() > 0) {
            BloodMagic.instance.getLogger().info("Suppressed {} model errors from Blood Magic.", errored.size());
        }
        if (missing.size() > 0) {
            BloodMagic.instance.getLogger().info("Suppressed {} variant errors from Blood Magic.", missing.size());
        }
        BloodMagic.instance.getLogger().debug("Suppressed discovered model/variant errors in {}", stopwatch.stop());
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Post event) {
        if (BloodMagic.isDev()) {
            return;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        SetMultimap missingTextures = (SetMultimap)ReflectionHelper.getPrivateValue(FMLClientHandler.class, (Object)FMLClientHandler.instance(), (String[])new String[]{"missingTextures"});
        Set badTextureDomains = (Set)ReflectionHelper.getPrivateValue(FMLClientHandler.class, (Object)FMLClientHandler.instance(), (String[])new String[]{"badTextureDomains"});
        String mc = "minecraft";
        String format = "textures/%s.png";
        HashSet<ResourceLocation> toRemove = new HashSet<ResourceLocation>();
        if (missingTextures.containsKey((Object)mc)) {
            Set missingMCTextures = missingTextures.get((Object)mc);
            for (ResourceLocation texture : missingMCTextures) {
                if (!texture.func_110623_a().equalsIgnoreCase(String.format(format, "node")) && !texture.func_110623_a().equalsIgnoreCase(String.format(format, "crystal"))) continue;
                toRemove.add(texture);
            }
        }
        missingTextures.get((Object)mc).removeAll(toRemove);
        if (missingTextures.get((Object)mc).isEmpty()) {
            missingTextures.keySet().remove(mc);
            badTextureDomains.remove(mc);
        }
        BloodMagic.instance.getLogger().debug("Suppressed required texture errors in {}", stopwatch.stop());
    }

    public static void cycleSigil(ItemStack stack, EntityPlayer player, int dWheel) {
        int mode = dWheel;
        if (!ConfigHandler.sigilHoldingSkipsEmptySlots) {
            mode = ItemSigilHolding.getCurrentItemOrdinal(stack);
            mode = dWheel < 0 ? ItemSigilHolding.next(mode) : ItemSigilHolding.prev(mode);
        }
        ItemSigilHolding.cycleToNextSigil(stack, mode);
        BloodMagicPacketHandler.INSTANCE.sendToServer((IMessage)new SigilHoldingPacketProcessor(player.field_71071_by.field_70461_c, mode));
    }

    private static TextureAtlasSprite forName(TextureMap textureMap, String name, String dir) {
        return textureMap.func_174942_a(new ResourceLocation(Constants.Mod.DOMAIN + dir + "/" + name));
    }

    private void renderRitualInformation(EntityPlayerSP player, float partialTicks) {
        World world = player.field_70170_p;
        TileMasterRitualStone mrs = (TileMasterRitualStone)world.func_175625_s(ClientHandler.minecraft.field_71476_x.func_178782_a());
        Ritual ritual = mrs.getCurrentRitual();
        if (ritual != null) {
            List<String> ranges = ritual.getListOfRanges();
            for (String range : ranges) {
                AreaDescriptor areaDescriptor = ritual.getBlockRange(range);
                for (BlockPos pos : areaDescriptor.getContainedPositions(ClientHandler.minecraft.field_71476_x.func_178782_a())) {
                    RenderFakeBlocks.drawFakeBlock(ritualStoneBlank, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), world);
                }
            }
        }
    }

    private void renderRitualStones(EntityPlayerSP player, float partialTicks) {
        World world = player.field_70170_p;
        ItemRitualDiviner ritualDiviner = (ItemRitualDiviner)player.field_71071_by.func_70448_g().func_77973_b();
        EnumFacing direction = ritualDiviner.getDirection(player.field_71071_by.func_70448_g());
        Ritual ritual = RitualRegistry.getRitualForId(ritualDiviner.getCurrentRitual(player.field_71071_by.func_70448_g()));
        if (ritual == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.6125f);
        BlockPos vec3 = ClientHandler.minecraft.field_71476_x.func_178782_a();
        double posX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double posY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double posZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        for (RitualComponent ritualComponent : ritual.getComponents()) {
            BlockPos vX = vec3.func_177971_a((Vec3i)ritualComponent.getOffset(direction));
            double minX = (double)vX.func_177958_n() - posX;
            double minY = (double)vX.func_177956_o() - posY;
            double minZ = (double)vX.func_177952_p() - posZ;
            if (world.func_180495_p(vX).func_185914_p()) continue;
            TextureAtlasSprite texture = null;
            switch (ritualComponent.getRuneType()) {
                case BLANK: {
                    texture = ritualStoneBlank;
                    break;
                }
                case WATER: {
                    texture = ritualStoneWater;
                    break;
                }
                case FIRE: {
                    texture = ritualStoneFire;
                    break;
                }
                case EARTH: {
                    texture = ritualStoneEarth;
                    break;
                }
                case AIR: {
                    texture = ritualStoneAir;
                    break;
                }
                case DAWN: {
                    texture = ritualStoneDawn;
                    break;
                }
                case DUSK: {
                    texture = ritualStoneDusk;
                }
            }
            RenderFakeBlocks.drawFakeBlock(texture, minX, minY, minZ, world);
        }
        GlStateManager.func_179121_F();
    }

    public static void renderRitualStones(TileMasterRitualStone masterRitualStone, float partialTicks) {
        EntityPlayerSP player = ClientHandler.minecraft.field_71439_g;
        World world = player.field_70170_p;
        EnumFacing direction = mrsHoloDirection;
        Ritual ritual = mrsHoloRitual;
        if (ritual == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        BlockPos vec3 = masterRitualStone.func_174877_v();
        double posX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double posY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double posZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        for (RitualComponent ritualComponent : ritual.getComponents()) {
            BlockPos vX = vec3.func_177971_a((Vec3i)ritualComponent.getOffset(direction));
            double minX = (double)vX.func_177958_n() - posX;
            double minY = (double)vX.func_177956_o() - posY;
            double minZ = (double)vX.func_177952_p() - posZ;
            if (world.func_180495_p(vX).func_185914_p()) continue;
            TextureAtlasSprite texture = null;
            switch (ritualComponent.getRuneType()) {
                case BLANK: {
                    texture = ritualStoneBlank;
                    break;
                }
                case WATER: {
                    texture = ritualStoneWater;
                    break;
                }
                case FIRE: {
                    texture = ritualStoneFire;
                    break;
                }
                case EARTH: {
                    texture = ritualStoneEarth;
                    break;
                }
                case AIR: {
                    texture = ritualStoneAir;
                    break;
                }
                case DAWN: {
                    texture = ritualStoneDawn;
                    break;
                }
                case DUSK: {
                    texture = ritualStoneDusk;
                }
            }
            RenderFakeBlocks.drawFakeBlock(texture, minX, minY, minZ, world);
        }
        GlStateManager.func_179121_F();
    }

    public static void setRitualHolo(TileMasterRitualStone masterRitualStone, Ritual ritual, EnumFacing direction, boolean displayed) {
        mrsHoloDisplay = displayed;
        mrsHoloTile = masterRitualStone;
        mrsHoloRitual = ritual;
        mrsHoloDirection = direction;
    }

    public static void setRitualHoloToNull() {
        mrsHoloDisplay = false;
        mrsHoloTile = null;
        mrsHoloRitual = null;
        mrsHoloDirection = EnumFacing.NORTH;
    }

    protected void renderHotbarItem(int x, int y, float partialTicks, EntityPlayer player, @Nullable ItemStack stack) {
        if (stack != null) {
            float animation = (float)stack.field_77992_b - partialTicks;
            if (animation > 0.0f) {
                GlStateManager.func_179094_E();
                float f1 = 1.0f + animation / 5.0f;
                GlStateManager.func_179109_b((float)(x + 8), (float)(y + 12), (float)0.0f);
                GlStateManager.func_179152_a((float)(1.0f / f1), (float)((f1 + 1.0f) / 2.0f), (float)1.0f);
                GlStateManager.func_179109_b((float)(-(x + 8)), (float)(-(y + 12)), (float)0.0f);
            }
            minecraft.func_175599_af().func_184391_a((EntityLivingBase)player, stack, x, y);
            if (animation > 0.0f) {
                GlStateManager.func_179121_F();
            }
            minecraft.func_175599_af().func_175030_a(ClientHandler.minecraft.field_71466_p, stack, x, y);
        }
    }

    static {
        minecraft = Minecraft.func_71410_x();
        hudElements = new ArrayList<HUDElement>();
        crystalResource = new ResourceLocation(Constants.Mod.DOMAIN + "textures/entities/defaultCrystalLayer.png");
    }
}

