/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.util.handler.event;

import WayofTime.bloodmagic.annot.Handler;
import WayofTime.bloodmagic.api.livingArmour.LivingArmourUpgrade;
import WayofTime.bloodmagic.item.armour.ItemLivingArmour;
import WayofTime.bloodmagic.livingArmour.LivingArmour;
import WayofTime.bloodmagic.livingArmour.downgrade.LivingArmourUpgradeCrippledArm;
import WayofTime.bloodmagic.livingArmour.tracker.StatTrackerArrowShot;
import WayofTime.bloodmagic.livingArmour.tracker.StatTrackerGrimReaperSprint;
import WayofTime.bloodmagic.livingArmour.tracker.StatTrackerJump;
import WayofTime.bloodmagic.livingArmour.upgrade.LivingArmourUpgradeArrowShot;
import WayofTime.bloodmagic.livingArmour.upgrade.LivingArmourUpgradeGrimReaperSprint;
import WayofTime.bloodmagic.livingArmour.upgrade.LivingArmourUpgradeJump;
import WayofTime.bloodmagic.livingArmour.upgrade.LivingArmourUpgradeSpeed;
import WayofTime.bloodmagic.livingArmour.upgrade.LivingArmourUpgradeStepAssist;
import WayofTime.bloodmagic.registry.ModPotions;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Handler
public class LivingArmourHandler {
    @SubscribeEvent
    public void onPlayerClick(PlayerInteractEvent event) {
        LivingArmourUpgrade upgrade;
        ItemStack chestStack;
        LivingArmour armour;
        EntityPlayer player;
        if (event.isCancelable() && event.getHand() == EnumHand.OFF_HAND && LivingArmour.hasFullSet(player = event.getEntityPlayer()) && (armour = ItemLivingArmour.getLivingArmour(chestStack = player.func_184582_a(EntityEquipmentSlot.CHEST))) != null && (upgrade = ItemLivingArmour.getUpgrade("BloodMagic.upgrade.crippledArm", chestStack)) instanceof LivingArmourUpgradeCrippledArm) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityDeath(LivingDeathEvent event) {
        ItemStack chestStack;
        LivingArmour armour;
        EntityPlayer player;
        if (event.getEntityLiving() instanceof EntityPlayer && LivingArmour.hasFullSet(player = (EntityPlayer)event.getEntityLiving()) && (armour = ItemLivingArmour.getLivingArmour(chestStack = player.func_184582_a(EntityEquipmentSlot.CHEST))) != null) {
            StatTrackerGrimReaperSprint.incrementCounter(armour);
            LivingArmourUpgrade upgrade = ItemLivingArmour.getUpgrade("BloodMagic.upgrade.grimReaper", chestStack);
            if (upgrade instanceof LivingArmourUpgradeGrimReaperSprint && ((LivingArmourUpgradeGrimReaperSprint)upgrade).canSavePlayer(player)) {
                ((LivingArmourUpgradeGrimReaperSprint)upgrade).applyEffectOnRebirth(player);
                event.setCanceled(true);
                event.setResult(Event.Result.DENY);
            }
            armour.writeDirtyToNBT(ItemLivingArmour.getArmourTag(chestStack));
        }
    }

    @SubscribeEvent
    public void onJumpEvent(LivingEvent.LivingJumpEvent event) {
        ItemStack chestStack;
        LivingArmour armour;
        EntityPlayer player;
        if (event.getEntityLiving() instanceof EntityPlayer && LivingArmour.hasFullSet(player = (EntityPlayer)event.getEntityLiving()) && (armour = ItemLivingArmour.getLivingArmour(chestStack = player.func_184582_a(EntityEquipmentSlot.CHEST))) != null) {
            LivingArmourUpgrade upgrade;
            StatTrackerJump.incrementCounter(armour);
            if (!player.func_70093_af() && (upgrade = ItemLivingArmour.getUpgradeFromNBT("BloodMagic.upgrade.jump", chestStack)) instanceof LivingArmourUpgradeJump) {
                player.field_70181_x += ((LivingArmourUpgradeJump)upgrade).getJumpModifier();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            LivingArmourUpgrade upgrade;
            ItemStack chestStack;
            LivingArmour armour;
            LivingArmourUpgrade upgrade2;
            ItemStack chestStack2;
            LivingArmour armour2;
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            boolean hasAssist = false;
            if (event.getEntityLiving().func_70644_a(ModPotions.boost)) {
                hasAssist = true;
                player.field_70138_W = 1.0031416f;
            } else if (LivingArmour.hasFullSet(player) && (armour2 = ItemLivingArmour.getLivingArmourFromStack(chestStack2 = player.func_184582_a(EntityEquipmentSlot.CHEST))) != null && (upgrade2 = ItemLivingArmour.getUpgrade("BloodMagic.upgrade.stepAssist", chestStack2)) instanceof LivingArmourUpgradeStepAssist) {
                player.field_70138_W = ((LivingArmourUpgradeStepAssist)upgrade2).getStepAssist();
                hasAssist = true;
            }
            if (!hasAssist && player.field_70138_W == 1.0031416f) {
                player.field_70138_W = 0.6f;
            }
            float percentIncrease = 0.0f;
            if (LivingArmour.hasFullSet(player) && (armour = ItemLivingArmour.getLivingArmourFromStack(chestStack = player.func_184582_a(EntityEquipmentSlot.CHEST))) != null && (upgrade = ItemLivingArmour.getUpgradeFromNBT("BloodMagic.upgrade.movement", chestStack)) instanceof LivingArmourUpgradeSpeed) {
                percentIncrease = (float)((double)percentIncrease + (double)0.1f * ((LivingArmourUpgradeSpeed)upgrade).getSpeedModifier());
            }
            if (event.getEntityLiving().func_70644_a(ModPotions.boost)) {
                int i = event.getEntityLiving().func_70660_b(ModPotions.boost).func_76458_c();
                percentIncrease += (float)(i + 1) * 0.05f;
            }
            if (percentIncrease > 0.0f && (player.field_70122_E || player.field_71075_bZ.field_75100_b) && player.field_70701_bs > 0.0f) {
                player.func_70060_a(0.0f, 1.0f, player.field_71075_bZ.field_75100_b ? percentIncrease / 2.0f : percentIncrease);
            }
        }
    }

    @SubscribeEvent
    public void onArrowFire(ArrowLooseEvent event) {
        ItemStack chestStack;
        LivingArmour armour;
        World world = event.getEntityPlayer().field_70170_p;
        ItemStack stack = event.getBow();
        EntityPlayer player = event.getEntityPlayer();
        if (world.field_72995_K) {
            return;
        }
        if (LivingArmour.hasFullSet(player) && (armour = ItemLivingArmour.getLivingArmour(chestStack = player.func_184582_a(EntityEquipmentSlot.CHEST))) != null) {
            StatTrackerArrowShot.incrementCounter(armour);
            LivingArmourUpgrade upgrade = ItemLivingArmour.getUpgrade("BloodMagic.upgrade.arrowShot", chestStack);
            if (upgrade instanceof LivingArmourUpgradeArrowShot) {
                int charge = event.getCharge();
                float velocity = (float)charge / 20.0f;
                if ((double)(velocity = (velocity * velocity + velocity * 2.0f) / 3.0f) < 0.1) {
                    return;
                }
                if (velocity > 1.0f) {
                    velocity = 1.0f;
                }
                int extraArrows = ((LivingArmourUpgradeArrowShot)upgrade).getExtraArrows();
                for (int n = 0; n < extraArrows; ++n) {
                    int punchLevel;
                    int powerLevel;
                    ItemStack arrowStack = new ItemStack(Items.field_151032_g);
                    ItemArrow itemarrow = (ItemArrow)(stack.func_77973_b() instanceof ItemArrow ? arrowStack.func_77973_b() : Items.field_151032_g);
                    EntityArrow entityarrow = itemarrow.func_185052_a(world, arrowStack, (EntityLivingBase)player);
                    entityarrow.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, velocity * 3.0f, 1.0f);
                    float velocityModifier = 0.6f * velocity;
                    entityarrow.field_70159_w += (event.getWorld().field_73012_v.nextDouble() - 0.5) * (double)velocityModifier;
                    entityarrow.field_70181_x += (event.getWorld().field_73012_v.nextDouble() - 0.5) * (double)velocityModifier;
                    entityarrow.field_70179_y += (event.getWorld().field_73012_v.nextDouble() - 0.5) * (double)velocityModifier;
                    if (velocity == 1.0f) {
                        entityarrow.func_70243_d(true);
                    }
                    if ((powerLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack)) > 0) {
                        entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)powerLevel * 0.5 + 0.5);
                    }
                    if ((punchLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
                        entityarrow.func_70240_a(punchLevel);
                    }
                    if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                        entityarrow.func_70015_d(100);
                    }
                    entityarrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                    world.func_72838_d((Entity)entityarrow);
                }
            }
        }
    }
}

