/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.util.handler.event;

import WayofTime.bloodmagic.annot.Handler;
import WayofTime.bloodmagic.api.livingArmour.LivingArmourUpgrade;
import WayofTime.bloodmagic.item.armour.ItemLivingArmour;
import WayofTime.bloodmagic.item.armour.ItemSentientArmour;
import WayofTime.bloodmagic.livingArmour.LivingArmour;
import WayofTime.bloodmagic.livingArmour.tracker.StatTrackerArrowProtect;
import WayofTime.bloodmagic.livingArmour.tracker.StatTrackerCriticalStrike;
import WayofTime.bloodmagic.livingArmour.tracker.StatTrackerDigging;
import WayofTime.bloodmagic.livingArmour.tracker.StatTrackerExperience;
import WayofTime.bloodmagic.livingArmour.tracker.StatTrackerFallProtect;
import WayofTime.bloodmagic.livingArmour.tracker.StatTrackerGraveDigger;
import WayofTime.bloodmagic.livingArmour.tracker.StatTrackerHealthboost;
import WayofTime.bloodmagic.livingArmour.tracker.StatTrackerMeleeDamage;
import WayofTime.bloodmagic.livingArmour.tracker.StatTrackerNightSight;
import WayofTime.bloodmagic.livingArmour.tracker.StatTrackerPhysicalProtect;
import WayofTime.bloodmagic.livingArmour.tracker.StatTrackerSolarPowered;
import WayofTime.bloodmagic.livingArmour.tracker.StatTrackerSprintAttack;
import WayofTime.bloodmagic.livingArmour.upgrade.LivingArmourUpgradeDigging;
import WayofTime.bloodmagic.livingArmour.upgrade.LivingArmourUpgradeExperience;
import WayofTime.bloodmagic.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Handler
public class StatTrackerHandler {
    private static float lastPlayerSwingStrength = 0.0f;

    @SubscribeEvent
    public void blockBreakEvent(BlockEvent.BreakEvent event) {
        LivingArmour armour;
        ItemStack chestStack;
        EntityPlayer player = event.getPlayer();
        if (player != null && LivingArmour.hasFullSet(player) && (chestStack = player.func_184582_a(EntityEquipmentSlot.CHEST)) != null && chestStack.func_77973_b() instanceof ItemLivingArmour && (armour = ItemLivingArmour.getLivingArmour(chestStack)) != null) {
            StatTrackerDigging.incrementCounter(armour);
            LivingArmourUpgradeDigging.hasDug(armour);
        }
    }

    @SubscribeEvent
    public void onEntityHealed(LivingHealEvent event) {
        ItemStack chestStack;
        LivingArmour armour;
        EntityLivingBase healedEntity = event.getEntityLiving();
        if (!(healedEntity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)healedEntity;
        if (LivingArmour.hasFullSet(player) && (armour = ItemLivingArmour.getLivingArmour(chestStack = player.func_184582_a(EntityEquipmentSlot.CHEST))) != null) {
            StatTrackerHealthboost.incrementCounter(armour, event.getAmount());
            if (player.field_70170_p.func_175678_i(player.func_180425_c()) && player.field_70170_p.field_73011_w.isDaytime()) {
                StatTrackerSolarPowered.incrementCounter(armour, event.getAmount());
            }
        }
    }

    @SubscribeEvent
    public void onLivingAttack(AttackEntityEvent event) {
        lastPlayerSwingStrength = event.getEntityPlayer().func_184825_o(0.0f);
    }

    @SubscribeEvent
    public void entityHurt(LivingHurtEvent event) {
        ItemStack chestStack;
        EntityPlayer player;
        Object armour;
        DamageSource source = event.getSource();
        Entity sourceEntity = event.getSource().func_76346_g();
        EntityLivingBase attackedEntity = event.getEntityLiving();
        if (attackedEntity instanceof EntityPlayer) {
            EntityPlayer attackedPlayer = (EntityPlayer)attackedEntity;
            if (LivingArmour.hasFullSet(attackedPlayer)) {
                float amount = Math.min(Utils.getModifiedDamage((EntityLivingBase)attackedPlayer, event.getSource(), event.getAmount()), attackedPlayer.func_110143_aJ());
                ItemStack chestStack2 = attackedPlayer.func_184582_a(EntityEquipmentSlot.CHEST);
                LivingArmour armour2 = ItemLivingArmour.getLivingArmour(chestStack2);
                if (armour2 != null) {
                    if (sourceEntity != null && !source.func_82725_o() && !source.func_76352_a()) {
                        StatTrackerPhysicalProtect.incrementCounter(armour2, amount);
                    }
                    if (source.equals(DamageSource.field_76379_h)) {
                        StatTrackerFallProtect.incrementCounter(armour2, amount);
                    }
                    if (source.func_76352_a()) {
                        StatTrackerArrowProtect.incrementCounter(armour2, amount);
                    }
                }
            } else {
                ItemStack chestStack3 = attackedPlayer.func_184582_a(EntityEquipmentSlot.CHEST);
                if (chestStack3 != null && chestStack3.func_77973_b() instanceof ItemSentientArmour) {
                    armour = (ItemSentientArmour)chestStack3.func_77973_b();
                    ((ItemSentientArmour)armour).onPlayerAttacked(chestStack3, source, attackedPlayer);
                }
            }
        }
        if (sourceEntity instanceof EntityPlayer && LivingArmour.hasFullSet(player = (EntityPlayer)sourceEntity) && (armour = ItemLivingArmour.getLivingArmour(chestStack = player.func_184582_a(EntityEquipmentSlot.CHEST))) != null) {
            ItemStack mainWeapon = player.func_184582_a(EntityEquipmentSlot.MAINHAND);
            event.setAmount((float)((double)event.getAmount() + (double)lastPlayerSwingStrength * ((LivingArmour)armour).getAdditionalDamageOnHit(event.getAmount(), player, attackedEntity, mainWeapon)));
            float amount = Math.min(Utils.getModifiedDamage(attackedEntity, event.getSource(), event.getAmount()), attackedEntity.func_110143_aJ());
            if (!source.func_76352_a()) {
                double kb;
                boolean isCritical;
                StatTrackerMeleeDamage.incrementCounter((LivingArmour)armour, amount);
                if (player.field_70170_p.func_175699_k(player.func_180425_c()) <= 9) {
                    StatTrackerNightSight.incrementCounter((LivingArmour)armour, amount);
                }
                if (mainWeapon != null && mainWeapon.func_77973_b() instanceof ItemSpade) {
                    StatTrackerGraveDigger.incrementCounter((LivingArmour)armour, amount);
                }
                if (player.func_70051_ag()) {
                    StatTrackerSprintAttack.incrementCounter((LivingArmour)armour, amount);
                }
                boolean bl = isCritical = (double)lastPlayerSwingStrength > 0.9 && player.field_70143_R > 0.0f && !player.field_70122_E && !player.func_70617_f_() && !player.func_70090_H() && !player.func_70644_a(MobEffects.field_76440_q) && !player.func_184218_aH() && !player.func_70051_ag();
                if (isCritical) {
                    StatTrackerCriticalStrike.incrementCounter((LivingArmour)armour, amount);
                }
                if ((kb = ((LivingArmour)armour).getKnockbackOnHit(player, attackedEntity, mainWeapon)) > 0.0) {
                    attackedEntity.func_70653_a((Entity)player, (float)kb * 0.5f, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onExperiencePickup(PlayerPickupXpEvent event) {
        ItemStack chestStack;
        LivingArmour armour;
        EntityPlayer player = event.getEntityPlayer();
        if (LivingArmour.hasFullSet(player) && (armour = ItemLivingArmour.getLivingArmour(chestStack = player.func_184582_a(EntityEquipmentSlot.CHEST))) != null) {
            LivingArmourUpgrade upgrade = ItemLivingArmour.getUpgrade("BloodMagic.upgrade.experienced", chestStack);
            if (upgrade instanceof LivingArmourUpgradeExperience) {
                double modifier = ((LivingArmourUpgradeExperience)upgrade).getExperienceModifier();
                double exp = (double)event.getOrb().field_70530_e * (1.0 + modifier);
                event.getOrb().field_70530_e = (int)Math.floor(exp) + (Math.random() < exp % 1.0 ? 1 : 0);
            }
            StatTrackerExperience.incrementCounter(armour, event.getOrb().field_70530_e);
        }
    }
}

