/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.audio.tape;

import java.io.IOException;
import java.util.Arrays;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import mcmultipart.multipart.IMultipart;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.translation.I18n;
import org.lwjgl.opengl.Display;
import pl.asie.charset.audio.ModCharsetAudio;
import pl.asie.charset.audio.tape.ItemTape;
import pl.asie.charset.audio.tape.PacketDriveCounter;
import pl.asie.charset.audio.tape.PacketDriveState;
import pl.asie.charset.audio.tape.PartTapeDrive;
import pl.asie.charset.audio.tape.State;
import pl.asie.charset.audio.tape.TapeRecordThread;
import pl.asie.charset.lib.container.GuiContainerCharset;

public class GuiTapeDrive
extends GuiContainerCharset {
    private static final ResourceLocation TEXTURE = new ResourceLocation("charsetaudio:textures/gui/tape_drive.png");
    private static final int BUTTON_START_X = 88 - Button.values().length * 10;
    private static final int BUTTON_START_Y = 58;
    private State state = State.STOPPED;
    private PartTapeDrive tapeDrive;
    private int counter;
    private Button buttonHovering = null;
    private boolean ctrResetHover = false;
    private DialogThread tapeDialog;
    private TapeRecordThread tapeRecord;
    private Thread tapeRecordThread;
    private Thread tapeDialogThread;

    public boolean isRecordingFromFile(boolean inProgress) {
        if (!inProgress && this.tapeDialogThread != null && this.tapeDialogThread.isAlive()) {
            return true;
        }
        return this.tapeRecordThread != null && this.tapeRecordThread.isAlive();
    }

    public GuiTapeDrive(Container container, PartTapeDrive tapeDrive) {
        super(container, 176, 166);
        this.tapeDrive = tapeDrive;
    }

    public boolean isButtonPressed(Button button) {
        if (button == this.buttonHovering) {
            return true;
        }
        if (this.isRecordingFromFile(false) && button == Button.RECORD_FILE) {
            return true;
        }
        switch (this.state) {
            case FORWARDING: {
                return button == Button.FAST_FORWARD;
            }
            case PLAYING: {
                return button == Button.PLAY;
            }
            case REWINDING: {
                return button == Button.REWIND;
            }
            case RECORDING: {
                return button == Button.RECORD_AUDIO;
            }
        }
        return false;
    }

    public void setState(State state) {
        if (this.tapeDrive != null) {
            try {
                PacketDriveState packet = new PacketDriveState((IMultipart)this.tapeDrive, state);
                ModCharsetAudio.packet.sendToServer(packet);
                this.tapeDrive.setState(state);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void handleButtonPress(Button button) {
        if (this.isRecordingFromFile(false)) {
            return;
        }
        switch (button) {
            case REWIND: {
                if (this.state == State.REWINDING) {
                    this.setState(State.STOPPED);
                    break;
                }
                this.setState(State.REWINDING);
                break;
            }
            case PLAY: {
                this.setState(State.PLAYING);
                break;
            }
            case FAST_FORWARD: {
                if (this.state == State.FORWARDING) {
                    this.setState(State.STOPPED);
                    break;
                }
                this.setState(State.FORWARDING);
                break;
            }
            case STOP: {
                this.setState(State.STOPPED);
                break;
            }
            case RECORD_FILE: {
                if (this.tapeDrive.inventory.func_70301_a(0) == null) break;
                this.setState(State.STOPPED);
                if (Minecraft.func_71410_x().func_71372_G()) {
                    Minecraft.func_71410_x().func_71352_k();
                }
                this.tapeDialog = new DialogThread();
                this.tapeDialogThread = new Thread(this.tapeDialog);
                this.tapeDialogThread.start();
                break;
            }
            case RECORD_AUDIO: {
                this.setState(State.RECORDING);
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.state = this.tapeDrive.getState();
        this.counter = this.tapeDrive.state.counter;
        if (this.tapeDialogThread != null && !this.tapeDialogThread.isAlive()) {
            if (this.tapeDialog.result == 0 && this.tapeDialog.chooser.getSelectedFile() != null) {
                this.tapeRecord = new TapeRecordThread(this.tapeDialog.chooser.getSelectedFile(), this.tapeDrive);
                this.tapeRecordThread = new Thread(this.tapeRecord);
                this.tapeRecordThread.start();
            }
            this.tapeDialogThread = null;
            this.tapeDialog = null;
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.isRecordingFromFile(false) && (keyCode == 1 || keyCode == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i())) {
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    public void func_73864_a(int x, int y, int mb) throws IOException {
        if (this.isRecordingFromFile(false)) {
            return;
        }
        super.func_73864_a(x, y, mb);
        if (mb == 0) {
            for (Button button : Button.values()) {
                int button_x = this.xCenter + BUTTON_START_X + button.ordinal() * 20;
                int button_y = this.yCenter + 58;
                if (x < button_x || x >= button_x + 20 || y < button_y || y >= button_y + 15 || this.isButtonPressed(button)) continue;
                this.buttonHovering = button;
                return;
            }
            int reset_x = this.xCenter + 122;
            int reset_y = this.yCenter + 39;
            if (x >= reset_x && x <= reset_x + 5 && y >= reset_y && y <= reset_y + 6) {
                this.ctrResetHover = true;
                return;
            }
        }
    }

    public void func_146286_b(int x, int y, int which) {
        if (this.isRecordingFromFile(false)) {
            return;
        }
        super.func_146286_b(x, y, which);
        if (which >= 0 && this.buttonHovering != null) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)new SoundEvent(new ResourceLocation("gui.button.press")), (float)1.0f));
            this.handleButtonPress(this.buttonHovering);
            this.buttonHovering = null;
        }
        if (which >= 0 && this.ctrResetHover) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)new SoundEvent(new ResourceLocation("gui.button.press")), (float)1.0f));
            ModCharsetAudio.packet.sendToServer(new PacketDriveCounter((IMultipart)this.tapeDrive, 0));
            this.ctrResetHover = false;
        }
    }

    private String getLabel() {
        ItemStack stack = (ItemStack)this.field_147002_h.func_75138_a().get(0);
        if (stack != null && stack.func_77973_b() instanceof ItemTape) {
            String label = I18n.func_74838_a((String)"tooltip.charset.tape.unnamed");
            if (stack.func_82837_s()) {
                label = stack.func_82833_r();
            }
            return label;
        }
        return null;
    }

    public void drawTexturedModalRectFloatY(int x, int y, int textureX, float textureY, int width, int height) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)(x + 0), (double)(y + height), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + 0) * f), (double)((textureY + (float)height) * f1)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + width) * f), (double)((textureY + (float)height) * f1)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + 0), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + width) * f), (double)((textureY + 0.0f) * f1)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + 0), (double)(y + 0), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + 0) * f), (double)((textureY + 0.0f) * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    @Override
    protected void func_146976_a(float f, int i, int j) {
        float counterReal;
        super.func_146976_a(f, i, j);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(this.xCenter, this.yCenter, 0, 0, this.field_146999_f, this.field_147000_g);
        for (Button button : Button.values()) {
            int button_ty = 166 + button.ordinal() * 15;
            int button_tx = this.isButtonPressed(button) ? 20 : 0;
            int button_x = BUTTON_START_X + button.ordinal() * 20;
            this.func_73729_b(this.xCenter + button_x, this.yCenter + 58, button_tx, button_ty, 20, 15);
        }
        if (this.ctrResetHover) {
            this.func_73729_b(this.xCenter + 121, this.yCenter + 39, 121, 38, 6, 6);
        }
        if ((counterReal = (float)this.counter / 48000.0f) < 0.0f) {
            counterReal = counterReal % 1000.0f + 1000.0f;
        }
        float[] counterPos = new float[]{counterReal / 100.0f % 10.0f, counterReal / 10.0f % 10.0f, counterReal % 10.0f};
        counterPos[1] = counterPos[2] < 9.0f ? (float)Math.floor(counterPos[1]) : (float)Math.floor(counterPos[1]) + counterReal % 1.0f;
        counterPos[0] = counterReal % 100.0f < 99.0f ? (float)Math.floor(counterPos[0]) : (float)Math.floor(counterPos[0]) + counterReal % 1.0f;
        for (int c = 0; c < 3; ++c) {
            float cpy = counterPos[c] * 10.0f;
            if (cpy < 0.0f) {
                cpy += 100.0f;
            }
            this.drawTexturedModalRectFloatY(this.xCenter + 98 + c * 7, this.yCenter + 38, 248, cpy, 8, 9);
        }
        GlStateManager.func_179147_l();
        this.func_73729_b(this.xCenter + 98, this.yCenter + 34, 98, 34, 22, 16);
        GlStateManager.func_179084_k();
        String label = this.getLabel();
        int labelColor = 0xFFFFFF;
        if (this.isRecordingFromFile(true)) {
            label = this.tapeRecord.getStatusBar();
            labelColor = 9494704;
        } else {
            int width;
            if (label == null) {
                label = I18n.func_74838_a((String)"tooltip.charset.tape.none");
                labelColor = 0xFF3333;
            }
            if ((width = this.field_146289_q.func_78256_a(label)) > 142) {
                while (width > 136 && label.length() > 4) {
                    label = label.substring(0, label.length() - 1);
                    width = this.field_146289_q.func_78256_a(label);
                }
                label = label + "...";
            }
        }
        this.func_73732_a(this.field_146289_q, label, this.xCenter + 88, this.yCenter + 15, labelColor);
    }

    public static enum Button {
        REWIND,
        PLAY,
        STOP,
        FAST_FORWARD,
        RECORD_FILE,
        RECORD_AUDIO;

    }

    public class DialogThread
    implements Runnable {
        public JFileChooser chooser = new JFileChooser();
        public int result;

        @Override
        public void run() {
            this.chooser.setFileSelectionMode(0);
            this.chooser.setDialogType(0);
            this.chooser.setFileFilter(new FileNameExtensionFilter("Audio file " + Arrays.toString(TapeRecordThread.getSupportedExtensions()), TapeRecordThread.getSupportedExtensions()));
            this.result = this.chooser.showOpenDialog(Display.getParent());
        }
    }
}

