/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.decoration.poster;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.decoration.ModCharsetDecoration;
import pl.asie.charset.lib.factorization.Quaternion;
import pl.asie.charset.lib.factorization.SpaceUtil;
import pl.asie.charset.lib.utils.DataSerializersCharset;
import pl.asie.charset.lib.utils.DirectionUtils;
import pl.asie.charset.lib.utils.ItemUtils;
import pl.asie.charset.lib.utils.PlayerUtils;

public class EntityPoster
extends Entity {
    private static final DataParameter<NBTTagCompound> PARAMETER_TAG = EntityDataManager.func_187226_a(EntityPoster.class, DataSerializersCharset.NBT_TAG_COMPOUND);
    public ItemStack inv = new ItemStack(ModCharsetDecoration.posterItem);
    public Quaternion rot = new Quaternion();
    public double scale = 1.0;
    public boolean locked = false;
    Quaternion base_rotation = new Quaternion();
    double base_scale = 1.0;
    public short spin_normal = 0;
    public short spin_vertical = 0;
    public short spin_tilt = 0;
    byte delta_scale = 0;
    EnumFacing norm = EnumFacing.NORTH;
    EnumFacing top = EnumFacing.UP;
    EnumFacing tilt = EnumFacing.EAST;
    private boolean initialized = false;
    private static final double SCALE_INCR = 1.125;
    private static final double SPIN_PER_CLICK = 0.19634954084936207;

    public EntityPoster(World w) {
        super(w);
        this.func_70105_a(0.5f, 0.5f);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.inv = ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("inv"));
        if (this.inv == null) {
            this.inv = new ItemStack(ModCharsetDecoration.posterItem);
        }
        this.rot = Quaternion.loadFromTag(compound, "rot");
        this.scale = compound.func_74769_h("scale");
        this.base_rotation = Quaternion.loadFromTag(compound, "base_rot");
        this.base_scale = compound.func_74769_h("base_scale");
        this.spin_normal = compound.func_74765_d("spin_normal");
        this.spin_vertical = compound.func_74765_d("spin_vertical");
        this.spin_tilt = compound.func_74765_d("spin_tilt");
        this.delta_scale = compound.func_74771_c("delta_scale");
        this.locked = compound.func_74767_n("locked");
        this.norm = DirectionUtils.get(compound.func_74771_c("norm"));
        this.top = DirectionUtils.get(compound.func_74771_c("top"));
        this.tilt = DirectionUtils.get(compound.func_74771_c("tilt"));
        this.updateSize();
        if (!this.field_70170_p.field_72995_K) {
            this.syncData();
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        ItemUtils.writeToNBT(this.inv, compound, "inv");
        this.rot.writeToTag(compound, "rot");
        compound.func_74780_a("scale", this.scale);
        this.base_rotation.writeToTag(compound, "base_rot");
        compound.func_74780_a("base_scale", this.base_scale);
        compound.func_74777_a("spin_normal", this.spin_normal);
        compound.func_74777_a("spin_tilt", this.spin_tilt);
        compound.func_74777_a("spin_vertical", this.spin_vertical);
        compound.func_74774_a("delta_scale", this.delta_scale);
        compound.func_74757_a("locked", this.locked);
        compound.func_74774_a("norm", (byte)DirectionUtils.ordinal(this.norm));
        compound.func_74774_a("top", (byte)DirectionUtils.ordinal(this.top));
        compound.func_74774_a("tilt", (byte)DirectionUtils.ordinal(this.tilt));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70180_af.func_187223_a()) {
            this.func_70037_a((NBTTagCompound)this.field_70180_af.func_187225_a(PARAMETER_TAG));
        }
    }

    void updateSize() {
        Vec3d here = SpaceUtil.fromEntPos(this);
        Vec3d[] parts = new Vec3d[6];
        EnumFacing[] values = EnumFacing.field_82609_l;
        for (int i = 0; i < values.length; ++i) {
            EnumFacing dir = values[i];
            if (dir == this.norm.func_176734_d()) continue;
            float s = (float)this.scale;
            s = dir == this.norm ? (s /= 16.0f) : (s /= 2.0f);
            parts[i] = SpaceUtil.scale(SpaceUtil.fromDirection(dir), s).func_178787_e(here);
        }
        this.func_174826_a(SpaceUtil.newBox(parts));
    }

    public void setItem(ItemStack item) {
        if (item == null) {
            item = new ItemStack(ModCharsetDecoration.posterItem);
        }
        this.inv = item;
    }

    public ItemStack getItem() {
        if (this.inv != null && this.inv.func_77973_b() == ModCharsetDecoration.posterItem) {
            return null;
        }
        return this.inv;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean func_145770_h(double p_145770_1_, double p_145770_3_, double p_145770_5_) {
        return super.func_145770_h(p_145770_1_, p_145770_3_, p_145770_5_);
    }

    public void setBase(double baseScale, Quaternion baseRotation, EnumFacing norm, EnumFacing top, AxisAlignedBB bounds) {
        this.scale = this.base_scale = baseScale;
        this.base_rotation = baseRotation;
        this.rot = new Quaternion(this.base_rotation);
        this.spin_normal = 0;
        this.spin_vertical = 0;
        this.delta_scale = 0;
        this.norm = norm;
        this.top = top;
        Vec3d tiltV = SpaceUtil.fromDirection(norm).func_72431_c(SpaceUtil.fromDirection(top));
        this.tilt = SpaceUtil.round(tiltV, norm);
        this.updateSize();
        this.func_174826_a(bounds);
    }

    public void updateValues() {
        this.delta_scale = (byte)Math.min(Math.max(this.delta_scale, -8), 6);
        this.scale = this.base_scale * Math.pow(1.125, this.delta_scale);
        Quaternion rNorm = Quaternion.getRotationQuaternionRadians((double)this.spin_normal * 0.19634954084936207, this.norm);
        Quaternion rVert = Quaternion.getRotationQuaternionRadians((double)this.spin_vertical * 0.19634954084936207, this.top);
        Quaternion rTilt = Quaternion.getRotationQuaternionRadians((double)this.spin_tilt * 0.19634954084936207, this.tilt);
        this.rot = rVert.multiply(rNorm).multiply(rTilt).multiply(this.base_rotation);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70067_L() {
        if (!this.field_70170_p.field_72995_K) {
            return false;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return false;
        }
        if (this.locked && !PlayerUtils.isCreative((EntityPlayer)player)) {
            return false;
        }
        if (player.func_70093_af()) {
            return true;
        }
        if (this.inv.func_77973_b() == ModCharsetDecoration.posterItem) {
            return true;
        }
        ItemStack held = player.func_184586_b(EnumHand.MAIN_HAND);
        if (held == null) {
            return false;
        }
        Item it = held.func_77973_b();
        return it == ModCharsetDecoration.posterItem || ItemUtils.equalsMeta(this.inv, held);
    }

    public boolean func_85031_j(Entity ent) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (!(ent instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)ent;
        if (this.locked && !PlayerUtils.isCreative(player)) {
            return false;
        }
        if (this.spin_normal != 0 || this.spin_vertical != 0 || this.spin_tilt != 0) {
            this.spin_tilt = 0;
            this.spin_vertical = 0;
            this.spin_normal = 0;
        } else if (this.delta_scale != 0) {
            this.delta_scale = 0;
        } else {
            ItemStack droppedItem = this.inv;
            this.inv = new ItemStack(ModCharsetDecoration.posterItem);
            if (droppedItem.func_77973_b() == ModCharsetDecoration.posterItem) {
                this.func_70106_y();
            } else {
                this.syncData();
            }
            if (player.field_71075_bZ.field_75098_d) {
                return false;
            }
            EntityItem newItem = ItemUtils.spawnItemEntity(this.func_130014_f_(), this.func_174791_d(), droppedItem, 0.0f, 0.0f, 0.0f, 0.0f);
            if (newItem instanceof EntityItem) {
                EntityItem ei = newItem;
                ei.func_174868_q();
            }
            newItem.func_70100_b_(player);
            return true;
        }
        this.updateValues();
        this.syncData();
        return true;
    }

    public void syncData() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_70014_b(compound);
        this.field_70180_af.func_187227_b(PARAMETER_TAG, (Object)compound);
    }

    protected void func_70088_a() {
        NBTTagCompound compound = new NBTTagCompound();
        this.field_70180_af.func_187214_a(PARAMETER_TAG, (Object)compound);
    }

    public boolean func_184230_a(EntityPlayer player, @Nullable ItemStack stack, EnumHand hand) {
        int d;
        if (this.locked) {
            return false;
        }
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        ItemStack held = player.func_184586_b(hand);
        if (held == null) {
            return false;
        }
        if (this.inv.func_77973_b() == ModCharsetDecoration.posterItem) {
            if (held.func_77973_b() == ModCharsetDecoration.posterItem) {
                return true;
            }
            this.inv = held.func_77979_a(1);
            this.syncData();
            return true;
        }
        int n = d = player.func_70093_af() ? -1 : 1;
        if (ItemUtils.equalsMeta(this.inv, held)) {
            this.delta_scale = (byte)(this.delta_scale + d);
            this.updateValues();
            this.syncData();
            return true;
        }
        boolean hasPoster = held.func_77973_b() == ModCharsetDecoration.posterItem;
        boolean hasLmp = false;
        if (hasPoster) {
            EnumFacing clickDir = SpaceUtil.determineOrientation((EntityLivingBase)player);
            if (hasPoster) {
                if (clickDir == this.norm || clickDir == this.norm.func_176734_d()) {
                    this.spin_normal = (short)(this.spin_normal - d);
                } else {
                    this.spin_vertical = (short)(this.spin_vertical + d);
                }
            } else if (clickDir == this.norm || clickDir == this.norm.func_176734_d()) {
                this.spin_tilt = (short)(this.spin_tilt + d);
            } else {
                this.spin_vertical = (short)(this.spin_vertical + d);
            }
            this.updateValues();
            this.syncData();
            return true;
        }
        return super.func_184230_a(player, stack, hand);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return this.inv.func_77946_l();
    }

    public int func_70070_b(float partial) {
        EnumFacing front = this.norm;
        double dx = 0.0;
        double dy = 0.0;
        double dz = 0.0;
        if (front == EnumFacing.DOWN) {
            dy -= 1.0;
        } else if (front == EnumFacing.NORTH) {
            dz -= 1.0;
        } else if (front == EnumFacing.WEST) {
            dx = -1.0;
        }
        int x = MathHelper.func_76128_c((double)(this.field_70165_t + dx));
        int y = MathHelper.func_76128_c((double)(this.field_70163_u + dy));
        int z = MathHelper.func_76128_c((double)(this.field_70161_v + dz));
        BlockPos blockpos = new BlockPos(x, y, z);
        return this.field_70170_p.func_175626_b(blockpos, 0);
    }

    public boolean func_70112_a(double dist) {
        return dist < 1024.0;
    }
}

