/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.farming;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.farming.ModCharsetFarming;
import pl.asie.charset.lib.ModCharsetLib;
import pl.asie.charset.lib.utils.ItemUtils;
import pl.asie.charset.lib.utils.RayTraceUtils;

public class UniversalClayBucket
extends UniversalBucket {
    public UniversalClayBucket() {
        super(1000, null, false);
        this.func_77637_a(ModCharsetLib.CREATIVE_TAB);
        this.func_77655_b("charset.clayBucket");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        subItems.add(this.getEmpty());
        super.func_150895_a(itemIn, tab, subItems);
    }

    public ItemStack getEmpty() {
        return new ItemStack((Item)ModCharsetFarming.clayBucket);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemstack, World world, EntityPlayer player, EnumHand hand) {
        IBlockState state;
        FillBucketEvent fakeEvent;
        if (ItemStack.func_77989_b((ItemStack)itemstack, (ItemStack)this.getEmpty()) && (fakeEvent = new FillBucketEvent(player, itemstack, world, world.func_72901_a(RayTraceUtils.getStart((EntityLivingBase)player), RayTraceUtils.getEnd((EntityLivingBase)player), true))).getTarget() != null && fakeEvent.getTarget().field_72313_a == RayTraceResult.Type.BLOCK && (state = world.func_180495_p(fakeEvent.getTarget().func_178782_a())).func_177230_c() != Blocks.field_150355_j && state.func_177230_c() != Blocks.field_150353_l) {
            this.onFillBucket(fakeEvent);
            if (!fakeEvent.isCanceled() && fakeEvent.getResult() != Event.Result.DENY && fakeEvent.getFilledBucket() != null) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)fakeEvent.getFilledBucket());
            }
        }
        return super.func_77659_a(itemstack, world, player, hand);
    }

    public String func_77653_i(ItemStack stack) {
        FluidStack fluidStack = this.getFluid(stack);
        if (fluidStack == null) {
            return I18n.func_74838_a((String)(this.func_77658_a() + ".empty.name"));
        }
        String prefix = this.func_77658_a() + ".filled";
        if (I18n.func_94522_b((String)(prefix + "." + fluidStack.getFluid().getName()))) {
            return I18n.func_74838_a((String)(prefix + "." + fluidStack.getFluid().getName()));
        }
        return I18n.func_74837_a((String)(prefix + ".name"), (Object[])new Object[]{fluidStack.getLocalizedName()});
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (container.field_77994_a != 1) {
            return 0;
        }
        if (resource == null || resource.amount != this.getCapacity() || resource.getFluid().getTemperature(resource) > 400 || resource.getFluid().isGaseous(resource)) {
            return 0;
        }
        if (doFill) {
            NBTTagCompound tag = ItemUtils.getTagCompound(container, true);
            resource.writeToNBT(tag);
        }
        return this.getCapacity();
    }
}

