/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.gates;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import pl.asie.charset.gates.PartGate;

public class PartGateRSLatch
extends PartGate {
    private boolean toggled;
    private boolean burnt;

    @Override
    protected boolean tick() {
        boolean oldIS = this.getValueInside(EnumFacing.WEST) != 0;
        boolean oldIR = this.getValueInside(EnumFacing.EAST) != 0;
        super.tick();
        boolean newIS = this.getValueInside(EnumFacing.WEST) != 0;
        boolean newIR = this.getValueInside(EnumFacing.EAST) != 0;
        boolean bl = (oldIR != newIR && newIR) | (oldIS != newIS && newIS ? 2 : 0);
        switch (bl ? 1 : 0) {
            default: {
                return false;
            }
            case 1: {
                if (this.toggled) {
                    this.toggled = false;
                    return true;
                }
                return false;
            }
            case 2: {
                if (!this.toggled) {
                    this.toggled = true;
                    return true;
                }
                return false;
            }
            case 3: 
        }
        this.burnt = true;
        BlockPos pos = this.getPos();
        this.getWorld().func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.1f), (double)((float)pos.func_177952_p() + 0.5f), new SoundEvent(new ResourceLocation("random.fizz")), SoundCategory.BLOCKS, 0.5f, 2.6f + (this.getWorld().field_73012_v.nextFloat() - this.getWorld().field_73012_v.nextFloat()) * 0.8f, true);
        return true;
    }

    @Override
    public void handlePacket(ByteBuf buf) {
        super.handlePacket(buf);
        this.burnt = buf.readBoolean();
    }

    @Override
    public void writeUpdatePacket(PacketBuffer buf) {
        super.writeUpdatePacket(buf);
        buf.writeBoolean(this.burnt);
    }

    @Override
    public boolean canBlockSide(EnumFacing side) {
        return false;
    }

    @Override
    public boolean canInvertSide(EnumFacing side) {
        return false;
    }

    @Override
    public PartGate.Connection getType(EnumFacing dir) {
        return dir.func_176740_k() == EnumFacing.Axis.X ? PartGate.Connection.INPUT_OUTPUT : PartGate.Connection.OUTPUT;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("tg", this.toggled);
        tag.func_74757_a("br", this.burnt);
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.toggled = tag.func_74767_n("tg");
        this.burnt = tag.func_74767_n("br");
        super.readFromNBT(tag);
    }

    @Override
    public PartGate.State getLayerState(int id) {
        if (this.burnt) {
            return PartGate.State.OFF;
        }
        switch (id) {
            case 1: {
                return PartGate.State.input(this.getValueInside(EnumFacing.NORTH));
            }
            case 0: {
                return PartGate.State.input(this.getValueInside(EnumFacing.SOUTH));
            }
        }
        return null;
    }

    @Override
    public PartGate.State getTorchState(int id) {
        if (this.burnt) {
            return PartGate.State.OFF;
        }
        switch (id) {
            case 0: {
                return PartGate.State.input(this.getValueInside(EnumFacing.NORTH));
            }
            case 1: {
                return PartGate.State.input(this.getValueInside(EnumFacing.SOUTH));
            }
        }
        return null;
    }

    @Override
    public byte calculateOutputInside(EnumFacing facing) {
        if (this.burnt) {
            return 0;
        }
        return this.toggled ^ (facing == EnumFacing.NORTH || facing == EnumFacing.EAST) ? (byte)15 : 0;
    }
}

