/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.notify;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.lib.notify.NotificationCoord;
import pl.asie.charset.lib.notify.NotifyImplementation;

public class NotifyNetwork {
    static final String channelName = "fzNotify";
    static FMLEventChannel channel;
    static final byte COORD = 0;
    static final byte VEC3 = 1;
    static final byte ENTITY = 2;
    static final byte TILEENTITY = 3;
    static final byte ONSCREEN = 4;
    static final byte REPLACEABLE = 5;

    public NotifyNetwork() {
        channel = NetworkRegistry.INSTANCE.newEventDrivenChannel(channelName);
        channel.register((Object)this);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void recievePacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        try {
            this.handleNotify(event.getPacket().payload(), (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    void handleNotify(ByteBuf input, EntityPlayer me) throws IOException {
        Object target = null;
        switch (input.readByte()) {
            case 0: {
                BlockPos pos = new BlockPos(input.readInt(), input.readInt(), input.readInt());
                target = new NotificationCoord(me.field_70170_p, pos);
                break;
            }
            case 2: {
                int id = input.readInt();
                if (id == me.func_145782_y()) {
                    target = me;
                    break;
                }
                target = me.field_70170_p.func_73045_a(id);
                break;
            }
            case 3: {
                BlockPos pos = new BlockPos(input.readInt(), input.readInt(), input.readInt());
                target = me.field_70170_p.func_175625_s(pos);
                if (target != null) break;
                target = new NotificationCoord(me.field_70170_p, pos);
                break;
            }
            case 1: {
                target = new Vec3d(input.readDouble(), input.readDouble(), input.readDouble());
                break;
            }
            case 4: {
                String message = ByteBufUtils.readUTF8String((ByteBuf)input);
                String[] formatArgs = NotifyNetwork.readStrings(input);
                NotifyImplementation.proxy.onscreen(message, formatArgs);
                return;
            }
            case 5: {
                String str = ByteBufUtils.readUTF8String((ByteBuf)input);
                int msgKey = input.readInt();
                ITextComponent msg = ITextComponent.Serializer.func_150699_a((String)str);
                NotifyImplementation.proxy.replaceable(msg, msgKey);
                return;
            }
            default: {
                return;
            }
        }
        if (target == null) {
            return;
        }
        ItemStack item = ByteBufUtils.readItemStack((ByteBuf)input);
        String msg = ByteBufUtils.readUTF8String((ByteBuf)input);
        String[] args = NotifyNetwork.readStrings(input);
        NotifyImplementation.recieve(me, target, item, msg, args);
    }

    static void broadcast(FMLProxyPacket packet, EntityPlayer player, NetworkRegistry.TargetPoint area) {
        if (player == null) {
            channel.sendToAll(packet);
        } else if (player instanceof EntityPlayerMP) {
            channel.sendTo(packet, (EntityPlayerMP)player);
        }
    }

    private static void writeStrings(ByteBuf output, String[] args) throws IOException {
        output.writeByte((int)((byte)args.length));
        for (String s : args) {
            if (s == null) {
                s = "null";
            }
            ByteBufUtils.writeUTF8String((ByteBuf)output, (String)s);
        }
    }

    private static String[] readStrings(ByteBuf input) throws IOException {
        String[] ret = new String[input.readByte()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ByteBufUtils.readUTF8String((ByteBuf)input);
        }
        return ret;
    }

    static FMLProxyPacket notifyPacket(Object where, ItemStack item, String format, String ... args) {
        try {
            ByteBuf output = Unpooled.buffer();
            if (where instanceof NotificationCoord) {
                where = ((NotificationCoord)where).getPos();
            }
            if (where instanceof Vec3d) {
                output.writeByte(1);
                Vec3d v = (Vec3d)where;
                output.writeDouble(v.field_72450_a);
                output.writeDouble(v.field_72448_b);
                output.writeDouble(v.field_72449_c);
            } else if (where instanceof BlockPos) {
                output.writeByte(0);
                BlockPos pos = (BlockPos)where;
                output.writeInt(pos.func_177958_n());
                output.writeInt(pos.func_177956_o());
                output.writeInt(pos.func_177952_p());
            } else if (where instanceof Entity) {
                output.writeByte(2);
                Entity ent = (Entity)where;
                output.writeInt(ent.func_145782_y());
            } else if (where instanceof TileEntity) {
                output.writeByte(3);
                TileEntity te = (TileEntity)where;
                output.writeInt(te.func_174877_v().func_177958_n());
                output.writeInt(te.func_174877_v().func_177956_o());
                output.writeInt(te.func_174877_v().func_177952_p());
            } else {
                return null;
            }
            if (item != null && item.func_77973_b() == null) {
                item = null;
            }
            ByteBufUtils.writeItemStack((ByteBuf)output, (ItemStack)item);
            ByteBufUtils.writeUTF8String((ByteBuf)output, (String)format);
            NotifyNetwork.writeStrings(output, args);
            return NotifyNetwork.generate(output);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    static FMLProxyPacket onscreenPacket(String message, String[] formatArgs) {
        try {
            ByteBuf output = Unpooled.buffer();
            output.writeByte(4);
            ByteBufUtils.writeUTF8String((ByteBuf)output, (String)message);
            NotifyNetwork.writeStrings(output, formatArgs);
            return NotifyNetwork.generate(output);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    static FMLProxyPacket replaceableChatPacket(ITextComponent msg, int msgKey) {
        String str = ITextComponent.Serializer.func_150696_a((ITextComponent)msg);
        ByteBuf output = Unpooled.buffer();
        output.writeByte(5);
        ByteBufUtils.writeUTF8String((ByteBuf)output, (String)str);
        output.writeInt(msgKey);
        return NotifyNetwork.generate(output);
    }

    public static FMLProxyPacket generate(ByteBuf buf) {
        return new FMLProxyPacket(new PacketBuffer(buf), channelName);
    }
}

