/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.notify;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.lib.notify.Notice;
import pl.asie.charset.lib.notify.NotificationCoord;
import pl.asie.charset.lib.notify.Style;

public enum PointNetworkHandler {
    INSTANCE;

    String channelName = "fzNotify|point";
    FMLEventChannel channel;
    static final byte COORD = 1;
    static final byte ENTITY = 2;

    void initialize() {
        this.channel = NetworkRegistry.INSTANCE.newEventDrivenChannel(this.channelName);
        this.channel.register((Object)this);
    }

    @SubscribeEvent
    public void recievePacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        try {
            EntityPlayerMP player = ((NetHandlerPlayServer)event.getHandler()).field_147369_b;
            this.handlePoint(event.getPacket().payload(), (EntityPlayer)player);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void handlePoint(ByteBuf input, EntityPlayer player) throws IOException {
        Notice notice;
        switch (input.readByte()) {
            default: {
                return;
            }
            case 1: {
                BlockPos pos = new BlockPos(input.readInt(), input.readInt(), input.readInt());
                String msg = this.buildMessage(player, input);
                NotificationCoord at = new NotificationCoord(player.field_70170_p, pos);
                notice = new Notice(at, msg, new String[0]);
                break;
            }
            case 2: {
                int entityId = input.readInt();
                String msg = this.buildMessage(player, input);
                Entity ent = player.field_70170_p.func_73045_a(entityId);
                if (ent == null) {
                    return;
                }
                notice = new Notice(ent, msg, new String[0]);
                break;
            }
        }
        notice.withStyle(Style.DRAWFAR, Style.VERY_LONG, Style.SCALE_SIZE, Style.EXACTPOSITION);
        double maxDist = 65025.0;
        for (EntityPlayer viewer : player.field_70170_p.field_73010_i) {
            if (player.func_70068_e((Entity)viewer) > maxDist) continue;
            notice.sendTo(viewer);
        }
    }

    private String buildMessage(EntityPlayer player, ByteBuf input) throws IOException {
        String base = "<" + player.func_70005_c_() + ">";
        String msg = ByteBufUtils.readUTF8String((ByteBuf)input);
        if (msg == null || msg.length() == 0) {
            return base;
        }
        return base + "\n" + msg;
    }

    @SideOnly(value=Side.CLIENT)
    void pointAtCoord(NotificationCoord coord, String msg) throws IOException {
        ByteBuf out = Unpooled.buffer();
        out.writeByte(1);
        out.writeInt(coord.getPos().func_177958_n());
        out.writeInt(coord.getPos().func_177956_o());
        out.writeInt(coord.getPos().func_177952_p());
        ByteBufUtils.writeUTF8String((ByteBuf)out, (String)msg);
        this.send(out);
    }

    @SideOnly(value=Side.CLIENT)
    void pointAtEntity(Entity ent, String msg) throws IOException {
        if (ent == null) {
            return;
        }
        ByteBuf out = Unpooled.buffer();
        out.writeByte(2);
        out.writeInt(ent.func_145782_y());
        ByteBufUtils.writeUTF8String((ByteBuf)out, (String)msg);
        this.send(out);
    }

    @SideOnly(value=Side.CLIENT)
    void send(ByteBuf out) {
        this.channel.sendToServer(new FMLProxyPacket(new PacketBuffer(out), this.channelName));
    }
}

