/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.render;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.lwjgl.util.vector.Vector3f;
import pl.asie.charset.lib.misc.IConnectable;
import pl.asie.charset.lib.render.BaseBakedModel;
import pl.asie.charset.lib.utils.RenderUtils;

public abstract class ModelPipeLike<T extends IConnectable>
extends BaseBakedModel {
    private static final EnumFacing[][] CONNECTION_DIRS = new EnumFacing[][]{{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST}, {EnumFacing.SOUTH, EnumFacing.NORTH, EnumFacing.WEST, EnumFacing.EAST}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.WEST, EnumFacing.EAST}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.EAST, EnumFacing.WEST}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.SOUTH, EnumFacing.NORTH}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.SOUTH}};
    private final ModelRotation[] ROTATIONS = new ModelRotation[]{ModelRotation.X0_Y0, ModelRotation.X180_Y0, ModelRotation.X270_Y0, ModelRotation.X270_Y180, ModelRotation.X270_Y270, ModelRotation.X270_Y90};
    private final List<BakedQuad>[] lists = new List[65];
    private final IUnlistedProperty<T> property;

    public ModelPipeLike(IUnlistedProperty<T> property) {
        this.property = property;
        for (int i = 0; i < 64; ++i) {
            boolean[] connections = new boolean[6];
            for (int j = 0; j < 6; ++j) {
                if ((i & 1 << j) == 0) continue;
                connections[5 - j] = true;
            }
            this.lists[i] = ImmutableList.copyOf(this.generateQuads(connections));
        }
        this.lists[64] = this.lists[48];
        this.addDefaultBlockTransforms();
    }

    public int getOutsideColor(EnumFacing facing) {
        return -1;
    }

    public int getInsideColor(EnumFacing facing) {
        return -1;
    }

    public abstract float getThickness();

    public abstract boolean isOpaque();

    public abstract TextureAtlasSprite getTexture(EnumFacing var1, int var2);

    protected List<BakedQuad> generateQuads(boolean[] connections) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            Vector3f to;
            Vector3f from;
            EnumFacing[] neighbors = CONNECTION_DIRS[facing.ordinal()];
            int connectionMatrix = (connections[neighbors[0].ordinal()] ? 8 : 0) | (connections[neighbors[1].ordinal()] ? 4 : 0) | (connections[neighbors[2].ordinal()] ? 2 : 0) | (connections[neighbors[3].ordinal()] ? 1 : 0);
            TextureAtlasSprite sprite = this.getTexture(facing, connectionMatrix);
            float min = 8.0f - this.getThickness() / 2.0f;
            float max = 8.0f + this.getThickness() / 2.0f;
            int outsideColor = this.getOutsideColor(facing);
            int insideColor = this.getInsideColor(facing);
            if (!this.isOpaque() && connections[facing.ordinal()]) {
                if (connections[neighbors[2].ordinal()]) {
                    from = new Vector3f(0.0f, min, min);
                    to = new Vector3f(min, min, max);
                    quads.add(RenderUtils.BAKERY.makeBakedQuad(from, to, outsideColor, sprite, EnumFacing.DOWN, this.ROTATIONS[facing.ordinal()], true));
                    quads.add(RenderUtils.BAKERY.makeBakedQuad(from, to, insideColor, sprite, EnumFacing.UP, this.ROTATIONS[facing.ordinal()], true));
                }
                if (connections[neighbors[0].ordinal()]) {
                    from = new Vector3f(min, min, 0.0f);
                    to = new Vector3f(max, min, min);
                    quads.add(RenderUtils.BAKERY.makeBakedQuad(from, to, outsideColor, sprite, EnumFacing.DOWN, this.ROTATIONS[facing.ordinal()], true));
                    quads.add(RenderUtils.BAKERY.makeBakedQuad(from, to, insideColor, sprite, EnumFacing.UP, this.ROTATIONS[facing.ordinal()], true));
                }
                if (connections[neighbors[3].ordinal()]) {
                    from = new Vector3f(max, min, min);
                    to = new Vector3f(16.0f, min, max);
                    quads.add(RenderUtils.BAKERY.makeBakedQuad(from, to, outsideColor, sprite, EnumFacing.DOWN, this.ROTATIONS[facing.ordinal()], true));
                    quads.add(RenderUtils.BAKERY.makeBakedQuad(from, to, insideColor, sprite, EnumFacing.UP, this.ROTATIONS[facing.ordinal()], true));
                }
                if (!connections[neighbors[1].ordinal()]) continue;
                from = new Vector3f(min, min, max);
                to = new Vector3f(max, min, 16.0f);
                quads.add(RenderUtils.BAKERY.makeBakedQuad(from, to, outsideColor, sprite, EnumFacing.DOWN, this.ROTATIONS[facing.ordinal()], true));
                quads.add(RenderUtils.BAKERY.makeBakedQuad(from, to, insideColor, sprite, EnumFacing.UP, this.ROTATIONS[facing.ordinal()], true));
                continue;
            }
            from = new Vector3f(connections[neighbors[2].ordinal()] ? 0.0f : min, min, connections[neighbors[0].ordinal()] ? 0.0f : min);
            to = new Vector3f(connections[neighbors[3].ordinal()] ? 16.0f : max, min, connections[neighbors[1].ordinal()] ? 16.0f : max);
            quads.add(RenderUtils.BAKERY.makeBakedQuad(from, to, outsideColor, sprite, EnumFacing.DOWN, this.ROTATIONS[facing.ordinal()], true));
            if (this.isOpaque()) continue;
            quads.add(RenderUtils.BAKERY.makeBakedQuad(from, to, insideColor, sprite, EnumFacing.UP, this.ROTATIONS[facing.ordinal()], true));
        }
        return quads;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (side != null) {
            return Collections.emptyList();
        }
        IConnectable target = null;
        if (state instanceof IExtendedBlockState) {
            target = (IConnectable)((IExtendedBlockState)state).getValue(this.property);
        }
        if (target == null) {
            return this.lists[64];
        }
        int pointer = 0;
        for (EnumFacing f : EnumFacing.field_82609_l) {
            pointer = pointer << 1 | (target.connects(f) ? 1 : 0);
        }
        return this.lists[pointer];
    }
}

