/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.render;

import java.awt.image.BufferedImage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import pl.asie.charset.lib.ModCharsetLib;
import pl.asie.charset.lib.utils.RenderUtils;

public class SpritesheetFactory {
    private final ResourceLocation location;
    private final int width;
    private final int height;

    private SpritesheetFactory(ResourceLocation location, int width, int height) {
        this.location = location;
        this.width = width;
        this.height = height;
    }

    public static TextureAtlasSprite[] register(TextureMap map, ResourceLocation location, int width, int height) {
        SpritesheetFactory factory = new SpritesheetFactory(location, width, height);
        return factory.register(map);
    }

    public TextureAtlasSprite[] register(TextureMap map) {
        TextureAtlasSprite[] sprites = new TextureAtlasSprite[this.width * this.height];
        for (int i = 0; i < sprites.length; ++i) {
            String s = String.format(this.location.toString() + "#%d", i);
            sprites[i] = map.getTextureExtry(s);
            if (sprites[i] != null) continue;
            sprites[i] = new SliceSprite(new ResourceLocation(s), this.location, i, this.width, this.height);
            map.setTextureEntry(s, sprites[i]);
        }
        return sprites;
    }

    protected static class SliceSprite
    extends TextureAtlasSprite {
        private final ResourceLocation location;
        private final int x;
        private final int y;
        private final int width;
        private final int height;
        private BufferedImage sheet;

        protected SliceSprite(ResourceLocation loc, ResourceLocation location, int i, int width, int height) {
            super(loc.toString());
            this.location = location;
            this.width = width;
            this.height = height;
            this.x = i % width;
            this.y = i / width;
        }

        public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
            return true;
        }

        public boolean load(IResourceManager manager, ResourceLocation loc) {
            if (this.sheet == null) {
                this.sheet = RenderUtils.getBufferedImage(this.location);
                if (this.sheet == null) {
                    ModCharsetLib.logger.warn("Could not find texture sheet " + this.location + "!");
                    return false;
                }
            }
            int pieceWidth = this.sheet.getWidth() / this.width;
            int pieceHeight = this.sheet.getHeight() / this.height;
            this.func_110966_b(pieceWidth);
            this.func_110969_c(pieceHeight);
            int[][] pixels = new int[Minecraft.func_71410_x().field_71474_y.field_151442_I + 1][];
            pixels[0] = new int[pieceWidth * pieceHeight];
            this.sheet.getRGB(pieceWidth * this.x, pieceHeight * this.y, pieceWidth, pieceHeight, pixels[0], 0, pieceWidth);
            this.func_130103_l();
            this.field_110976_a.add(pixels);
            return false;
        }
    }
}

