/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.wires;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import mcmultipart.MCMultiPartMod;
import mcmultipart.capabilities.ISlottedCapabilityProvider;
import mcmultipart.client.multipart.AdvancedParticleManager;
import mcmultipart.client.multipart.ICustomHighlightPart;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.INormallyOccludingPart;
import mcmultipart.multipart.ISlottedPart;
import mcmultipart.multipart.Multipart;
import mcmultipart.multipart.MultipartHelper;
import mcmultipart.multipart.OcclusionHelper;
import mcmultipart.multipart.PartSlot;
import mcmultipart.raytrace.PartMOP;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.api.wires.WireFace;
import pl.asie.charset.lib.ModCharsetLib;
import pl.asie.charset.lib.render.IRenderComparable;
import pl.asie.charset.lib.utils.GenericExtendedProperty;
import pl.asie.charset.lib.utils.RotationUtils;
import pl.asie.charset.lib.wires.WireFactory;
import pl.asie.charset.lib.wires.WireManager;
import pl.asie.charset.lib.wires.WireUtils;

public abstract class PartWire
extends Multipart
implements IRenderComparable<PartWire>,
ICustomHighlightPart,
ISlottedPart,
INormallyOccludingPart,
ITickable,
ISlottedCapabilityProvider {
    public static final GenericExtendedProperty<PartWire> PROPERTY = new GenericExtendedProperty<PartWire>("part", PartWire.class);
    private static final Map<WireFactory, AxisAlignedBB[]> BOXES = new HashMap<WireFactory, AxisAlignedBB[]>();
    public WireFace location;
    protected byte internalConnections;
    protected byte externalConnections;
    protected byte cornerConnections;
    protected byte occludedSides;
    protected byte cornerOccludedSides;
    private boolean suLogic;
    private boolean suRender;
    private boolean suConnection;
    private int suNeighbor;
    private WireFactory type;

    public PartWire() {
        this.scheduleConnectionUpdate();
    }

    public ResourceLocation getType() {
        return this.getFactory().getRegistryName();
    }

    protected WireFactory getFactory() {
        return this.type;
    }

    public PartWire setFactory(WireFactory factory) {
        this.type = factory;
        return this;
    }

    public boolean calculateConnectionWire(PartWire wire) {
        return wire.getFactory() == this.getFactory();
    }

    public boolean calculateConnectionNonWire(BlockPos pos, EnumFacing direction) {
        return false;
    }

    public String getDisplayName() {
        return "wire.null";
    }

    public float getHardness(PartMOP hit) {
        return 0.2f;
    }

    public ResourceLocation getModelPath() {
        return new ResourceLocation("charsetlib:wire");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(AdvancedParticleManager AdvancedParticleManager2) {
        return true;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        this.addSelectionBoxes(list);
        return (AxisAlignedBB)list.get(0);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(PartMOP partMOP, AdvancedParticleManager AdvancedParticleManager2) {
        return true;
    }

    public void onPartChanged(IMultipart part) {
        this.scheduleConnectionUpdate();
        this.scheduleLogicUpdate();
    }

    public void onNeighborBlockChange(Block block) {
        if (this.location != WireFace.CENTER && !this.getFactory().canPlace((IBlockAccess)this.getWorld(), this.getPos(), this.location)) {
            this.harvest(null, null);
            return;
        }
        this.scheduleConnectionUpdate();
        this.scheduleLogicUpdate();
    }

    public IBlockState getExtendedState(IBlockState state) {
        return ((IExtendedBlockState)state).withProperty(PROPERTY, (Object)this);
    }

    public BlockStateContainer createBlockState() {
        return new ExtendedBlockState((Block)MCMultiPartMod.multipart, new IProperty[0], new IUnlistedProperty[]{PROPERTY});
    }

    public EnumSet<PartSlot> getSlotMask() {
        return EnumSet.of(WireUtils.getSlotForFace(this.location));
    }

    protected ItemStack getItemStack() {
        return new ItemStack((Item)WireManager.ITEM, 1, WireManager.REGISTRY.getId((IForgeRegistryEntry)this.getFactory()) << 1 | (this.location == WireFace.CENTER ? 1 : 0));
    }

    public ItemStack getPickBlock(EntityPlayer player, PartMOP hit) {
        return this.getItemStack();
    }

    public List<ItemStack> getDrops() {
        return Arrays.asList(this.getItemStack());
    }

    public void writeUpdatePacket(PacketBuffer buf) {
        buf.writeByte(WireManager.REGISTRY.getId((IForgeRegistryEntry)this.getFactory()));
        buf.writeByte(this.location.ordinal());
        buf.writeByte((int)this.internalConnections);
        buf.writeByte((int)this.externalConnections);
        if (this.location != WireFace.CENTER) {
            buf.writeByte((int)this.cornerConnections);
        }
    }

    public void handlePacket(ByteBuf buf) {
        this.location = WireFace.VALUES[buf.readByte()];
        byte oldIC = this.internalConnections;
        byte oldEC = this.externalConnections;
        byte oldCC = this.cornerConnections;
        this.internalConnections = buf.readByte();
        this.externalConnections = buf.readByte();
        byte by = this.cornerConnections = this.location == WireFace.CENTER ? (byte)0 : buf.readByte();
        if (oldIC != this.internalConnections || oldEC != this.externalConnections || oldCC != this.cornerConnections) {
            this.markRenderUpdate();
        }
    }

    public final void readUpdatePacket(PacketBuffer buf) {
        this.setFactory((WireFactory)WireManager.REGISTRY.getObjectById((int)buf.readByte()));
        if (!Minecraft.func_71410_x().func_152345_ab()) {
            final ByteBuf buf2 = Unpooled.copiedBuffer((ByteBuf)buf);
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    PartWire.this.handlePacket(buf2);
                }
            });
        } else {
            this.handlePacket((ByteBuf)buf);
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("f")) {
            this.setFactory((WireFactory)WireManager.REGISTRY.getObjectById((int)nbt.func_74771_c("f")));
        }
        this.location = WireFace.VALUES[nbt.func_74771_c("l")];
        this.internalConnections = nbt.func_74771_c("iC");
        this.externalConnections = nbt.func_74771_c("eC");
        this.cornerConnections = nbt.func_74771_c("cC");
        this.occludedSides = nbt.func_74771_c("oS");
        this.cornerOccludedSides = nbt.func_74771_c("coS");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74774_a("f", (byte)WireManager.REGISTRY.getId((IForgeRegistryEntry)this.getFactory()));
        nbt.func_74774_a("l", (byte)this.location.ordinal());
        nbt.func_74774_a("iC", this.internalConnections);
        nbt.func_74774_a("eC", this.externalConnections);
        if (this.location != WireFace.CENTER) {
            nbt.func_74774_a("cC", this.cornerConnections);
        }
        nbt.func_74774_a("oS", this.occludedSides);
        nbt.func_74774_a("coS", this.cornerOccludedSides);
        return nbt;
    }

    public void onAdded() {
        this.scheduleConnectionUpdate();
        this.scheduleLogicUpdate();
    }

    public void onRemoved() {
        this.neighborUpdate(0);
    }

    private AxisAlignedBB[] getBoxes() {
        AxisAlignedBB[] boxes = BOXES.get(this.type);
        if (boxes == null) {
            boxes = new AxisAlignedBB[67];
            float xMin = 0.5f - this.type.getWidth() / 2.0f;
            float xMax = 0.5f + this.type.getWidth() / 2.0f;
            float y = this.type.getHeight();
            for (int j = 0; j < 6; ++j) {
                EnumFacing f = EnumFacing.func_82600_a((int)j);
                EnumFacing[] faces = WireUtils.getConnectionsForRender(WireFace.get(f));
                for (int i = 0; i < faces.length; ++i) {
                    if (i >= 2) {
                        if (faces[i].func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
                            boxes[j * 5 + i + 1] = RotationUtils.rotateFace(new AxisAlignedBB(0.0, 0.0, (double)xMin, (double)xMin, (double)y, (double)xMax), f);
                            boxes[43 + j * 4 + i] = RotationUtils.rotateFace(new AxisAlignedBB(0.0, 0.0, (double)xMin, (double)y, (double)y, (double)xMax), f);
                            continue;
                        }
                        boxes[j * 5 + i + 1] = RotationUtils.rotateFace(new AxisAlignedBB((double)xMax, 0.0, (double)xMin, 1.0, (double)y, (double)xMax), f);
                        boxes[43 + j * 4 + i] = RotationUtils.rotateFace(new AxisAlignedBB((double)(1.0f - y), 0.0, (double)xMin, 1.0, (double)y, (double)xMax), f);
                        continue;
                    }
                    if (faces[i].func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
                        boxes[j * 5 + i + 1] = RotationUtils.rotateFace(new AxisAlignedBB((double)xMin, 0.0, 0.0, (double)xMax, (double)y, (double)xMin), f);
                        boxes[43 + j * 4 + i] = RotationUtils.rotateFace(new AxisAlignedBB((double)xMin, 0.0, 0.0, (double)xMax, (double)y, (double)y), f);
                        continue;
                    }
                    boxes[j * 5 + i + 1] = RotationUtils.rotateFace(new AxisAlignedBB((double)xMin, 0.0, (double)xMax, (double)xMax, (double)y, 1.0), f);
                    boxes[43 + j * 4 + i] = RotationUtils.rotateFace(new AxisAlignedBB((double)xMin, 0.0, (double)(1.0f - y), (double)xMax, (double)y, 1.0), f);
                }
                boxes[j * 5 + 0] = RotationUtils.rotateFace(new AxisAlignedBB((double)xMin, 0.0, (double)xMin, (double)xMax, (double)y, (double)xMax), f);
                boxes[31 + j] = RotationUtils.rotateFace(new AxisAlignedBB((double)xMin, (double)y, (double)xMin, (double)xMax, (double)xMin, (double)xMax), f);
                boxes[37 + j] = RotationUtils.rotateFace(new AxisAlignedBB((double)xMin, 0.0, (double)xMin, (double)xMax, (double)xMin, (double)xMax), f);
            }
            boxes[30] = new AxisAlignedBB((double)xMin, (double)xMin, (double)xMin, (double)xMax, (double)xMax, (double)xMax);
            BOXES.put(this.type, boxes);
        }
        return boxes;
    }

    public AxisAlignedBB getCenterBox(int i) {
        AxisAlignedBB[] boxes = this.getBoxes();
        return boxes[30 + i];
    }

    public AxisAlignedBB getSelectionBox(int i) {
        return this.getBox(i > 0 && this.location == WireFace.CENTER ? i + 6 : i);
    }

    public AxisAlignedBB getBox(int i) {
        AxisAlignedBB[] boxes = this.getBoxes();
        return boxes[this.location.ordinal() * 5 + i];
    }

    public AxisAlignedBB getCornerCollisionBox(EnumFacing facing) {
        EnumFacing[] facings = WireUtils.getConnectionsForRender(this.location);
        for (int i = 0; i < facings.length; ++i) {
            if (facing != facings[i]) continue;
            return this.getCornerBox(i);
        }
        return null;
    }

    private AxisAlignedBB getCornerBox(int i) {
        AxisAlignedBB[] boxes = this.getBoxes();
        return boxes[43 + this.location.ordinal() * 4 + i];
    }

    public void addOcclusionBoxes(List<AxisAlignedBB> list) {
        list.add(this.getBox(0));
    }

    public void addSelectionBoxes(List<AxisAlignedBB> list) {
        list.add(this.getSelectionBox(0));
        EnumFacing[] faces = WireUtils.getConnectionsForRender(this.location);
        for (int i = 0; i < faces.length; ++i) {
            if (!this.connectsAny(faces[i])) continue;
            list.add(this.getSelectionBox(i + 1));
        }
    }

    protected abstract void logicUpdate();

    public void addCollisionBoxes(AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        AxisAlignedBB bb = this.getBox(0);
        if (mask.func_72326_a(bb)) {
            list.add(bb);
        }
        EnumFacing[] faces = WireUtils.getConnectionsForRender(this.location);
        for (int i = 0; i < faces.length; ++i) {
            if (!this.connectsAny(faces[i]) || !mask.func_72326_a(bb = this.getBox(i + 1))) continue;
            list.add(bb);
        }
    }

    public void scheduleRenderUpdate() {
        this.suRender = true;
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT;
    }

    protected void neighborUpdate(int sides) {
        if (this.getContainer() != null) {
            for (IMultipart multipart : this.getContainer().getParts()) {
                if (!(multipart instanceof PartWire)) continue;
                multipart.onNeighborBlockChange((Block)MCMultiPartMod.multipart);
            }
        }
        World world = this.getWorld();
        BlockPos pos = this.getPos();
        if (world != null) {
            world.func_175722_b(pos, (Block)MCMultiPartMod.multipart);
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                world.func_175695_a(pos.func_177972_a(facing), (Block)MCMultiPartMod.multipart, facing.func_176734_d());
            }
        }
    }

    public void func_73660_a() {
        int it;
        World world = this.getWorld();
        if (world == null) {
            return;
        }
        if (this.location == null) {
            this.getContainer().removePart((IMultipart)this);
            return;
        }
        if (this.suConnection) {
            this.suConnection = false;
            this.updateConnections();
        }
        if (this.suNeighbor != 0) {
            it = this.suNeighbor;
            this.suNeighbor = 0;
            this.neighborUpdate(it);
        }
        if (this.suLogic) {
            this.suLogic = false;
            this.logicUpdate();
        }
        if (this.suNeighbor != 0) {
            it = this.suNeighbor;
            this.suNeighbor = 0;
            this.neighborUpdate(it);
        }
        if (this.suRender) {
            this.suRender = false;
            if (world.field_72995_K) {
                this.markRenderUpdate();
            } else {
                this.sendUpdatePacket();
            }
        }
    }

    public boolean isOccluded(EnumFacing face) {
        if (this.suConnection) {
            this.suConnection = false;
            this.updateConnections();
        }
        return (this.occludedSides & 1 << face.ordinal()) != 0;
    }

    public boolean isCornerOccluded(EnumFacing face) {
        if (this.suConnection) {
            this.suConnection = false;
            this.updateConnections();
        }
        return this.isOccluded(face) || (this.cornerOccludedSides & 1 << face.ordinal()) != 0;
    }

    public void updateConnections() {
        AxisAlignedBB mask;
        EnumSet<WireFace> validSides = EnumSet.noneOf(WireFace.class);
        EnumSet<WireFace> invalidCornerSides = EnumSet.noneOf(WireFace.class);
        for (Object facing : WireFace.VALUES) {
            if (facing == this.location || facing != WireFace.CENTER && this.location != WireFace.CENTER && this.location.facing.func_176740_k() == facing.facing.func_176740_k()) continue;
            validSides.add((WireFace)((Object)facing));
        }
        int oldConnectionCache = this.internalConnections << 12 | this.externalConnections << 6 | this.cornerConnections;
        this.cornerOccludedSides = 0;
        this.occludedSides = 0;
        this.cornerConnections = 0;
        this.externalConnections = 0;
        this.internalConnections = 0;
        EnumFacing[] connFaces = WireUtils.getConnectionsForRender(this.location);
        ArrayList<IMultipart> parts = new ArrayList<IMultipart>();
        for (IMultipart p2 : this.getContainer().getParts()) {
            if (p2 == this || !(p2 instanceof INormallyOccludingPart) || p2 instanceof PartWire) continue;
            parts.add(p2);
        }
        if (parts.size() > 0) {
            for (int i = 0; i < connFaces.length; ++i) {
                WireFace face = WireFace.get(connFaces[i]);
                if (!validSides.contains((Object)face)) continue;
                boolean found = false;
                AxisAlignedBB mask2 = this.getBox(i + 1);
                if (mask2 != null && !OcclusionHelper.occlusionTest((IMultipart)OcclusionHelper.boxes((AxisAlignedBB[])new AxisAlignedBB[]{mask2}), p -> p == this, parts)) {
                    this.occludedSides = (byte)(this.occludedSides | 1 << connFaces[i].ordinal());
                    validSides.remove((Object)face);
                    found = true;
                }
                if (found || this.location == WireFace.CENTER) continue;
                BlockPos cPos = this.getPos().func_177972_a(connFaces[i]);
                AxisAlignedBB cornerMask = this.getCornerBox(i ^ 1);
                if (cornerMask == null) continue;
                IMultipartContainer cornerContainer = MultipartHelper.getPartContainer((IBlockAccess)this.getWorld(), (BlockPos)cPos);
                if (cornerContainer != null) {
                    if (OcclusionHelper.occlusionTest((IMultipart)OcclusionHelper.boxes((AxisAlignedBB[])new AxisAlignedBB[]{cornerMask}), (Iterable)cornerContainer.getParts())) continue;
                    this.cornerOccludedSides = (byte)(this.cornerOccludedSides | 1 << connFaces[i].ordinal());
                    invalidCornerSides.add(face);
                    continue;
                }
                ArrayList boxes = new ArrayList();
                IBlockState cState = this.getWorld().func_180495_p(cPos);
                cState.func_185908_a(this.getWorld(), cPos, cornerMask.func_72317_d((double)cPos.func_177958_n(), (double)cPos.func_177956_o(), (double)cPos.func_177952_p()), boxes, null);
                if (boxes.size() <= 0) continue;
                this.cornerOccludedSides = (byte)(this.cornerOccludedSides | 1 << connFaces[i].ordinal());
                invalidCornerSides.add(face);
            }
        }
        if (validSides.contains((Object)WireFace.CENTER) && (mask = this.getCenterBox(1 + this.location.ordinal())) != null && !OcclusionHelper.occlusionTest((IMultipart)OcclusionHelper.boxes((AxisAlignedBB[])new AxisAlignedBB[]{mask}), p -> p == this, parts)) {
            this.occludedSides = (byte)(this.occludedSides | 0x40);
            validSides.remove((Object)WireFace.CENTER);
        }
        for (WireFace facing : validSides) {
            if (WireUtils.canConnectInternal(this, facing)) {
                this.internalConnections = (byte)(this.internalConnections | 1 << facing.ordinal());
                continue;
            }
            if (facing == WireFace.CENTER) continue;
            if (WireUtils.canConnectExternal(this, facing.facing)) {
                this.externalConnections = (byte)(this.externalConnections | 1 << facing.ordinal());
                continue;
            }
            if (this.location == WireFace.CENTER || invalidCornerSides.contains((Object)facing) || !WireUtils.canConnectCorner(this, facing.facing)) continue;
            this.cornerConnections = (byte)(this.cornerConnections | 1 << facing.ordinal());
        }
        int newConnectionCache = this.internalConnections << 12 | this.externalConnections << 6 | this.cornerConnections;
        if (oldConnectionCache != newConnectionCache) {
            this.scheduleNeighborUpdate((oldConnectionCache ^ newConnectionCache) >> 6);
            this.scheduleLogicUpdate();
            this.scheduleRenderUpdate();
        }
    }

    protected void scheduleNeighborUpdate(int et) {
        this.suNeighbor = et & 0x3F | 0x10000;
    }

    protected void scheduleNeighborUpdate() {
        this.scheduleNeighborUpdate(0);
    }

    protected void scheduleLogicUpdate() {
        this.suLogic = true;
    }

    protected void scheduleConnectionUpdate() {
        this.suConnection = true;
    }

    public boolean connectsInternal(WireFace side) {
        return (this.internalConnections & 1 << side.ordinal()) != 0;
    }

    public boolean connectsExternal(EnumFacing side) {
        return (this.externalConnections & 1 << side.ordinal()) != 0;
    }

    public boolean connectsAny(EnumFacing direction) {
        return ((this.internalConnections | this.externalConnections | this.cornerConnections) & 1 << direction.ordinal()) != 0;
    }

    public boolean connectsCorner(EnumFacing direction) {
        return (this.cornerConnections & 1 << direction.ordinal()) != 0;
    }

    public boolean connects(EnumFacing direction) {
        return ((this.internalConnections | this.externalConnections) & 1 << direction.ordinal()) != 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderColor() {
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean drawHighlight(PartMOP partMOP, EntityPlayer player, float v) {
        ModCharsetLib.proxy.drawWireHighlight(this);
        return true;
    }

    public void setConnectionsForItemRender() {
        this.internalConnections = (byte)63;
        this.externalConnections = 0;
        this.cornerConnections = 0;
    }

    @Override
    public boolean renderEquals(PartWire other) {
        return other.type == this.type && other.location == this.location && other.internalConnections == this.internalConnections && other.externalConnections == this.externalConnections && other.cornerConnections == this.cornerConnections;
    }

    @Override
    public int renderHashCode() {
        return Objects.hash(new Object[]{this.type, this.location, this.internalConnections, this.externalConnections, this.cornerConnections});
    }
}

